/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.web.controller.user;

import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.json.ModificationConfirmation;
import eu.europeana.api2.v2.model.json.UserResults;
import eu.europeana.api2.v2.model.json.abstracts.UserObject;
import eu.europeana.api2.v2.model.json.user.SavedItem;
import eu.europeana.api2.web.controller.abstracts.AbstractUserController;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.definitions.db.entity.relational.User;
import eu.europeana.corelib.definitions.db.entity.relational.abstracts.EuropeanaUserObject;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/user/saveditem"})
@Api(value="my_europeana", description=" ")
public class UserItemController
extends AbstractUserController {
    @ApiOperation(value="list a user's data items", nickname="listUserItems")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView list(@RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.list(null, callback, principal);
    }

    @ApiOperation(value="Check if a user has item saved", nickname="listUserItems")
    @RequestMapping(value={"/{collectionId}/{recordId}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView list(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.list(EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), callback, principal);
    }

    private ModelAndView list(String europeanaId, String callback, Principal principal) {
        UserResults response = new UserResults(this.getApiId(principal));
        try {
            User user = this.userService.findByEmail(principal.getName());
            if (user != null) {
                HashSet<eu.europeana.corelib.definitions.db.entity.relational.SavedItem> results;
                response.items = new ArrayList();
                response.username = user.getUserName();
                if (StringUtils.isBlank((String)europeanaId)) {
                    results = user.getSavedItems();
                } else {
                    results = new HashSet<eu.europeana.corelib.definitions.db.entity.relational.SavedItem>();
                    results.add(this.userService.findSavedItemByEuropeanaId((Long)user.getId(), europeanaId));
                }
                response.itemsCount = results.size();
                for (eu.europeana.corelib.definitions.db.entity.relational.SavedItem item : results) {
                    SavedItem fav = new SavedItem();
                    this.copyUserObjectData(response.apikey, (UserObject)fav, (EuropeanaUserObject)item);
                    fav.author = item.getAuthor();
                    response.items.add(fav);
                }
            } else {
                response.success = false;
                response.error = "User Profile not retrievable...";
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="create a new data item for a user", nickname="createUserItem")
    @RequestMapping(value={"/{collectionId}/{recordId}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ModelAndView create(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(this.getApiId(principal));
        try {
            User user = this.userService.findByEmail(principal.getName());
            this.userService.createSavedItem((Long)user.getId(), EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId));
            response.success = true;
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="deletes a user's data item", nickname="deleteUserItem")
    @RequestMapping(value={"/{itemId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    private ModelAndView delete(@PathVariable Long itemId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete(itemId, null, callback, principal);
    }

    @ApiOperation(value="deletes a user's data item", nickname="deleteUserItem")
    @RequestMapping(value={"/{collectionId}/{recordId}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    private ModelAndView delete(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="callback", required=false) String callback, Principal principal) {
        return this.delete((Long)null, EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), callback, principal);
    }

    private ModelAndView delete(Long itemId, String europeanaId, String callback, Principal principal) {
        ModificationConfirmation response = new ModificationConfirmation(this.getApiId(principal));
        try {
            User user = this.userService.findByEmail(principal.getName());
            if (user != null) {
                response.success = true;
                if (itemId != null) {
                    this.userService.removeSavedItem((Long)user.getId(), itemId);
                } else if (StringUtils.isNotBlank((String)europeanaId)) {
                    this.userService.removeSavedItem((Long)user.getId(), europeanaId);
                } else {
                    response.success = false;
                    response.error = "Invalid arguments";
                }
            }
        }
        catch (DatabaseException e) {
            response.success = false;
            response.error = e.getMessage();
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

