/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.sugarcrm.SugarCRMSearchResults;
import eu.europeana.api2.v2.service.SugarCRMCache;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Api(tags={"Providers and Datasets"}, description=" ")
@SwaggerSelect
public class SugarCRMController {
    @Log
    private Logger log;
    @Resource
    private SugarCRMCache sugarCRMCache;
    @Resource
    private ControllerUtils controllerUtils;

    @ApiOperation(value="get the list of Europeana data providers", nickname="listProviders")
    @RequestMapping(value={"/v2/providers.json"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView findproviders(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="countryCode", required=false) String countryCode, @RequestParam(value="offset", required=false) String offset, @RequestParam(value="pagesize", required=false) String pagesize, HttpServletRequest request, HttpServletResponse httpResponse) {
        SugarCRMSearchResults response;
        LimitResponse limitResponse;
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.PROVIDERS, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        try {
            int intOffset = offset == null ? 0 : Integer.parseInt(offset);
            int intPagesize = pagesize == null ? 0 : Integer.parseInt(pagesize);
            response = this.sugarCRMCache.getProviders(countryCode, intOffset, intPagesize);
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
        }
        catch (Exception e) {
            String error = "Error fetching all providers";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="get information about a specific Europeana provider", nickname="getProvider")
    @RequestMapping(value={"/v2/provider/{id}.json"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView findprovidersByID(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) {
        SugarCRMSearchResults response;
        LimitResponse limitResponse;
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.PROVIDER, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        try {
            response = this.sugarCRMCache.getProviderbyID(id);
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.totalResults = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
            response.success = true;
        }
        catch (Exception e) {
            String error = "Error fetching all providers";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="get the list of datasets provided by a specific provider", nickname="listProviderDatasets")
    @RequestMapping(value={"/v2/provider/{id}/datasets.json"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView findDatasetsPerProvider(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) {
        SugarCRMSearchResults response;
        LimitResponse limitResponse;
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.PROVIDER_DATASETS, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        try {
            response = this.sugarCRMCache.getCollectionByProviderID(id);
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.totalResults = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
            response.success = true;
        }
        catch (Exception e) {
            String error = "Error fetching datasets by provider id";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="get the list of Europeana datasets", nickname="listDatasets")
    @RequestMapping(value={"/v2/datasets.json"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView findDatasets(@RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="edmDatasetName", required=false) String name, @RequestParam(value="countryCode", required=false) String country, @RequestParam(value="status", required=false) String status, @RequestParam(value="offset", required=false) String offset, @RequestParam(value="pagesize", required=false) String pagesize, HttpServletRequest request, HttpServletResponse httpResponse) {
        SugarCRMSearchResults response;
        LimitResponse limitResponse;
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.DATASETS, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        try {
            int intOffset = offset == null ? 0 : Integer.parseInt(offset);
            int intPagesize = pagesize == null ? 0 : Integer.parseInt(pagesize);
            response = this.sugarCRMCache.getCollections(intOffset, intPagesize, name, country, status);
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
        }
        catch (Exception e) {
            String error = "Error fetching all datasets";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }

    @ApiOperation(value="get information about a specific dataset", nickname="getDataset")
    @RequestMapping(value={"/v2/dataset/{id}.json"}, produces={"application/json"}, method={RequestMethod.GET})
    public ModelAndView findDatasetsById(@PathVariable String id, @RequestParam(value="wskey", required=false) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse httpResponse) {
        SugarCRMSearchResults response;
        LimitResponse limitResponse;
        this.controllerUtils.addResponseHeaders(httpResponse);
        Date starttime = new Date();
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.DATASETS, null);
        }
        catch (ApiLimitException e) {
            httpResponse.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        try {
            response = this.sugarCRMCache.getCollectionByID(id);
            response.apikey = wskey;
            response.requestNumber = limitResponse.getRequestNumber();
            response.itemsCount = response.items.size();
            response.totalResults = response.items.size();
            response.statsStartTime = starttime;
            Date endtime = new Date();
            response.statsDuration = endtime.getTime() - starttime.getTime();
            response.success = true;
        }
        catch (Exception e) {
            String error = "Error fetching datasets by dataset id";
            this.log.error(error, (Throwable)e);
            return JsonUtils.toJson((Object)new ApiError(wskey, error + " " + e.getMessage(), limitResponse.getRequestNumber()), (String)callback);
        }
        return JsonUtils.toJson((Object)response, (String)callback);
    }
}

