/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.corelib.web.swift.SwiftProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SitemapController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Resource
    private SwiftProvider swiftProvider;

    @RequestMapping(value={"/europeana-sitemap-index-hashed.xml"})
    public void handleSitemapIndexHashed(HttpServletResponse response) throws IOException {
        String cacheFile = "europeana-sitemap-index-hashed.xml";
        if (this.swiftProvider.getObjectApi().getWithoutBody(cacheFile) == null) {
            boolean success = false;
            ServletOutputStream out = response.getOutputStream();
            this.log.error((Object)String.format("Sitemap does not exist", new Object[0]));
        } else {
            this.readCachedSitemap(response.getOutputStream(), this.swiftProvider, cacheFile);
        }
    }

    @RequestMapping(value={"/europeana-sitemap-hashed.xml"})
    public void handleSitemap(@RequestParam(value="from", required=true) String from, @RequestParam(value="to", required=true) String to, HttpServletResponse response) throws IOException {
        String cacheFile = "europeana-sitemap-hashed.xml?from=" + from + "&to=" + to;
        if (this.swiftProvider.getObjectApi().getWithoutBody(cacheFile) == null) {
            this.log.info((Object)String.format("Error processing %s", cacheFile));
        } else {
            ServletOutputStream out = response.getOutputStream();
            this.readCachedSitemap(out, this.swiftProvider, cacheFile);
        }
    }

    private void readCachedSitemap(ServletOutputStream out, SwiftProvider swiftProvider, String cacheFile) {
        try {
            StringWriter writer = new StringWriter();
            InputStream in = swiftProvider.getObjectApi().get(cacheFile).getPayload().openStream();
            IOUtils.copy((InputStream)in, (Writer)writer);
            out.println(writer.toString());
            in.close();
            out.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

