/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.FieldTripUtils;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.utils.XmlUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.SearchResults;
import eu.europeana.api2.v2.model.json.Suggestions;
import eu.europeana.api2.v2.model.json.view.ApiView;
import eu.europeana.api2.v2.model.json.view.BriefView;
import eu.europeana.api2.v2.model.json.view.RichView;
import eu.europeana.api2.v2.model.xml.kml.KmlResponse;
import eu.europeana.api2.v2.model.xml.rss.Channel;
import eu.europeana.api2.v2.model.xml.rss.Item;
import eu.europeana.api2.v2.model.xml.rss.RssResponse;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripChannel;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripImage;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripItem;
import eu.europeana.api2.v2.model.xml.rss.fieldtrip.FieldTripResponse;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.utils.FacetParameterUtils;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.db.exception.DatabaseException;
import eu.europeana.corelib.db.exception.LimitReachedException;
import eu.europeana.corelib.db.service.ApiKeyService;
import eu.europeana.corelib.definitions.db.entity.relational.ApiKey;
import eu.europeana.corelib.definitions.edm.beans.ApiBean;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.beans.RichBean;
import eu.europeana.corelib.definitions.exception.ProblemType;
import eu.europeana.corelib.definitions.solr.Facet;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.utils.StringArrayUtils;
import eu.europeana.corelib.web.model.rights.RightReusabilityCategorizer;
import eu.europeana.corelib.web.service.EuropeanaUrlService;
import eu.europeana.corelib.web.support.Configuration;
import eu.europeana.corelib.web.utils.NavigationUtils;
import eu.europeana.corelib.web.utils.RequestUtils;
import eu.europeana.crf_faketags.utils.FakeTagsUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@SwaggerSelect
@Api(tags={"Search"}, description=" ")
public class SearchController {
    public static final int FACET_LIMIT = 16;
    @Log
    private Logger log;
    @Resource
    private SearchService searchService;
    @Resource
    private ApiKeyService apiService;
    @Resource
    private Configuration configuration;
    @Resource
    private EuropeanaUrlService urlService;
    @Resource
    private ControllerUtils controllerUtils;
    @Resource(name="api2_mvc_xmlUtils")
    private XmlUtils xmlUtils;
    @Resource
    private MessageSource messageSource;

    public static String[] limitFacets(String[] facets, boolean isDefaultFacetsRequested) {
        List<String> requestedFacets = Arrays.asList(facets);
        ArrayList<String> allowedFacets = new ArrayList<String>();
        int count = 0;
        if (isDefaultFacetsRequested && !requestedFacets.contains("DEFAULT")) {
            count = Facet.values().length;
        }
        for (String facet : requestedFacets) {
            int increment = 1;
            if (StringUtils.equals((String)facet, (String)"DEFAULT")) {
                increment = Facet.values().length;
            }
            if (count + increment > 16) break;
            allowedFacets.add(facet);
            count += increment;
        }
        return allowedFacets.toArray(new String[allowedFacets.size()]);
    }

    @ApiOperation(value="search for records", nickname="searchRecords", response=Void.class)
    @RequestMapping(value={"/v2/search.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView searchJson(@RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="query", required=false) String queryString, @RequestParam(value="qf", required=false) String[] refinements, @RequestParam(value="reusability", required=false) String[] aReusability, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="start", required=false, defaultValue="1") int start, @RequestParam(value="rows", required=false, defaultValue="12") int rows, @RequestParam(value="facet", required=false) String[] aFacet, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="colourpalette", required=false) String[] colorPalette, @RequestParam(value="text_fulltext", required=false) Boolean isFulltext, @RequestParam(value="thumbnail", required=false) Boolean thumbnail, @RequestParam(value="media", required=false) Boolean media, @RequestParam(value="sound_duration", required=false) String[] sound_duration, @RequestParam(value="sound_hq", required=false) Boolean sound_hq, @RequestParam(value="video_duration", required=false) String[] video_duration, @RequestParam(value="video_hd", required=false) Boolean video_hd, @RequestParam(value="image_colour", required=false) Boolean image_colour, @RequestParam(value="image_aspectratio", required=false) String[] image_aspectratio, @RequestParam(value="image_size", required=false) String[] image_size, @RequestParam(value="has_landingpage", required=false) Boolean hasLandingPage, @RequestParam(value="cursor", required=false) String cursorMark, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        Integer videoFilterTag;
        LimitResponse limitResponse;
        try {
            limitResponse = this.controllerUtils.checkLimit(wskey, request.getRequestURL().toString(), RecordType.SEARCH, profile);
        }
        catch (ApiLimitException e) {
            response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)callback);
        }
        if (StringUtils.isBlank((String)queryString)) {
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError("", (queryString == null ? "Missing" : "Invalid") + " query parameter"), (String)callback);
        }
        queryString = queryString.trim();
        this.log.info("QUERY: |" + queryString + "|");
        String[] _qf = (String[])request.getParameterMap().get("qf");
        if (_qf != null && _qf.length != refinements.length) {
            refinements = _qf;
        }
        ArrayList<String> newRefinements = new ArrayList<String>();
        ArrayList<String> mediaTypes = new ArrayList<String>();
        ArrayList<String> mimeTypes = new ArrayList<String>();
        ArrayList<String> imageSizes = new ArrayList<String>();
        ArrayList<Boolean> imageColors = new ArrayList<Boolean>();
        ArrayList<Boolean> imageGrayScales = new ArrayList<Boolean>();
        ArrayList<String> imageAspectRatios = new ArrayList<String>();
        ArrayList imageColorsPalette = new ArrayList();
        ArrayList<Boolean> soundHQs = new ArrayList<Boolean>();
        ArrayList<String> soundDurations = new ArrayList<String>();
        ArrayList<Boolean> videoHDs = new ArrayList<Boolean>();
        ArrayList<String> videoDurations = new ArrayList<String>();
        List imageFilterTags = FakeTagsUtils.imageFilterTags(mimeTypes, imageSizes, imageColors, imageGrayScales, imageAspectRatios);
        Integer imageFilterTag = imageFilterTags.isEmpty() ? null : (Integer)imageFilterTags.get(0);
        List soundFilterTags = FakeTagsUtils.soundFilterTags(mimeTypes, soundHQs, soundDurations);
        Integer soundFilterTag = soundFilterTags.isEmpty() ? null : (Integer)soundFilterTags.get(0);
        List videoFilterTags = FakeTagsUtils.videoFilterTags(mimeTypes, videoHDs, videoDurations);
        Integer n = videoFilterTag = videoFilterTags.isEmpty() ? null : (Integer)videoFilterTags.get(0);
        if (cursorMark != null && start > 1) {
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError("", "Parameters 'start' and 'cursorMark' cannot be used together"), (String)callback);
        }
        if (sort != null && (sort.equalsIgnoreCase("timestamp") || sort.toLowerCase().startsWith("timestamp "))) {
            sort = "";
        }
        StringArrayUtils.addToList(soundDurations, (String[])sound_duration);
        if (sound_hq != null) {
            soundHQs.add(sound_hq);
        }
        StringArrayUtils.addToList(videoDurations, (String[])video_duration);
        if (video_hd != null) {
            videoHDs.add(video_hd);
        }
        StringArrayUtils.addToList(imageAspectRatios, (String[])image_aspectratio);
        if (image_colour != null) {
            if (image_colour.booleanValue()) {
                imageColors.add(true);
            } else {
                imageGrayScales.add(true);
            }
        }
        StringArrayUtils.addToList(imageSizes, (String[])image_size);
        StringArrayUtils.addToList(imageColorsPalette, (String[])colorPalette);
        if (refinements != null) {
            block47: for (String qf : refinements) {
                this.log.info("QF: " + qf);
                Integer colonIndex = qf.indexOf(":");
                if (colonIndex == -1) {
                    newRefinements.add(qf);
                    continue;
                }
                String prefix = qf.substring(0, colonIndex).toLowerCase();
                String suffix = qf.substring(colonIndex + 1).toLowerCase();
                this.log.info("prefix: " + prefix);
                this.log.info("suffix: " + suffix);
                switch (prefix.toLowerCase()) {
                    case "text_fulltext": {
                        isFulltext = isFulltext != null && isFulltext != false || Boolean.parseBoolean(suffix);
                        continue block47;
                    }
                    case "has_thumbnail": {
                        thumbnail = thumbnail != null && thumbnail != false || Boolean.parseBoolean(suffix);
                        continue block47;
                    }
                    case "has_media": {
                        media = media != null && media != false || Boolean.parseBoolean(suffix);
                        continue block47;
                    }
                    case "type": {
                        mediaTypes.add(suffix);
                        newRefinements.add(qf);
                        continue block47;
                    }
                    case "mime_type": {
                        mimeTypes.add(suffix);
                        continue block47;
                    }
                    case "image_size": {
                        imageSizes.add(suffix);
                        continue block47;
                    }
                    case "image_colour": 
                    case "image_color": {
                        if (Boolean.valueOf(suffix).booleanValue()) {
                            imageColors.add(true);
                            continue block47;
                        }
                        imageGrayScales.add(true);
                        continue block47;
                    }
                    case "image_greyscale": 
                    case "image_grayscale": {
                        imageGrayScales.add(Boolean.valueOf(suffix));
                        continue block47;
                    }
                    case "image_aspectratio": {
                        imageAspectRatios.add(suffix);
                        continue block47;
                    }
                    case "sound_hq": {
                        soundHQs.add(Boolean.valueOf(suffix));
                        continue block47;
                    }
                    case "sound_duration": {
                        soundDurations.add(suffix);
                        continue block47;
                    }
                    case "video_hd": {
                        videoHDs.add(Boolean.valueOf(suffix));
                        continue block47;
                    }
                    case "video_duration": {
                        videoDurations.add(suffix);
                        continue block47;
                    }
                    default: {
                        newRefinements.add(qf);
                    }
                }
            }
        }
        if (isFulltext != null) {
            newRefinements.add("is_fulltext:" + isFulltext);
        }
        if (thumbnail != null) {
            newRefinements.add("has_thumbnails:" + thumbnail);
        }
        if (media != null) {
            newRefinements.add("has_media:" + media);
        }
        if (hasLandingPage != null) {
            newRefinements.add("has_landingpage:" + hasLandingPage);
        }
        refinements = newRefinements.toArray(new String[newRefinements.size()]);
        this.log.info("New Refinements: " + Arrays.toString(refinements));
        if (!imageColorsPalette.isEmpty()) {
            String filterQuery = "";
            for (String color : imageColorsPalette) {
                this.log.debug("Color palette: " + color);
                Integer filterTag = FakeTagsUtils.calculateTag((Integer)1, null, null, null, null, null, (String)color, null, null, null, null);
                this.log.debug("Color palette: " + filterTag);
                filterQuery = filterQuery + "filter_tags:" + filterTag + " AND ";
            }
            if (!filterQuery.equals("")) {
                filterQuery = filterQuery.substring(0, filterQuery.lastIndexOf("AND"));
                filterQuery = filterQuery.trim();
                queryString = queryString.equals("") ? filterQuery : queryString + " AND " + filterQuery;
            }
        }
        ArrayList filterTags = new ArrayList();
        filterTags.addAll(FakeTagsUtils.imageFilterTags(mimeTypes, imageSizes, imageColors, imageGrayScales, imageAspectRatios));
        filterTags.addAll(FakeTagsUtils.soundFilterTags(mimeTypes, soundHQs, soundDurations));
        filterTags.addAll(FakeTagsUtils.videoFilterTags(mimeTypes, videoHDs, videoDurations));
        boolean image = false;
        boolean sound = false;
        boolean video = false;
        for (String type : mediaTypes) {
            switch (type.toLowerCase()) {
                case "image": {
                    image = true;
                    break;
                }
                case "sound": {
                    sound = true;
                    break;
                }
                case "video": {
                    video = true;
                }
            }
        }
        if (!image) {
            filterTags.remove(imageFilterTag);
        }
        if (!sound) {
            filterTags.remove(soundFilterTag);
        }
        if (!video) {
            filterTags.remove(videoFilterTag);
        }
        String filterTagQuery = "";
        for (Integer filterTag : filterTags) {
            if (filterTag % 0x2000000 == 0) continue;
            filterTagQuery = filterTagQuery + "filter_tags:" + filterTag + " OR ";
        }
        if (filterTagQuery.contains("OR")) {
            filterTagQuery = filterTagQuery.substring(0, filterTagQuery.lastIndexOf("OR"));
            filterTagQuery = filterTagQuery.trim();
            if (StringUtils.isBlank((String)queryString)) {
                queryString = filterTagQuery;
            } else {
                filterTagQuery = "(" + filterTagQuery + ")";
                queryString = queryString + " AND " + filterTagQuery;
            }
        }
        boolean isFacetsRequested = this.isFacetsRequested(profile);
        Object[] reusability = StringArrayUtils.splitWebParameter((String[])aReusability);
        Object[] facets = this.expandFacetNames(StringArrayUtils.splitWebParameter((String[])aFacet));
        boolean isDefaultFacetsRequested = this.isDefaultFacetsRequested(profile, (String[])facets);
        facets = SearchController.limitFacets((String[])facets, (boolean)isDefaultFacetsRequested);
        boolean isDefaultOrReusabilityFacetRequested = this.isDefaultOrReusabilityFacetRequested(profile, (String[])facets);
        Map facetLimits = null;
        Map facetOffsets = null;
        if (isFacetsRequested) {
            Map parameterMap = request.getParameterMap();
            facetLimits = FacetParameterUtils.getFacetParams((String)"limit", (String[])aFacet, (Map)parameterMap, (boolean)isDefaultFacetsRequested);
            facetOffsets = FacetParameterUtils.getFacetParams((String)"offset", (String[])aFacet, (Map)parameterMap, (boolean)isDefaultFacetsRequested);
        }
        this.controllerUtils.addResponseHeaders(response);
        rows = Math.min(rows, this.configuration.getApiRowLimit());
        Map valueReplacements = new HashMap();
        if (ArrayUtils.isNotEmpty((Object[])reusability)) {
            valueReplacements = RightReusabilityCategorizer.mapValueReplacements((String[])reusability, (boolean)true);
            refinements = (String[])ArrayUtils.addAll((Object[])refinements, (Object[])valueReplacements.keySet().toArray(new String[valueReplacements.keySet().size()]));
        }
        Class clazz = this.selectBean(profile);
        Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setApiQuery(true).setRefinements(refinements).setPageSize(rows).setStart(start - 1).setSort(sort).setCurrentCursorMark(cursorMark).setParameter("facet.mincount", "1").setParameter("fl", IdBeanImpl.getFields((Class)this.getBeanImpl(clazz))).setAllowSpellcheck(false).setAllowFacets(false);
        if (ArrayUtils.isNotEmpty((Object[])facets)) {
            query.setFacets((String[])facets);
            if (facetLimits != null && !facetLimits.isEmpty()) {
                for (Map.Entry entry : facetLimits.entrySet()) {
                    query.setParameter((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            if (facetOffsets != null && !facetOffsets.isEmpty()) {
                for (Map.Entry entry : facetOffsets.entrySet()) {
                    query.setParameter((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
        }
        query.setValueReplacements(valueReplacements);
        if (isDefaultOrReusabilityFacetRequested) {
            query.setFacetQueries(RightReusabilityCategorizer.getQueryFacets());
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"spelling")) {
            query.setAllowSpellcheck(true);
        }
        if (isFacetsRequested) {
            query.setAllowFacets(true);
            if (!query.hasParameter("f.DATA_PROVIDER.facet.limit") && (ArrayUtils.contains((Object[])facets, (Object)"DATA_PROVIDER") || ArrayUtils.contains((Object[])facets, (Object)"DEFAULT"))) {
                query.setParameter("f.DATA_PROVIDER.facet.limit", "3000");
            }
        }
        try {
            SearchResults result = this.createResults(wskey, profile, query, clazz);
            result.requestNumber = limitResponse.getRequestNumber();
            if (StringUtils.containsIgnoreCase((String)profile, (String)"params")) {
                result.addParams(RequestUtils.getParameterMap((HttpServletRequest)request), new String[]{"wskey"});
                result.addParam("profile", (Object)profile);
                result.addParam("start", (Object)start);
                result.addParam("rows", (Object)rows);
                result.addParam("sort", (Object)sort);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("got response " + result.items.size());
            }
            return JsonUtils.toJson((Object)result, (String)callback);
        }
        catch (SolrTypeException e) {
            if (e.getProblem().equals((Object)ProblemType.SEARCH_LIMIT_REACHED)) {
                this.log.error(wskey + " [search.json] " + ProblemType.SEARCH_LIMIT_REACHED.getMessage());
            } else {
                this.log.error(wskey + " [search.json] ", (Throwable)e);
            }
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage()), (String)callback);
        }
        catch (Exception e) {
            this.log.error(wskey + " [search.json] " + e.getClass().getSimpleName(), (Throwable)e);
            response.setStatus(400);
            return JsonUtils.toJson((Object)new ApiError(wskey, e.getMessage()), (String)callback);
        }
    }

    private Class<? extends IdBean> selectBean(String profile) {
        Class clazz = StringUtils.containsIgnoreCase((String)profile, (String)"minimal") ? BriefBean.class : (StringUtils.containsIgnoreCase((String)profile, (String)"rich") ? RichBean.class : ApiBean.class);
        return clazz;
    }

    private Class<? extends IdBeanImpl> getBeanImpl(Class clazz) {
        if (BriefBean.class.equals((Object)clazz)) {
            return BriefBeanImpl.class;
        }
        if (RichBean.class.equals((Object)clazz)) {
            return RichBeanImpl.class;
        }
        return ApiBeanImpl.class;
    }

    @ApiOperation(value="get autocompletion recommendations for search queries", nickname="suggestions")
    @RequestMapping(value={"/v2/suggestions.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView suggestionsJson(@RequestParam(value="query", required=true) String query, @RequestParam(value="rows", required=false, defaultValue="10") int count, @RequestParam(value="phrases", required=false, defaultValue="false") boolean phrases, @RequestParam(value="callback", required=false) String callback, HttpServletResponse response) {
        this.controllerUtils.addResponseHeaders(response);
        if (this.log.isInfoEnabled()) {
            this.log.info("phrases: " + phrases);
        }
        Suggestions apiResponse = new Suggestions(null);
        try {
            apiResponse.items = this.searchService.suggestions(query, count);
            apiResponse.itemsCount = apiResponse.items.size();
        }
        catch (SolrTypeException e) {
            return JsonUtils.toJson((Object)new ApiError(null, e.getMessage()), (String)callback);
        }
        return JsonUtils.toJson((Object)apiResponse, (String)callback);
    }

    private <T extends IdBean> SearchResults<T> createResults(String apiKey, String profile, Query query, Class<T> clazz) throws SolrTypeException {
        List allQueryFacetsMap;
        SearchResults response = new SearchResults(apiKey);
        ResultSet resultSet = this.searchService.search(clazz, query);
        response.totalResults = resultSet.getResultSize();
        if (StringUtils.isNotBlank((String)resultSet.getCurrentCursorMark()) && StringUtils.isNotBlank((String)resultSet.getNextCursorMark()) && !resultSet.getNextCursorMark().equalsIgnoreCase(resultSet.getCurrentCursorMark())) {
            response.nextCursor = resultSet.getNextCursorMark();
        }
        response.itemsCount = resultSet.getResults().size();
        response.items = resultSet.getResults();
        ArrayList<Object> beans = new ArrayList<Object>();
        for (IdBean b : resultSet.getResults()) {
            if (b instanceof RichBean) {
                beans.add(new RichView((RichBean)b, profile, apiKey));
                continue;
            }
            if (b instanceof ApiBean) {
                beans.add(new ApiView((ApiBean)b, profile, apiKey));
                continue;
            }
            if (!(b instanceof BriefBean)) continue;
            beans.add(new BriefView((BriefBean)b, profile, apiKey));
        }
        List facetFields = resultSet.getFacetFields();
        if (resultSet.getQueryFacets() != null && !(allQueryFacetsMap = SearchUtils.extractQueryFacets((Map)resultSet.getQueryFacets())).isEmpty()) {
            facetFields.addAll(allQueryFacetsMap);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("beans: " + beans.size());
        }
        response.items = beans;
        if (StringUtils.containsIgnoreCase((String)profile, (String)"facets") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.facets = ModelUtils.conventFacetList((List)resultSet.getFacetFields());
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"breadcrumb") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.breadCrumbs = NavigationUtils.createBreadCrumbList((Query)query);
        }
        if (StringUtils.containsIgnoreCase((String)profile, (String)"spelling") || StringUtils.containsIgnoreCase((String)profile, (String)"portal")) {
            response.spellcheck = ModelUtils.convertSpellCheck((SpellCheckResponse)resultSet.getSpellcheck());
        }
        return response;
    }

    @SwaggerIgnore
    @RequestMapping(value={"/v2/search.kml"}, method={RequestMethod.GET}, produces={"application/vnd.google-earth.kml+xml", "*/*"})
    @ResponseBody
    public KmlResponse searchKml(@RequestParam(value="query", required=true) String queryString, @RequestParam(value="qf", required=false) String[] refinements, @RequestParam(value="start", required=false, defaultValue="1") int start, @RequestParam(value="wskey", required=true) String wskey, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] _qf = (String[])request.getParameterMap().get("qf");
        if (_qf != null && _qf.length != refinements.length) {
            refinements = _qf;
        }
        try {
            ApiKey apiKey = (ApiKey)this.apiService.findByID((Serializable)((Object)wskey));
            this.apiService.checkReachedLimit(apiKey);
        }
        catch (DatabaseException e) {
            response.setStatus(401);
            throw new Exception(e);
        }
        catch (LimitReachedException e) {
            response.setStatus(429);
            throw new Exception(e);
        }
        KmlResponse kmlResponse = new KmlResponse();
        Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setRefinements(refinements).setApiQuery(true).setAllowSpellcheck(false).setAllowFacets(false);
        query.setRefinements(new String[]{"pl_wgs84_pos_lat_long:[* TO *]"});
        try {
            ResultSet resultSet = this.searchService.search(BriefBean.class, query);
            kmlResponse.document.extendedData.totalResults.value = Long.toString(resultSet.getResultSize());
            kmlResponse.document.extendedData.startIndex.value = Integer.toString(start);
            kmlResponse.setItems(resultSet.getResults());
        }
        catch (SolrTypeException e) {
            response.setStatus(429);
            throw new Exception(e);
        }
        return kmlResponse;
    }

    @ApiOperation(value="basic search function following the OpenSearch specification", nickname="suggestions")
    @RequestMapping(value={"/v2/opensearch.rss"}, method={RequestMethod.GET}, produces={"application/xml", "*/*"})
    @ResponseBody
    public RssResponse openSearchRss(@RequestParam(value="searchTerms", required=true) String queryString, @RequestParam(value="startIndex", required=false, defaultValue="1") int start, @RequestParam(value="count", required=false, defaultValue="12") int count) {
        RssResponse rss = new RssResponse();
        Channel channel = rss.channel;
        channel.startIndex.value = start;
        channel.itemsPerPage.value = count;
        channel.query.searchTerms = queryString;
        channel.query.startPage = start;
        try {
            Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setApiQuery(true).setPageSize(count).setStart(start - 1).setAllowFacets(false).setAllowSpellcheck(false);
            ResultSet resultSet = this.searchService.search(BriefBean.class, query);
            channel.totalResults.value = resultSet.getResultSize();
            for (BriefBean bean : resultSet.getResults()) {
                Item item = new Item();
                item.guid = this.urlService.getPortalRecord(false, bean.getId()).toString();
                item.title = this.getTitle(bean);
                item.description = this.getDescription(bean);
                item.link = item.guid;
                channel.items.add(item);
            }
        }
        catch (SolrTypeException e) {
            channel.totalResults.value = 0L;
            Item item = new Item();
            item.title = "Error";
            item.description = e.getMessage();
            channel.items.add(item);
        }
        return rss;
    }

    @ApiOperation(value="Google Fieldtrip formatted RSS of selected collections", nickname="fieldTrip")
    @RequestMapping(value={"/v2/search.rss"}, method={RequestMethod.GET}, produces={"application/xml", "*/*"})
    public ModelAndView fieldTripRss(@RequestParam(value="query", required=true) String queryTerms, @RequestParam(value="offset", required=false, defaultValue="1") int offset, @RequestParam(value="limit", required=false, defaultValue="12") int limit, @RequestParam(value="profile", required=false, defaultValue="FieldTrip") String profile, @RequestParam(value="language", required=false) String reqLanguage, HttpServletResponse response) {
        this.controllerUtils.addResponseHeaders(response);
        FieldTripResponse rss = new FieldTripResponse();
        FieldTripChannel channel = rss.channel;
        FieldTripUtils fieldTripUtils = new FieldTripUtils(this.urlService);
        if (queryTerms == null || "".equalsIgnoreCase(queryTerms) || "".equals(this.getIdFromQueryTerms(queryTerms))) {
            response.setStatus(400);
            String errorMsg = "error: Query ('" + queryTerms + "') is malformed, can't retrieve collection ID";
            this.log.error(errorMsg);
            FieldTripItem item = new FieldTripItem();
            item.title = "Error";
            item.description = errorMsg;
            channel.items.add(item);
        } else {
            String collectionID = this.getIdFromQueryTerms(queryTerms);
            Map gftChannelAttributes = this.configuration.getGftChannelAttributes(collectionID);
            if (gftChannelAttributes.isEmpty() || gftChannelAttributes.size() < 5) {
                this.log.error("error: one or more attributes are not defined in europeana.properties for [INSERT COLLECTION ID HERE]");
                channel.title = "error retrieving attributes";
                channel.description = "error retrieving attributes";
                channel.language = "--";
                channel.link = "error retrieving attributes";
                channel.image = null;
            } else {
                String string = gftChannelAttributes.get(reqLanguage + "_title") == null || ((String)gftChannelAttributes.get(reqLanguage + "_title")).equalsIgnoreCase("") ? (gftChannelAttributes.get("title") == null || ((String)gftChannelAttributes.get("title")).equalsIgnoreCase("") ? "no title defined" : (String)gftChannelAttributes.get("title")) : (channel.title = (String)gftChannelAttributes.get(reqLanguage + "_title"));
                channel.description = gftChannelAttributes.get(reqLanguage + "_description") == null || ((String)gftChannelAttributes.get(reqLanguage + "_description")).equalsIgnoreCase("") ? (gftChannelAttributes.get("description") == null || ((String)gftChannelAttributes.get("description")).equalsIgnoreCase("") ? "no description defined" : (String)gftChannelAttributes.get("description")) : (String)gftChannelAttributes.get(reqLanguage + "_description");
                channel.language = gftChannelAttributes.get("language") == null || ((String)gftChannelAttributes.get("language")).equalsIgnoreCase("") ? "--" : (String)gftChannelAttributes.get("language");
                channel.link = gftChannelAttributes.get("link") == null || ((String)gftChannelAttributes.get("link")).equalsIgnoreCase("") ? "no link defined" : (String)gftChannelAttributes.get("link");
                FieldTripImage fieldTripImage = channel.image = gftChannelAttributes.get("image") == null || ((String)gftChannelAttributes.get("image")).equalsIgnoreCase("") ? null : new FieldTripImage((String)gftChannelAttributes.get("image"));
            }
            if (StringUtils.equals((String)profile, (String)"FieldTrip")) {
                ++offset;
            }
            try {
                Query query = new Query(SearchUtils.rewriteQueryFields((String)queryTerms)).setApiQuery(true).setPageSize(limit).setStart(offset - 1).setAllowFacets(false).setAllowSpellcheck(false);
                ResultSet resultSet = this.searchService.search(RichBean.class, query);
                for (RichBean bean : resultSet.getResults()) {
                    if (reqLanguage != null && !this.getDcLanguage((BriefBean)bean).equalsIgnoreCase(reqLanguage)) continue;
                    channel.items.add(fieldTripUtils.createItem(bean, this.getTranslatedEdmIsShownAtLabel((BriefBean)bean, reqLanguage == null ? channel.language : reqLanguage)));
                }
            }
            catch (SolrTypeException | MissingResourceException e) {
                this.log.error("error: " + e.getLocalizedMessage());
                FieldTripItem item = new FieldTripItem();
                item.title = "Error";
                item.description = e.getMessage();
                channel.items.add(item);
            }
        }
        String xml = fieldTripUtils.cleanRss(this.xmlUtils.toString((Object)rss));
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("rss", xml);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xml");
        return new ModelAndView("rss", model);
    }

    private String getTitle(BriefBean bean) {
        if (!ArrayUtils.isEmpty((Object[])bean.getTitle())) {
            for (String title : bean.getTitle()) {
                if (StringUtils.isBlank((String)title)) continue;
                return title;
            }
        }
        return bean.getDataProvider()[0] + " " + bean.getId();
    }

    private String getDescription(BriefBean bean) {
        StringBuilder sb = new StringBuilder();
        if (bean.getDcCreator() != null && bean.getDcCreator().length > 0 && StringUtils.isNotBlank((String)bean.getDcCreator()[0])) {
            sb.append(bean.getDcCreator()[0]);
        }
        if (bean.getYear() != null && bean.getYear().length > 0) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(StringUtils.join((Object[])bean.getYear(), (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])bean.getProvider())) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(StringUtils.join((Object[])bean.getProvider(), (String)", "));
        }
        return sb.toString();
    }

    private String getDcLanguage(BriefBean bean) {
        if (bean.getDcLanguage() != null && bean.getDcLanguage().length > 0 && StringUtils.isNotBlank((String)bean.getDcLanguage()[0])) {
            return bean.getDcLanguage()[0];
        }
        return "";
    }

    private boolean isFacetsRequested(String profile) {
        return StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"facets");
    }

    private boolean isDefaultFacetsRequested(String profile, String[] facets) {
        return StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"facets") && (ArrayUtils.isEmpty((Object[])facets) || ArrayUtils.contains((Object[])facets, (Object)"DEFAULT"));
    }

    private boolean isDefaultOrReusabilityFacetRequested(String profile, String[] facets) {
        return StringUtils.containsIgnoreCase((String)profile, (String)"portal") || StringUtils.containsIgnoreCase((String)profile, (String)"facets") && (ArrayUtils.isEmpty((Object[])facets) || ArrayUtils.contains((Object[])facets, (Object)"DEFAULT") || ArrayUtils.contains((Object[])facets, (Object)"REUSABILITY"));
    }

    private String getTranslatedEdmIsShownAtLabel(BriefBean bean, String language) {
        String translatedEdmIsShownAtLabel;
        try {
            translatedEdmIsShownAtLabel = this.getEdmIsShownAtLabelTranslation(this.getBeanLocale(bean.getLanguage()));
        }
        catch (MissingResourceException e) {
            this.log.error("error: 'edmIsShownAtLabel' translation for bean language '" + this.getBeanLocale(bean.getLanguage()) + "' unavailable: " + e.getMessage());
            translatedEdmIsShownAtLabel = "";
        }
        if (StringUtils.isBlank((String)translatedEdmIsShownAtLabel)) {
            if (!this.isLanguageEqual(bean.getLanguage(), language)) {
                this.log.error("falling back on channel language ('" + language + "')");
                try {
                    translatedEdmIsShownAtLabel = this.getEdmIsShownAtLabelTranslation(this.getLocale(language));
                }
                catch (MissingResourceException e) {
                    this.log.error("error: 'edmIsShownAtLabel' translation for channel language '" + this.getBeanLocale(bean.getLanguage()) + "' unavailable: " + e.getMessage());
                    translatedEdmIsShownAtLabel = "";
                }
            } else {
                this.log.error("channel language ('" + language + "') is identical to bean language, skipping ...");
            }
            if (StringUtils.isBlank((String)translatedEdmIsShownAtLabel)) {
                this.log.error("falling back on default English translation ...");
                try {
                    translatedEdmIsShownAtLabel = this.getEdmIsShownAtLabelTranslation(this.getLocale("en"));
                }
                catch (MissingResourceException e) {
                    this.log.error("error: 'edmIsShownAtLabel' English translation unavailable: " + e.getMessage());
                    translatedEdmIsShownAtLabel = "";
                }
                if (StringUtils.isBlank((String)translatedEdmIsShownAtLabel)) {
                    this.log.error("No translation for 'edmIsShownAtLabel' available.");
                    return "error: translations for 'edmIsShownAtLabel' unavailable";
                }
            }
        }
        return translatedEdmIsShownAtLabel;
    }

    private String getEdmIsShownAtLabelTranslation(Locale locale) {
        return this.messageSource.getMessage("edm_isShownAtLabel_t", null, locale);
    }

    private Locale getBeanLocale(String[] beanLanguage) {
        if (!ArrayUtils.isEmpty((Object[])beanLanguage) && !StringUtils.isBlank((String)beanLanguage[0]) && beanLanguage[0].length() == 2) {
            return new Locale(beanLanguage[0]);
        }
        this.log.error("error: language code unavailable or malformed (e.g. not two characters long)");
        return new Locale("en");
    }

    private Locale getLocale(String language) {
        if (!StringUtils.isBlank((String)language) && language.length() == 2) {
            return new Locale(language);
        }
        this.log.error("error: language code unavailable or malformed (e.g. not two characters long)");
        return new Locale("en");
    }

    private boolean isLanguageEqual(String[] languageArray, String language) {
        return !ArrayUtils.isEmpty((Object[])languageArray) && !StringUtils.isBlank((String)languageArray[0]) && languageArray[0].length() == 2 && !StringUtils.isBlank((String)language) && language.length() == 2 && language.equalsIgnoreCase(languageArray[0]);
    }

    private String getIdFromQueryTerms(String queryTerms) {
        return queryTerms.substring(queryTerms.indexOf(":"), queryTerms.indexOf("*")).replaceAll("\\D+", "");
    }

    private String[] expandFacetNames(String[] facet) {
        if (facet == null) {
            return null;
        }
        for (int i = 0; i < facet.length; ++i) {
            if ("MEDIA".equalsIgnoreCase(facet[i])) {
                facet[i] = "has_media";
                continue;
            }
            if ("THUMBNAIL".equalsIgnoreCase(facet[i])) {
                facet[i] = "has_thumbnails";
                continue;
            }
            if (!"TEXT_FULLTEXT".equalsIgnoreCase(facet[i])) continue;
            facet[i] = "is_fulltext";
        }
        return facet;
    }
}

