/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.corelib.db.service.OAuth2TokenService;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RedirectController {
    @Resource
    private OAuth2TokenService oAuth2TokenService;

    @RequestMapping(value={"/{apiKey}/redirect", "/{apiKey}/redirect.json"}, method={RequestMethod.GET})
    public String handleRedirect(@PathVariable String apiKey, @RequestParam(value="shownAt", required=true) String isShownAt) throws Exception {
        if (StringUtils.isBlank((String)isShownAt)) {
            throw new IllegalArgumentException("Expected to find 'shownAt' in the request URL");
        }
        return "redirect:" + isShownAt;
    }

    @RequestMapping(value={"/clearTokens"}, method={RequestMethod.GET})
    public String removeAll() {
        this.oAuth2TokenService.removeAll();
        return "user/cleared";
    }
}

