/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.ApiLimitException;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.model.LimitResponse;
import eu.europeana.api2.v2.model.json.HierarchicalResult;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.neo4j.entity.Neo4jBean;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.web.utils.RequestUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;

public class HierarchyTemplateRunner
implements Callable<ModelAndView> {
    private static final int MAX_LIMIT = 100;
    private String rdfAbout;
    private RecordType recordType;
    private String profile;
    private String wskey;
    private int limit;
    private int offset;
    private String callback;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Logger log;
    private ControllerUtils controllerUtils;
    private SearchService searchService;

    HierarchyTemplateRunner(RecordType recordType, String rdfAbout, String profile, String wskey, int limit, int offset, String callback, HttpServletRequest request, HttpServletResponse response, Logger log, ControllerUtils controllerUtils, SearchService searchService) {
        this.recordType = recordType;
        this.rdfAbout = rdfAbout;
        this.profile = profile;
        this.wskey = wskey;
        this.limit = limit;
        this.offset = offset;
        this.callback = callback;
        this.request = request;
        this.response = response;
        this.log = log;
        this.controllerUtils = controllerUtils;
        this.searchService = searchService;
        log.info("Running thread for " + rdfAbout);
    }

    @Override
    public ModelAndView call() {
        LimitResponse limitResponse;
        long t0 = System.currentTimeMillis();
        this.controllerUtils.addResponseHeaders(this.response);
        this.limit = Math.min(this.limit, 100);
        long t1 = System.currentTimeMillis();
        try {
            limitResponse = this.controllerUtils.checkLimit(this.wskey, this.request.getRequestURL().toString(), this.recordType, this.profile);
        }
        catch (ApiLimitException e) {
            this.response.setStatus(e.getHttpStatus());
            return JsonUtils.toJson((Object)new ApiError(e), (String)this.callback);
        }
        this.log.info("Limit: " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        HierarchicalResult hierarchicalResult = new HierarchicalResult(this.wskey, limitResponse.getRequestNumber());
        if (StringUtils.containsIgnoreCase((String)this.profile, (String)"params")) {
            hierarchicalResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)this.request), new String[]{"wskey"});
            hierarchicalResult.addParam("profile", (Object)this.profile);
        }
        this.log.info("Init object: " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        if (!this.recordType.equals((Object)RecordType.HIERARCHY_SELF)) {
            hierarchicalResult.self = this.searchService.getHierarchicalBean(this.rdfAbout);
            if (hierarchicalResult.self != null) {
                hierarchicalResult.self.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(hierarchicalResult.self.getId())));
            } else {
                this.response.setStatus(404);
                return JsonUtils.toJson((Object)new ApiError(this.wskey, String.format("Invalid record identifier: %s", this.rdfAbout), limitResponse.getRequestNumber()), (String)this.callback);
            }
        }
        this.log.info("get self: " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        if (this.recordType.equals((Object)RecordType.HIERARCHY_CHILDREN)) {
            hierarchicalResult.children = this.searchService.getChildren(this.rdfAbout, this.offset, this.limit);
            if (hierarchicalResult.children == null || hierarchicalResult.children.isEmpty()) {
                hierarchicalResult.message = "This record has no children";
                hierarchicalResult.success = false;
                this.response.setStatus(404);
            } else {
                this.addChildrenCount(hierarchicalResult.children);
            }
        } else if (this.recordType.equals((Object)RecordType.HIERARCHY_SELF)) {
            hierarchicalResult.self = this.searchService.getHierarchicalBean(this.rdfAbout);
            if (hierarchicalResult.self == null) {
                hierarchicalResult.success = false;
                this.response.setStatus(404);
                return JsonUtils.toJson((Object)new ApiError(this.wskey, String.format("Invalid record identifier: %s", this.rdfAbout), limitResponse.getRequestNumber()), (String)this.callback);
            }
            hierarchicalResult.self.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(this.rdfAbout)));
        } else if (this.recordType.equals((Object)RecordType.HIERARCHY_PARENT)) {
            if (hierarchicalResult.self == null || StringUtils.isBlank((String)hierarchicalResult.self.getParent())) {
                hierarchicalResult.message = "This record has no parent";
                hierarchicalResult.success = false;
                this.response.setStatus(404);
            } else {
                hierarchicalResult.parent = this.searchService.getHierarchicalBean(hierarchicalResult.self.getParent());
                if (hierarchicalResult.parent != null) {
                    hierarchicalResult.parent.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(hierarchicalResult.parent.getId())));
                }
            }
        } else if (this.recordType.equals((Object)RecordType.HIERARCHY_FOLLOWING_SIBLINGS)) {
            long tgetsiblings = System.currentTimeMillis();
            hierarchicalResult.followingSiblings = this.searchService.getFollowingSiblings(this.rdfAbout, this.limit);
            this.log.info("Get siblings: " + (System.currentTimeMillis() - tgetsiblings));
            if (hierarchicalResult.followingSiblings == null || hierarchicalResult.followingSiblings.isEmpty()) {
                hierarchicalResult.message = "This record has no following siblings";
                hierarchicalResult.success = false;
                this.response.setStatus(404);
            } else {
                long tgetsiblingsCount = System.currentTimeMillis();
                this.addChildrenCount(hierarchicalResult.followingSiblings);
                this.log.info("Get siblingsCount: " + (System.currentTimeMillis() - tgetsiblingsCount));
            }
        } else if (this.recordType.equals((Object)RecordType.HIERARCHY_PRECEDING_SIBLINGS)) {
            hierarchicalResult.precedingSiblings = this.searchService.getPrecedingSiblings(this.rdfAbout, this.limit);
            if (hierarchicalResult.precedingSiblings == null || hierarchicalResult.precedingSiblings.isEmpty()) {
                hierarchicalResult.message = "This record has no preceding siblings";
                hierarchicalResult.success = false;
                this.response.setStatus(404);
            } else {
                this.addChildrenCount(hierarchicalResult.precedingSiblings);
            }
        } else if (this.recordType.equals((Object)RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS)) {
            Neo4jStructBean struct = this.searchService.getInitialStruct(this.rdfAbout);
            if (struct == null) {
                hierarchicalResult.message = String.format("This record has no hierarchical structure %s", this.rdfAbout);
                hierarchicalResult.success = false;
                this.response.setStatus(404);
            } else {
                String partialErrorMsg = "This record has no";
                boolean hasParent = true;
                boolean hasFollowing = true;
                boolean hasPreceding = true;
                if (struct.getParents() != null && !struct.getParents().isEmpty()) {
                    List tempParents = struct.getParents();
                    Collections.reverse(tempParents);
                    hierarchicalResult.ancestors = tempParents;
                } else {
                    hasParent = false;
                }
                if (struct.getFollowingSiblings() != null && !struct.getFollowingSiblings().isEmpty()) {
                    hierarchicalResult.followingSiblings = struct.getFollowingSiblings();
                } else {
                    hasFollowing = false;
                }
                if (struct.getPrecedingSiblings() != null && !struct.getPrecedingSiblings().isEmpty()) {
                    hierarchicalResult.precedingSiblings = struct.getPrecedingSiblings();
                } else {
                    hasPreceding = false;
                }
                if (!hasParent) {
                    partialErrorMsg = partialErrorMsg + " parent";
                    if (!hasFollowing || !hasPreceding) {
                        partialErrorMsg = partialErrorMsg + " or";
                    }
                }
                if (!hasFollowing && !hasPreceding) {
                    partialErrorMsg = partialErrorMsg + " siblings";
                } else if (hasFollowing && !hasPreceding) {
                    partialErrorMsg = partialErrorMsg + " preceding siblings";
                } else if (!hasFollowing && hasPreceding) {
                    partialErrorMsg = partialErrorMsg + " following siblings";
                }
                if (!(hasParent && hasFollowing && hasPreceding)) {
                    hierarchicalResult.message = partialErrorMsg;
                }
                if (struct.getPrecedingSiblingChildren() != null && !struct.getPrecedingSiblingChildren().isEmpty()) {
                    hierarchicalResult.precedingSiblingChildren = struct.getPrecedingSiblingChildren();
                }
                if (struct.getFollowingSiblingChildren() != null && !struct.getFollowingSiblingChildren().isEmpty()) {
                    hierarchicalResult.followingSiblingChildren = struct.getFollowingSiblingChildren();
                }
            }
        }
        this.log.info("get main: " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        hierarchicalResult.statsDuration = System.currentTimeMillis() - t0;
        ModelAndView json = JsonUtils.toJson((Object)hierarchicalResult, (String)this.callback);
        this.log.info("toJson: " + (System.currentTimeMillis() - t1));
        return json;
    }

    private void addChildrenCount(List<Neo4jBean> beans) {
        if (beans != null && beans.size() > 0) {
            for (Neo4jBean bean : beans) {
                if (!bean.hasChildren().booleanValue()) continue;
                bean.setChildrenCount(Long.valueOf(this.searchService.getChildrenCount(bean.getId())));
            }
        }
    }
}

