/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.web.controller.HierarchyTemplateRunner;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.corelib.db.entity.enums.RecordType;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.search.SearchService;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/v2/record"})
public class HierarchicalController {
    @Log
    private Logger log;
    @Resource
    private SearchService searchService;
    @Resource
    private ControllerUtils controllerUtils;

    @ApiOperation(value="returns the object itself")
    @RequestMapping(value={"/{collectionId}/{recordId}/self.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getSelf(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_SELF, collectionId, recordId, profile, wskey, -1, -1, callback, request, response);
    }

    @ApiOperation(value="returns the object, its ancestors and siblings")
    @RequestMapping(value={"/{collectionId}/{recordId}/ancestor-self-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getAncestorSelfSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS, collectionId, recordId, profile, wskey, -1, -1, callback, request, response);
    }

    @ApiOperation(value="returns the object's children")
    @RequestMapping(value={"/{collectionId}/{recordId}/children.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getChildren(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_CHILDREN, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    @ApiOperation(value="returns the object's parent")
    @RequestMapping(value={"/{collectionId}/{recordId}/parent.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getParent(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_PARENT, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    @ApiOperation(value="returns the object's preceding siblings")
    @RequestMapping(value={"/{collectionId}/{recordId}/preceding-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getPrecedingSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_PRECEDING_SIBLINGS, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    @SwaggerIgnore
    @RequestMapping(value={"/{collectionId}/{recordId}/preceeding-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getPreceedingSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_PRECEDING_SIBLINGS, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    @ApiOperation(value="returns the object's following siblings")
    @RequestMapping(value={"/{collectionId}/{recordId}/following-siblings.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ModelAndView getFollowingSiblings(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="") String profile, @RequestParam(value="wskey", required=true) String wskey, @RequestParam(value="limit", required=true, defaultValue="10") int limit, @RequestParam(value="offset", required=true, defaultValue="0") int offset, @RequestParam(value="callback", required=false) String callback, HttpServletRequest request, HttpServletResponse response) {
        return this.hierarchyTemplate(RecordType.HIERARCHY_FOLLOWING_SIBLINGS, collectionId, recordId, profile, wskey, limit, offset, callback, request, response);
    }

    private ModelAndView hierarchyTemplate(RecordType recordType, String collectionId, String recordId, String profile, String wskey, int limit, int offset, String callback, HttpServletRequest request, HttpServletResponse response) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        String rdfAbout = "/" + collectionId + "/" + recordId;
        HierarchyTemplateRunner runner = new HierarchyTemplateRunner(recordType, rdfAbout, profile, wskey, limit, offset, callback, request, response, this.log, this.controllerUtils, this.searchService);
        Future future = service.submit(runner);
        try {
            return (ModelAndView)future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return this.generateErrorHierarchy(recordType, rdfAbout, wskey, callback, "InterruptedException");
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return this.generateErrorHierarchy(recordType, rdfAbout, wskey, callback, "ExecutionException");
        }
    }

    private ModelAndView generateErrorHierarchy(RecordType recordType, String rdfAbout, String wskey, String callback, String exceptionType) {
        return JsonUtils.toJson((Object)new ApiError(wskey, String.format(exceptionType + " thrown when processing record %s", rdfAbout), -1L), (String)callback);
    }

    protected static String getAction(RecordType recordType) {
        String action = "";
        if (recordType.equals((Object)RecordType.HIERARCHY_CHILDREN)) {
            action = "children.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_SELF)) {
            action = "self.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_PARENT)) {
            action = "parent.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_FOLLOWING_SIBLINGS)) {
            action = "following-siblings.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_PRECEDING_SIBLINGS)) {
            action = "preceding-siblings.json";
        } else if (recordType.equals((Object)RecordType.HIERARCHY_ANCESTOR_SELF_SIBLINGS)) {
            action = "ancestor-self-siblings.json";
        }
        return action;
    }
}

