/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.model.enums.FacetNames;
import eu.europeana.api2.v2.model.json.common.LabelFrequency;
import eu.europeana.api2.v2.model.json.view.submodel.Facet;
import eu.europeana.api2.v2.model.json.view.submodel.SpellCheck;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.CommonPropertyExtractor;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.ImagePropertyExtractor;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.VideoPropertyExtractor;
import eu.europeana.corelib.search.service.impl.FacetLabelExtractor;
import eu.europeana.crf_faketags.extractor.MediaTypeEncoding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.SpellCheckResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelUtils {
    private ModelUtils() {
    }

    public static String getFacetName(Integer tag) {
        MediaTypeEncoding mediaType = CommonPropertyExtractor.getType((Integer)tag);
        String mimeType = CommonPropertyExtractor.getMimeType((Integer)tag);
        if (StringUtils.isNotBlank((String)mimeType)) {
            return "MIME_TYPE";
        }
        switch (2.$SwitchMap$eu$europeana$crf_faketags$extractor$MediaTypeEncoding[mediaType.ordinal()]) {
            case 1: {
                String label = ImagePropertyExtractor.getAspectRatio((int)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return "IMAGE_ASPECTRATIO";
                }
                label = ImagePropertyExtractor.getColor((int)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return "COLOURPALETTE";
                }
                label = ImagePropertyExtractor.getColorSpace((int)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return "greyscale".equalsIgnoreCase(label) ? "IMAGE_GREYSCALE" : "IMAGE_COLOUR";
                }
                label = ImagePropertyExtractor.getSize((int)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return "IMAGE_SIZE";
                }
                return label;
            }
            case 2: {
                String label = VideoPropertyExtractor.getDuration((Integer)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return "VIDEO_DURATION";
                }
                label = VideoPropertyExtractor.getQuality((Integer)tag);
                if (StringUtils.isNotBlank((String)label)) {
                    return "VIDEO_HD";
                }
                return "";
            }
        }
        return "";
    }

    public static List<Facet> conventFacetList(List<FacetField> facetFields) {
        if (facetFields == null || facetFields.isEmpty()) {
            return null;
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        HashMap mediaTypeFacets = new HashMap();
        for (FacetNames facetName : FacetNames.values()) {
            mediaTypeFacets.put(facetName, new HashMap());
        }
        for (FacetField facetField : facetFields) {
            if (facetField.getValues() == null) continue;
            Facet facet = new Facet();
            facet.name = facetField.getName();
            if (FacetNames.IS_FULLTEXT.name().equalsIgnoreCase(facet.name)) {
                facet.name = FacetNames.IS_FULLTEXT.getRealName();
            } else if (FacetNames.HAS_MEDIA.name().equalsIgnoreCase(facet.name)) {
                facet.name = FacetNames.HAS_MEDIA.getRealName();
            } else if (FacetNames.HAS_THUMBNAILS.name().equalsIgnoreCase(facet.name)) {
                facet.name = FacetNames.HAS_THUMBNAILS.getRealName();
            }
            for (FacetField.Count count : facetField.getValues()) {
                if (!StringUtils.isNotEmpty((String)count.getName()) || count.getCount() <= 0L) continue;
                if (!facetField.getName().equalsIgnoreCase("facet_tags")) {
                    LabelFrequency value = new LabelFrequency();
                    value.count = count.getCount();
                    value.label = count.getName();
                    facet.fields.add(value);
                    continue;
                }
                Integer tag = Integer.valueOf(count.getName());
                String label = FacetLabelExtractor.getFacetLabel((Integer)tag).trim();
                if (label.isEmpty()) continue;
                FacetNames facetName = FacetNames.valueOf((String)ModelUtils.getFacetName((Integer)tag).trim().toUpperCase());
                Long value = (Long)((Map)mediaTypeFacets.get(facetName)).get(label);
                if (null == value) {
                    value = 0L;
                }
                ((Map)mediaTypeFacets.get(facetName)).put(label, value + count.getCount());
            }
            if (facet.fields.isEmpty()) continue;
            facets.add(facet);
        }
        for (Map.Entry entry : mediaTypeFacets.entrySet()) {
            if (((Map)entry.getValue()).isEmpty()) continue;
            Facet facet = new Facet();
            facet.name = ((FacetNames)entry.getKey()).getRealName();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                LabelFrequency freq = new LabelFrequency();
                freq.label = (String)entry2.getKey();
                freq.count = (Long)entry2.getValue();
                facet.fields.add(freq);
            }
            facets.add(facet);
        }
        for (Facet facet : facets) {
            Collections.sort(facet.fields, new /* Unavailable Anonymous Inner Class!! */);
        }
        return facets;
    }

    public static SpellCheck convertSpellCheck(SpellCheckResponse response) {
        if (response != null) {
            SpellCheck spellCheck = new SpellCheck();
            spellCheck.correctlySpelled = response.isCorrectlySpelled();
            for (SpellCheckResponse.Suggestion suggestion : response.getSuggestions()) {
                for (int i = 0; i < suggestion.getNumFound(); ++i) {
                    LabelFrequency value = new LabelFrequency();
                    value.label = (String)suggestion.getAlternatives().get(i);
                    value.count = ((Integer)suggestion.getAlternativeFrequencies().get(i)).longValue();
                    spellCheck.suggestions.add(value);
                }
            }
            return spellCheck;
        }
        return null;
    }
}

