/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.query.Query;
import eu.europeana.api2.v2.model.json.sugarcrm.DataSet;
import eu.europeana.api2.v2.model.json.sugarcrm.Provider;
import eu.europeana.api2.v2.model.json.sugarcrm.SugarCRMSearchResults;
import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaRetrievableField;
import eu.europeana.uim.sugarcrmclient.enums.EuropeanaUpdatableField;
import eu.europeana.uim.sugarcrmclient.internal.helpers.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class SugarCRMCache {
    @Log
    private Logger log;
    @Resource(name="corelib_db_morphia_datastore_sugarcrmcache")
    private Datastore datastore;

    public SugarCRMSearchResults<Provider> getProviders() {
        return this.getProviders(null, 0, 0);
    }

    public SugarCRMSearchResults<Provider> getProviders(String country, int offset, int pagesize) {
        SugarCRMSearchResults results = new SugarCRMSearchResults("");
        Query query = this.datastore.find(Provider.class);
        if (country != null) {
            query.filter("country", (Object)country.toUpperCase());
        }
        if (offset != 0 && pagesize != 0) {
            query.offset(offset);
            query.limit(pagesize);
        }
        if (offset == 0 && pagesize != 0) {
            query.offset(0);
            query.limit(pagesize);
        }
        if (offset != 0 && pagesize == 0) {
            query.offset(offset);
        }
        List providers = query.asList();
        results.totalResults = this.datastore.find(Provider.class).countAll();
        results.items = providers;
        for (Provider provider : providers) {
            this.inflateProvider(provider);
        }
        return results;
    }

    public SugarCRMSearchResults<DataSet> getCollections() {
        return this.getCollections(0, 0);
    }

    public SugarCRMSearchResults<DataSet> getCollections(int offset, int pagesize) {
        return this.getCollections(0, 0, null, null, null);
    }

    public SugarCRMSearchResults<DataSet> getCollections(int offset, int pagesize, String name, String country, String status) {
        String sysId;
        SugarCRMSearchResults results = new SugarCRMSearchResults("");
        Query query = this.datastore.find(DataSet.class);
        if (StringUtils.isNotBlank((String)name)) {
            query.field("savedsugarcrmFields.name").equal((Object)name);
        }
        if (StringUtils.isNotBlank((String)country)) {
            query.field("savedsugarcrmFields.country_c").equal((Object)country);
        }
        if (StringUtils.isNotBlank((String)status) && StringUtils.isNotBlank((String)(sysId = ClientUtils.translateDsStatusDescription((String)status)))) {
            query.field("savedsugarcrmFields.sales_stage").equal((Object)sysId);
        }
        if (offset != 0 && pagesize != 0) {
            query.offset(offset);
            query.limit(pagesize);
        }
        if (offset == 0 && pagesize != 0) {
            query.offset(0);
            query.limit(pagesize);
        }
        if (offset != 0 && pagesize == 0) {
            query.offset(offset);
        }
        List dataSets = query.asList();
        results.totalResults = query.countAll();
        results.items = dataSets;
        for (DataSet dataSet : dataSets) {
            this.inflateDataset(dataSet);
        }
        return results;
    }

    public SugarCRMSearchResults<Provider> getProviderbyID(String id) {
        SugarCRMSearchResults results = new SugarCRMSearchResults("");
        results.items = new ArrayList();
        Provider provider = (Provider)((Query)this.datastore.find(Provider.class).field("_id").equal((Object)id)).get();
        if (provider != null) {
            this.inflateProvider(provider);
            results.items.add(provider);
        }
        return results;
    }

    public SugarCRMSearchResults<DataSet> getCollectionByID(String id) {
        SugarCRMSearchResults results = new SugarCRMSearchResults("");
        results.items = new ArrayList();
        DataSet dataSet = (DataSet)((Query)this.datastore.find(DataSet.class).field("_id").equal((Object)id)).get();
        if (dataSet != null) {
            this.inflateDataset(dataSet);
            results.items.add(dataSet);
        }
        return results;
    }

    public SugarCRMSearchResults<DataSet> getCollectionByProviderID(String id) {
        List dataSets = ((Query)this.datastore.find(DataSet.class).field("provIdentifier").equal((Object)id)).asList();
        for (DataSet dataSet : dataSets) {
            this.inflateDataset(dataSet);
        }
        SugarCRMSearchResults results = new SugarCRMSearchResults("");
        results.items = new ArrayList();
        results.items.addAll(dataSets);
        return results;
    }

    private void inflateDataset(DataSet dataSet) {
        String delrecordsStr;
        dataSet.status = ClientUtils.translateStatus((String)((String)dataSet.savedsugarcrmFields.get(EuropeanaUpdatableField.STATUS.getFieldId())));
        dataSet.edmDatasetName = (String)dataSet.savedsugarcrmFields.get(EuropeanaRetrievableField.NAME.getFieldId());
        dataSet.creationDate = (String)dataSet.savedsugarcrmFields.get(EuropeanaRetrievableField.DATE_ENTERED.getFieldId());
        dataSet.providerName = (String)dataSet.savedsugarcrmFields.get(EuropeanaRetrievableField.ORGANIZATION_NAME.getFieldId());
        String precordsStr = (String)dataSet.savedsugarcrmFields.get(EuropeanaUpdatableField.TOTAL_INGESTED.getFieldId());
        if (precordsStr != null) {
            try {
                dataSet.publishedRecords = Long.parseLong(precordsStr);
            }
            catch (Exception ex) {
                dataSet.publishedRecords = 0L;
            }
        }
        if ((delrecordsStr = (String)dataSet.savedsugarcrmFields.get(EuropeanaUpdatableField.DELETED_RECORDS.getFieldId())) != null) {
            dataSet.deletedRecords = Long.parseLong(delrecordsStr);
        }
    }

    private void inflateProvider(Provider provider) {
        provider.name = (String)provider.savedsugarcrmFields.get("name");
        provider.country = (String)provider.savedsugarcrmFields.get("country_c");
        provider.name = (String)provider.savedsugarcrmFields.get("name");
        provider.altname = (String)provider.savedsugarcrmFields.get("name_alt_c");
        provider.acronym = (String)provider.savedsugarcrmFields.get("name_acronym_c");
        provider.domain = (String)provider.savedsugarcrmFields.get("account_type");
        provider.geolevel = (String)provider.savedsugarcrmFields.get("geo_level_c");
        provider.role = ClientUtils.translateType((String)((String)provider.savedsugarcrmFields.get("agg_status_c")));
        provider.scope = (String)provider.savedsugarcrmFields.get("scope_c");
        provider.sector = (String)provider.savedsugarcrmFields.get("sector_c");
        provider.website = (String)provider.savedsugarcrmFields.get("website");
    }
}

