/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@PropertySource(value={"classpath:swagger.properties"})
public class SwaggerConfig {
    @Value(value="${api2.url}")
    private String apiUrl;
    @Value(value="${api2.canonical.url}")
    private String apiCanonicalUrl;

    @Bean
    public Docket customImplementation() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.withClassAnnotation(SwaggerSelect.class)).apis(Predicates.not((Predicate)Predicates.or((Predicate)RequestHandlerSelectors.withMethodAnnotation(SwaggerIgnore.class), (Predicate)RequestHandlerSelectors.withClassAnnotation(SwaggerIgnore.class)))).build().host(this.hostUrl()).apiInfo(this.apiInfo());
    }

    ApiInfo apiInfo() {
        return new ApiInfo("Europeana REST API", "This Swagger API console provides an overview of and interface to the Europeana REST API. You can build and test anything from the simplest search to a complex query using facets such as dates, geotags and permissions. For more help and information, head to our comprehensive <a href=\"http://labs.europeana.api/api/\">online documentation</a>.", "2.0.14", "Contact Email", "development-core@europeanalabs.eu", "Terms of use", "http://www.europeana.eu/portal/rights/api-terms-of-use.html");
    }

    private String hostUrl() {
        String hostUrl;
        String string = StringUtils.isNotBlank((String)this.apiUrl) ? this.apiUrl : (hostUrl = StringUtils.isNotBlank((String)this.apiCanonicalUrl) ? this.apiCanonicalUrl : "http://europeana.eu");
        if (hostUrl.toLowerCase().indexOf("/api") != -1) {
            return hostUrl.substring(0, hostUrl.toLowerCase().indexOf("/api"));
        }
        return hostUrl;
    }
}

