/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import eu.europeana.api2.v2.schedule.SugarCRMPollingScheduler;
import eu.europeana.api2.v2.service.SugarCRMCache;
import eu.europeana.api2.v2.service.SugarCRMImporter;
import eu.europeana.api2.v2.utils.ControllerUtils;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ImportResource(value={"classpath:corelib-logging-context.xml", "classpath:corelib-db-context.xml", "classpath:corelib-solr-context.xml", "classpath:corelib-utils-context.xml", "classpath:corelib-web-context.xml", "classpath:spring-sugarcrmclient.xml"})
@EnableScheduling
@PropertySource(value={"classpath:europeana.properties"})
public class AppConfig {
    @Value(value="${cachemongodb.host}")
    private String cacheHost;
    @Value(value="${cachemongodb.port}")
    private int cachePort;

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertySourcesPlaceholderConfigurer.setLocation((Resource)new ClassPathResource("europeana.properties"));
        return propertySourcesPlaceholderConfigurer;
    }

    @Bean
    public ControllerUtils controllerUtils() {
        return new ControllerUtils();
    }

    @Bean(name={"sugarCRMPoller"})
    public SugarCRMPollingScheduler sugarCRMPollingScheduler() {
        return new SugarCRMPollingScheduler();
    }

    @Bean
    public SugarCRMCache sugarCRMCache() {
        return new SugarCRMCache();
    }

    @Bean
    public SugarCRMImporter sugarCRMImporter() {
        return new SugarCRMImporter();
    }

    @Bean(name={"api_db_mongo_cache"})
    public Mongo ApiDbMongoCache() throws UnknownHostException {
        return new MongoClient(this.cacheHost, this.cachePort);
    }
}

