/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api.commons.definitions.statistics.entity.EntityStats;
import eu.europeana.api.commons.definitions.statistics.search.HighQualityMetric;
import eu.europeana.api.commons.definitions.statistics.search.SearchMetric;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api2.v2.service.RouteDataService;
import eu.europeana.api2.v2.utils.UsageStatsUtils;
import eu.europeana.api2.v2.web.controller.BaseController;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.web.exception.EuropeanaException;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
@SwaggerSelect
public class UsageStatsController
extends BaseController {
    public UsageStatsController(RouteDataService routeService) {
        super(routeService);
    }

    @GetMapping(value={"/record/stats"}, produces={"application/json"})
    public ResponseEntity<String> generateUsageStats(HttpServletRequest request) throws EuropeanaException, HttpException {
        this.verifyReadAccess(request);
        return this.getSearchMetric(request);
    }

    private ResponseEntity<String> getSearchMetric(HttpServletRequest request) throws EuropeanaException {
        SolrClient solrClient = this.getSolrClient(request.getServerName());
        SearchMetric metric = new SearchMetric();
        metric.setType("OverallTotal");
        this.getEntityLinkedItem(solrClient, metric);
        this.getHighQualityMetric(solrClient, metric);
        metric.setTimestamp(new Date());
        return new ResponseEntity((Object)this.serializeToJson((Object)metric), HttpStatus.OK);
    }

    private void getEntityLinkedItem(SolrClient solrClient, SearchMetric searchMetric) {
        EntityStats linkedItemMetric = new EntityStats();
        linkedItemMetric.setPlaces(this.getLinkedItems(solrClient, "place").longValue());
        linkedItemMetric.setAgents(this.getLinkedItems(solrClient, "agent").longValue());
        linkedItemMetric.setConcepts(this.getLinkedItems(solrClient, "concept").longValue());
        linkedItemMetric.setOrganisations(this.getLinkedItems(solrClient, "organization").longValue());
        linkedItemMetric.setTimespans(this.getLinkedItems(solrClient, "timespan").longValue());
        linkedItemMetric.setAll(this.searchService.getItemsLinkedToEntity(solrClient, UsageStatsUtils.createAllQuery()).longValue());
        searchMetric.setItemsLinkedToEntities(linkedItemMetric);
    }

    private void getHighQualityMetric(SolrClient solrClient, SearchMetric searchMetric) {
        searchMetric.setAllRecords(this.getMetric(solrClient, new Query("*")));
        searchMetric.setNonCompliantRecord(this.getMetric(solrClient, new Query("contentTier:0")));
        searchMetric.setAllCompliantRecords(this.getMetric(solrClient, new Query("NOT contentTier:0")));
        searchMetric.setHighQualityData(this.getMetric(solrClient, new Query("contentTier:(2 OR 3 OR 4) AND NOT metadataTier:0")));
        searchMetric.setHighQualityContent(this.getMetric(solrClient, new Query("contentTier:(2 OR 3 OR 4)")));
        searchMetric.setHighQualityReusableContent(this.getMetric(solrClient, new Query("contentTier:(3 OR 4)")));
        searchMetric.setHighQualityMetadata(this.getMetric(solrClient, new Query("NOT metadataTier:0")));
    }

    private Long getLinkedItems(SolrClient solrClient, String entityType) {
        return this.searchService.getItemsLinkedToEntity(solrClient, UsageStatsUtils.createQueryForLinkedItems((String)entityType));
    }

    private HighQualityMetric getMetric(SolrClient solrClient, Query query) {
        return UsageStatsUtils.processFacetMap((Map)this.searchService.getFacet(solrClient, query, SolrFacetType.TYPE));
    }
}

