/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api.translation.definitions.model.TranslationObj;
import eu.europeana.api2.v2.model.translate.TranslationMap;
import eu.europeana.api2.v2.service.translate.BaseService;
import eu.europeana.api2.v2.service.translate.LanguageDetectionUtils;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.entity.ContextualClass;
import eu.europeana.corelib.utils.ComparatorUtils;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class TranslationUtils {
    private static final Logger LOG = LogManager.getLogger(TranslationUtils.class);
    public static final String FIELD_SEPARATOR = ".";
    public static final String FIELD_SEPARATOR_REGEX = "\\.";
    private static String getPharse = "^.*?(?=[.|?|!])";
    public static final Pattern getValuesBeforePhrasePattern = Pattern.compile(getPharse);
    public static final String TRUNCATED_INDICATOR = "...";

    public static boolean ifValuesShouldBePickedForTranslation(Map<String, List<String>> map, String sourceLang, String targetLang) {
        return map != null && !map.isEmpty() && !TranslationUtils.containsLangOrRegionLang(map, (String)targetLang) && TranslationUtils.containsLangOrRegionLang(map, (String)sourceLang);
    }

    private static boolean containsLangOrRegionLang(Map<String, List<String>> multilingualMap, String lang) {
        return multilingualMap.containsKey(lang) || multilingualMap.keySet().stream().anyMatch(key -> !StringUtils.equals((CharSequence)key, (CharSequence)"def") && key.startsWith(lang));
    }

    public static List<TranslationObj> createTranslationRequest(List<String> textsToTranslate, String targetLanguage, String sourceLanguage) {
        ArrayList<TranslationObj> translationObjs = new ArrayList<TranslationObj>(textsToTranslate.size());
        for (String text : textsToTranslate) {
            TranslationObj translationObj = new TranslationObj();
            translationObj.setText(text);
            translationObj.setSourceLang(sourceLanguage);
            translationObj.setTargetLang(targetLanguage);
            translationObjs.add(translationObj);
        }
        return translationObjs;
    }

    public static List<String> getValuesToTranslate(Map<String, List<String>> origFieldData, String sourceLang, String targetLang, FullBean bean, boolean onlyLiterals, Integer translationCharLimit, Integer translationCharTolerance) {
        List<String> valuesToTranslate = new ArrayList();
        if (onlyLiterals) {
            valuesToTranslate = LanguageDetectionUtils.filterOutUris((List)TranslationUtils.getValueFromMultiLingualMap(origFieldData, (String)sourceLang));
        } else {
            for (String value : TranslationUtils.getValueFromMultiLingualMap(origFieldData, (String)sourceLang)) {
                if (EuropeanaUriUtils.isUri((String)value)) {
                    ContextualClass entity = BaseService.entityExistsWithUrl((FullBean)bean, (String)value);
                    if (entity != null && TranslationUtils.ifValuesShouldBePickedForTranslation((Map)entity.getPrefLabel(), (String)sourceLang, (String)targetLang)) {
                        LOG.debug("Entity {} has preflabel in chosen language {} for translation  ", (Object)value, (Object)sourceLang);
                        valuesToTranslate.addAll(TranslationUtils.getValueFromMultiLingualMap((Map)entity.getPrefLabel(), (String)sourceLang));
                        continue;
                    }
                    LOG.debug("Entity {} already has value in target language {}", (Object)(entity != null ? entity.getAbout() : ""), (Object)targetLang);
                    continue;
                }
                valuesToTranslate.add(value);
            }
        }
        List cleanValues = ComparatorUtils.removeDuplicates(valuesToTranslate);
        if (translationCharLimit != null && translationCharTolerance != null) {
            return TranslationUtils.truncate((List)cleanValues, (Integer)translationCharLimit, (Integer)translationCharTolerance);
        }
        return cleanValues;
    }

    private static List<String> getValueFromMultiLingualMap(Map<String, List<String>> map, String lang) {
        List valuesToTranslate = map.get(lang);
        if (valuesToTranslate == null || valuesToTranslate.isEmpty()) {
            valuesToTranslate = map.entrySet().stream().filter(entry -> !StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"def") && ((String)entry.getKey()).startsWith(lang)).map(Map.Entry::getValue).findFirst().orElse(null);
        }
        return valuesToTranslate;
    }

    public static List<String> truncate(List<String> valuesToTranslate, Integer translationCharLimit, Integer translationCharTolerance) {
        ArrayList<String> truncatedValues = new ArrayList<String>();
        boolean noFurtherLooking = false;
        Integer charAccumulated = 0;
        for (String value : valuesToTranslate) {
            if (charAccumulated + value.length() >= translationCharLimit) {
                Integer charLimitIndex = translationCharLimit - charAccumulated;
                String valueAfterLimit = StringUtils.substring((String)value, (int)charLimitIndex, (int)value.length());
                Matcher m = getValuesBeforePhrasePattern.matcher(valueAfterLimit);
                if (m.find()) {
                    truncatedValues.add(StringUtils.substring((String)value, (int)0, (int)charLimitIndex) + m.group(0) + "...");
                } else {
                    truncatedValues.add(WordUtils.abbreviate((String)value, (int)charLimitIndex, (int)(translationCharLimit + translationCharTolerance), (String)"..."));
                }
                noFurtherLooking = true;
            } else {
                truncatedValues.add(value);
            }
            charAccumulated = charAccumulated + value.length();
            if (!noFurtherLooking) continue;
            break;
        }
        return truncatedValues;
    }

    public static void optimisation(TranslationMap prefLabelsAcrossProxyInSourceLang, TranslationMap textToTranslate) {
        for (Map.Entry entry : prefLabelsAcrossProxyInSourceLang.entrySet()) {
            if (!textToTranslate.containsKey(entry.getKey())) continue;
            List valuesRemoved = LanguageDetectionUtils.removeCaseSensitiveValuesFromList((List)((List)textToTranslate.get(entry.getKey())), (List)((List)entry.getValue()));
            if (!valuesRemoved.isEmpty() && LOG.isDebugEnabled()) {
                LOG.debug("Optimisation performed for field {} with values - {}", entry.getKey(), (Object)valuesRemoved);
            }
            if (!((List)textToTranslate.get(entry.getKey())).isEmpty()) continue;
            textToTranslate.remove(entry.getKey());
        }
    }

    public static void getPrefLabelsAcrossProxyInSourceLang(FullBean bean, Field field, Map<String, List<String>> existingMap, String sourceLang, String targetLang, TranslationMap prefLabelsAcrossProxyInSourceLang) {
        if (existingMap != null && !existingMap.isEmpty() && existingMap.containsKey("def")) {
            List<String> defValues = existingMap.get("def");
            List onlyUris = TranslationUtils.getUris(defValues);
            for (String value : onlyUris) {
                List prefLabels;
                if (!EuropeanaUriUtils.isUri((String)value) || (prefLabels = TranslationUtils.getPrefLabelValuesInSourceLang((FullBean)bean, (String)value, (String)sourceLang, (String)targetLang)) == null || prefLabels.isEmpty()) continue;
                if (prefLabelsAcrossProxyInSourceLang.containsKey((Object)field.getName())) {
                    prefLabels.removeAll((Collection)prefLabelsAcrossProxyInSourceLang.get((Object)field.getName()));
                }
                prefLabelsAcrossProxyInSourceLang.add(field.getName(), prefLabels);
            }
        }
    }

    private static List<String> getPrefLabelValuesInSourceLang(FullBean bean, String uri, String sourceLang, String targetLang) {
        ContextualClass entity = BaseService.entityExistsWithUrl((FullBean)bean, (String)uri);
        if (entity != null && entity.getPrefLabel() != null && !entity.getPrefLabel().isEmpty() && TranslationUtils.containsLangOrRegionLang((Map)entity.getPrefLabel(), (String)sourceLang) && TranslationUtils.containsLangOrRegionLang((Map)entity.getPrefLabel(), (String)targetLang)) {
            return TranslationUtils.getValueFromMultiLingualMap((Map)entity.getPrefLabel(), (String)sourceLang);
        }
        return Collections.emptyList();
    }

    private static List<String> getUris(List<String> values) {
        if (values != null && !values.isEmpty()) {
            return values.stream().filter(EuropeanaUriUtils::isUri).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

