/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api.translation.client.TranslationApiClient;
import eu.europeana.api.translation.definitions.language.Language;
import eu.europeana.api2.v2.service.translate.BaseService;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.edm.utils.EdmUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class MetadataChosenLanguageService
extends BaseService {
    private static final Logger LOG = LogManager.getLogger(MetadataChosenLanguageService.class);

    public MetadataChosenLanguageService(TranslationApiClient translationApiClient) {
        super(translationApiClient);
    }

    public <T extends IdBean> String getMostRepresentativeLanguage(T bean, String targetLanguage, boolean searchResults) {
        HashMap langCountMap = new HashMap();
        if (searchResults) {
            ReflectionUtils.doWithFields((Class)bean.getClass(), field -> this.getLanguageAndCount((Object)bean, field, langCountMap, targetLanguage, searchResults), (ReflectionUtils.FieldFilter)BaseService.searchFieldFilter);
        } else {
            List proxies = ((FullBean)bean).getProxies();
            for (Proxy proxy : proxies) {
                ReflectionUtils.doWithFields((Class)proxy.getClass(), field -> this.getLanguageAndCount((Object)proxy, field, langCountMap, targetLanguage, searchResults), (ReflectionUtils.FieldFilter)BaseService.proxyFieldFilter);
            }
        }
        if (langCountMap.isEmpty()) {
            LOG.error("Most representative languages NOT present for search results. Languages present are either zxx or def or not-supported by the translation engine");
            return null;
        }
        return this.getMostRepresentativeLanguage(langCountMap);
    }

    private String getMostRepresentativeLanguage(Map<String, Integer> langCountMap) {
        Map reverseMap = langCountMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        List languagesWithMostvalues = reverseMap.get(Collections.max(reverseMap.keySet()));
        LOG.debug("Language with most values {}", languagesWithMostvalues);
        if (languagesWithMostvalues.size() > 1) {
            Optional<String> langWithHigherPrecedance = BaseService.PRECENDANCE_LIST.stream().filter(languagesWithMostvalues::contains).findFirst();
            if (langWithHigherPrecedance.isPresent()) {
                return langWithHigherPrecedance.get();
            }
            LOG.warn("Language not found in the precedence list. Hence, will return the first language out of - {} ", languagesWithMostvalues);
        }
        return (String)languagesWithMostvalues.get(0);
    }

    private Map<String, List<String>> getLanguageValueMap(Object object, Field field, boolean searchResults) {
        if (searchResults) {
            return EdmUtils.cloneMap((Map)((Map)BaseService.getValueOfTheField((Object)object, (boolean)false).apply(field.getName())));
        }
        return (Map)BaseService.getValueOfTheField((Object)object, (boolean)false).apply(field.getName());
    }

    private void getLanguageAndCount(Object object, Field field, Map<String, Integer> langCountMap, String targetLang, boolean searchResults) {
        Map langValueMap = this.getLanguageValueMap(object, field, searchResults);
        if (!langValueMap.isEmpty()) {
            for (Map.Entry langValue : langValueMap.entrySet()) {
                String key = Language.stripLangStringIfRegionPresent((String)((String)langValue.getKey()));
                if (!this.languageToBeChosen(key, targetLang)) continue;
                Integer value = ((List)langValue.getValue()).size();
                if (langCountMap.containsKey(key)) {
                    value = value + langCountMap.get(key);
                }
                langCountMap.put(key, value);
            }
        }
    }

    private boolean languageToBeChosen(String lang, String targetLanguage) {
        return !StringUtils.equals((CharSequence)lang, (CharSequence)"zxx") && !StringUtils.equals((CharSequence)lang, (CharSequence)"def") && this.getTranslationApiClient().getTranslationService().isSupported(lang, targetLanguage);
    }
}

