/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api.commons.definitions.utils.ComparatorUtils;
import eu.europeana.api.translation.definitions.language.Language;
import eu.europeana.api2.v2.model.translate.LanguageValueFieldMap;
import eu.europeana.api2.v2.service.translate.BaseService;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.ContextualClass;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class LanguageDetectionUtils {
    private static final Logger LOG = LogManager.getLogger(LanguageDetectionUtils.class);

    private LanguageDetectionUtils() {
    }

    public static <T extends IdBean> List<Language> getEdmLanguage(T bean, boolean searchResults) {
        ArrayList<Language> lang = new ArrayList<Language>();
        Map edmLanguage = LanguageDetectionUtils.getLanguageFieldValue(bean, (boolean)searchResults);
        for (Map.Entry entry : edmLanguage.entrySet()) {
            for (String languageAbbreviation : (List)entry.getValue()) {
                if (Language.isSupported((String)languageAbbreviation)) {
                    lang.add(Language.getLanguage((String)languageAbbreviation));
                    continue;
                }
                LOG.warn("edm:language '{}' is not supported", (Object)languageAbbreviation);
            }
        }
        if (!lang.isEmpty()) {
            LOG.debug("EDM language - {} fetched for record - {} ", lang, (Object)(searchResults ? bean.getId() : ((FullBean)bean).getAbout()));
        }
        return lang;
    }

    private static <T extends IdBean> Map<String, List<String>> getLanguageFieldValue(T bean, boolean searchResults) {
        Map<String, List<String>> edmLanguage = new HashMap<String, List<String>>();
        if (searchResults) {
            if (((BriefBean)bean).getLanguage() != null) {
                edmLanguage.put("", Arrays.asList(((BriefBean)bean).getLanguage()));
            }
        } else {
            edmLanguage = ((FullBean)bean).getEuropeanaAggregation().getEdmLanguage();
        }
        return edmLanguage;
    }

    public static List<String> getPrefLabelofEntity(ContextualClass entity, String recordId) {
        ArrayList<String> prefLabels = new ArrayList<String>();
        if (entity != null) {
            if (entity.getPrefLabel() != null) {
                Map map = entity.getPrefLabel();
                if (!map.isEmpty() && !map.keySet().isEmpty()) {
                    if (!map.isEmpty() && !map.keySet().isEmpty() && LanguageDetectionUtils.mapHasOtherLanguagesThanDef(map.keySet())) {
                        LOG.debug("Entity {} already has language tagged values. PrefLabels NOT added...", (Object)entity.getAbout());
                    } else {
                        LOG.debug("Entity {} has only non-language tagged values. Adding the prefLabels...", (Object)entity.getAbout());
                        prefLabels.addAll((Collection)map.get("def"));
                    }
                }
            } else {
                LOG.error("prefLabels NOT available for entity {} in record {} .", (Object)entity.getAbout(), (Object)recordId);
            }
        }
        return prefLabels;
    }

    public static void getTextsForDetectionRequest(List<String> textsForDetection, Map<String, Integer> textsPerField, List<LanguageValueFieldMap> langValueFieldMapForDetection) {
        for (LanguageValueFieldMap languageValueFieldMap : langValueFieldMapForDetection) {
            for (Map.Entry def : languageValueFieldMap.entrySet()) {
                textsForDetection.addAll((Collection)def.getValue());
                textsPerField.put(languageValueFieldMap.getFieldName(), ((List)def.getValue()).size());
            }
        }
    }

    public static List<LanguageValueFieldMap> getLangDetectedFieldValueMap(Map<String, Integer> textsPerField, List<String> detectedLanguages, List<String> textsForDetection) {
        int counter = 0;
        ArrayList<LanguageValueFieldMap> correctLangMap = new ArrayList<LanguageValueFieldMap>();
        for (Map.Entry<String, Integer> entry : textsPerField.entrySet()) {
            HashMap newValueMap = new HashMap();
            for (int i = 0; i < entry.getValue(); ++i) {
                String newLang = detectedLanguages.get(counter);
                String string = newLang = newLang == null ? "def" : newLang;
                if (newValueMap.containsKey(newLang)) {
                    ((List)newValueMap.get(newLang)).add(textsForDetection.get(counter));
                } else {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(textsForDetection.get(counter));
                    newValueMap.put(newLang, values);
                }
                ++counter;
            }
            correctLangMap.add(new LanguageValueFieldMap(entry.getKey(), newValueMap));
        }
        return correctLangMap;
    }

    public static <T extends IdBean> LanguageValueFieldMap getValueFromLanguageMap(Map<String, List<String>> map, String fieldName, T bean, boolean onlyLiterals) {
        List resolvedNonLangTaggedValues;
        ArrayList<String> defValues = new ArrayList<String>();
        if (!map.isEmpty() && map.containsKey("def")) {
            List<String> values = map.get("def");
            if (LanguageDetectionUtils.mapHasOtherLanguagesThanDef(map.keySet())) {
                defValues.addAll(LanguageDetectionUtils.removeLangTaggedValuesFromDef(map));
            } else {
                defValues.addAll(values);
            }
        }
        List list = resolvedNonLangTaggedValues = onlyLiterals ? LanguageDetectionUtils.filterOutUris(defValues) : LanguageDetectionUtils.checkForUrisAndGetPrefLabel((FullBean)((FullBean)bean), defValues);
        if (!resolvedNonLangTaggedValues.isEmpty()) {
            return new LanguageValueFieldMap(fieldName, "def", resolvedNonLangTaggedValues);
        }
        return null;
    }

    public static List<String> filterOutUris(List<String> values) {
        if (values != null && !values.isEmpty()) {
            return values.stream().filter(v -> !EuropeanaUriUtils.isUri((String)v)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<String> checkForUrisAndGetPrefLabel(FullBean bean, List<String> nonLanguageTaggedValues) {
        ArrayList<String> resolvedNonLangTaggedValues = new ArrayList<String>();
        if (!nonLanguageTaggedValues.isEmpty()) {
            for (String value : nonLanguageTaggedValues) {
                if (EuropeanaUriUtils.isUri((String)value)) {
                    ContextualClass entity = BaseService.entityExistsWithUrl((FullBean)bean, (String)value);
                    if (entity == null) continue;
                    List preflabels = LanguageDetectionUtils.getPrefLabelofEntity((ContextualClass)entity, (String)bean.getAbout());
                    resolvedNonLangTaggedValues.addAll(preflabels);
                    continue;
                }
                resolvedNonLangTaggedValues.add(value);
            }
        }
        ComparatorUtils.removeDuplicates(resolvedNonLangTaggedValues);
        return resolvedNonLangTaggedValues;
    }

    public static boolean mapHasOtherLanguagesThanDef(Set<String> keyset) {
        HashSet<String> copy = new HashSet<String>(keyset);
        copy.remove("def");
        return !copy.isEmpty();
    }

    public static List<String> removeLangTaggedValuesFromDef(Map<String, List<String>> map) {
        ArrayList<String> nonLangTaggedDefvalues = new ArrayList<String>((Collection)map.get("def"));
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (entry.getKey().equals("def")) continue;
            LanguageDetectionUtils.removeCaseSensitiveValuesFromList(nonLangTaggedDefvalues, (List)LanguageDetectionUtils.filterOutUris(entry.getValue()));
        }
        return nonLangTaggedDefvalues;
    }

    public static boolean onlyNulls(List<String> values) {
        return values.stream().noneMatch(Objects::nonNull);
    }

    protected static List<String> removeCaseSensitiveValuesFromList(List<String> listForOptimisation, List<String> valuesToCheck) {
        ArrayList<String> valuesTobeRemoved = new ArrayList<String>();
        valuesToCheck.stream().forEach(literal -> {
            Optional<String> duplicateValue = listForOptimisation.stream().filter(literal::equalsIgnoreCase).findFirst();
            if (duplicateValue.isPresent()) {
                valuesTobeRemoved.add(duplicateValue.get());
            }
        });
        listForOptimisation.removeAll(valuesTobeRemoved);
        return valuesTobeRemoved;
    }
}

