/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api.translation.client.TranslationApiClient;
import eu.europeana.api2.v2.exceptions.TranslationException;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.entity.ContextualClass;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class BaseService {
    private static final Logger LOG = LogManager.getLogger(BaseService.class);
    private final TranslationApiClient translationApiClient;
    protected static final List<String> PRECENDANCE_LIST = List.of("sk", "hr", "pl", "ro", "it", "sv", "bg", "fr", "es", "cs", "de", "lv", "el", "fi", "nl", "hu", "da", "sl", "et", "pt", "lt", "ga", "en");
    private static final Set<String> INCLUDE_PROXY_MAP_FIELDS = Set.of("dcContributor", "dcCoverage", "dcCreator", "dcDate", "dcDescription", "dcFormat", "dcPublisher", "dcRelation", "dcRights", "dcSource", "dcSubject", "dcTitle", "dcType", "dctermsAlternative", "dctermsCreated", "dctermsExtent", "dctermsHasPart", "dctermsHasVersion", "dctermsIsFormatOf", "dctermsIsPartOf", "dctermsIsReferencedBy", "dctermsIsReplacedBy", "dctermsIsRequiredBy", "dctermsIssued", "dctermsMedium", "dctermsProvenance", "dctermsReferences", "dctermsSpatial", "dctermsTemporal", "edmCurrentLocation", "edmHasMet");
    private static final Set<String> SEARCH_FIELDS_TO_TRANSLATE = Set.of("dcTitleLangAware", "dcDescriptionLangAware", "dcCreatorLangAware");
    private static final Set<String> SEARCH_FIELDS_TO_FILTER = Set.of("title", "proxyDcTitle", "dcDescription", "dcCreator");
    private static final List<String> ENTITIES = List.of("agents", "concepts", "places", "timespans");
    public static final ReflectionUtils.FieldFilter proxyFieldFilter = field -> field.getType().isAssignableFrom(Map.class) && INCLUDE_PROXY_MAP_FIELDS.contains(field.getName());
    public static final ReflectionUtils.FieldFilter searchFieldFilter = field -> field.getType().isAssignableFrom(Map.class) && SEARCH_FIELDS_TO_TRANSLATE.contains(field.getName());
    public static final ReflectionUtils.FieldFilter searchFieldRemovalFilter = field -> field.getType().isAssignableFrom(String[].class) && SEARCH_FIELDS_TO_FILTER.contains(field.getName());

    public BaseService(TranslationApiClient translationApiClient) {
        this.translationApiClient = translationApiClient;
    }

    public TranslationApiClient getTranslationApiClient() {
        return this.translationApiClient;
    }

    public static Proxy getEuropeanaProxy(List<? extends Proxy> proxies, String recordId) throws TranslationException {
        Optional<Proxy> europeanaProxy = proxies.stream().filter(Proxy::isEuropeanaProxy).findFirst();
        if (europeanaProxy.isPresent()) {
            return europeanaProxy.get();
        }
        throw new TranslationException("Unexpected data - Europeana proxy not present! Record id - " + recordId);
    }

    public static Function<String, Map<String, List<String>>> getValueOfTheField(Object object, boolean update) {
        return e -> {
            Field field = ReflectionUtils.findField(object.getClass(), (String)e);
            ReflectionUtils.makeAccessible((Field)field);
            Object value = ReflectionUtils.getField((Field)field, (Object)object);
            if (value == null && update) {
                ReflectionUtils.setField((Field)field, (Object)object, new LinkedHashMap());
                value = ReflectionUtils.getField((Field)field, (Object)object);
            }
            if (value instanceof Map) {
                return (Map)value;
            }
            if (value != null) {
                LOG.warn("Unexpected data - field {} did not return a map", e);
            }
            return new LinkedHashMap();
        };
    }

    public static ContextualClass entityExistsWithUrl(FullBean bean, String uri) {
        ArrayList matchingEntity = new ArrayList();
        ReflectionUtils.FieldFilter entityFilter = field -> ENTITIES.contains(field.getName());
        ReflectionUtils.doWithFields((Class)bean.getClass(), field -> {
            if (matchingEntity.size() == 1) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            Object o = ReflectionUtils.getField((Field)field, (Object)bean);
            LOG.trace("Searching for entities with type {}...", (Object)field.getName());
            if (o instanceof List && !((List)o).isEmpty()) {
                List entities = (List)o;
                for (ContextualClass entity : entities) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)uri, (CharSequence)entity.getAbout())) continue;
                    LOG.debug(" Found matching entity for {}", (Object)entity.getAbout());
                    matchingEntity.add(entity);
                    break;
                }
            }
        }, (ReflectionUtils.FieldFilter)entityFilter);
        return matchingEntity.isEmpty() ? null : (ContextualClass)matchingEntity.get(0);
    }
}

