/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service;

import eu.europeana.api2.v2.model.FacetTag;
import eu.europeana.api2.v2.model.json.common.LabelFrequency;
import eu.europeana.api2.v2.model.json.view.submodel.Facet;
import eu.europeana.api2.v2.model.json.view.submodel.FacetRanger;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.RangeFacet;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacetWrangler {
    private static final Logger LOG = LogManager.getLogger(FacetWrangler.class);
    private Map<String, Map<String, Integer>> technicalFacetMap = new LinkedHashMap();

    public FacetWrangler() {
        for (TechnicalFacetType technicalFacet : TechnicalFacetType.values()) {
            this.technicalFacetMap.put(technicalFacet.getRealName(), new LinkedHashMap());
        }
    }

    public List<Facet> consolidateFacetList(List<FacetField> facetFields, List<RangeFacet> rangeFacets, List<String> requestedTechnicalFacets, boolean defaultFacetsRequested, Map<String, Integer> technicalFacetLimits, Map<String, Integer> technicalFacetOffsets, boolean isV3) {
        if ((facetFields == null || facetFields.isEmpty()) && (rangeFacets == null || rangeFacets.isEmpty())) {
            return Collections.emptyList();
        }
        ArrayList<Facet> facetList = new ArrayList<Facet>();
        if (null != facetFields) {
            this.processFacetFields(facetFields, facetList);
        }
        if (null != requestedTechnicalFacets && !requestedTechnicalFacets.isEmpty()) {
            this.processTechnicalFacets(requestedTechnicalFacets, defaultFacetsRequested, technicalFacetLimits, technicalFacetOffsets, facetList);
        }
        if (rangeFacets != null && !rangeFacets.isEmpty()) {
            this.processRangeFacets(rangeFacets, facetList, isV3);
        }
        facetList.sort((f1, f2) -> Integer.compare(f2.fields.size(), f1.fields.size()));
        return facetList;
    }

    private void processFacetFields(List<FacetField> facetFields, List<Facet> facetList) {
        for (FacetField facetField : facetFields) {
            if (facetField.getValues().isEmpty()) continue;
            Facet facet = new Facet();
            facet.name = facetField.getName();
            if (StringUtils.equalsIgnoreCase((CharSequence)SolrFacetType.TEXT_FULLTEXT.toString(), (CharSequence)facet.name)) {
                facet.name = SolrFacetType.TEXT_FULLTEXT.name();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)SolrFacetType.MEDIA.toString(), (CharSequence)facet.name)) {
                facet.name = SolrFacetType.MEDIA.name();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)SolrFacetType.THUMBNAIL.toString(), (CharSequence)facet.name)) {
                facet.name = SolrFacetType.THUMBNAIL.name();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)SolrFacetType.LANDINGPAGE.toString(), (CharSequence)facet.name)) {
                facet.name = SolrFacetType.LANDINGPAGE.name();
            }
            if (facetField.getName().equalsIgnoreCase("facet_tags")) {
                for (FacetField.Count encodedTechnicalFacet : facetField.getValues()) {
                    if (!StringUtils.isNotEmpty((CharSequence)encodedTechnicalFacet.getName()) || encodedTechnicalFacet.getCount() <= 0L) continue;
                    FacetTag facetTag = null;
                    try {
                        facetTag = ModelUtils.decodeFacetTag((Integer)Integer.valueOf(encodedTechnicalFacet.getName()));
                        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{facetTag.getLabel(), facetTag.getName()})) {
                            LOG.debug("Decoded technical Facet's name and/or label is empty");
                            continue;
                        }
                        Integer technicalFacetFieldCount = (Integer)((Map)this.technicalFacetMap.get(facetTag.getName())).get(facetTag.getLabel());
                        if (null == technicalFacetFieldCount) {
                            technicalFacetFieldCount = 0;
                        }
                        ((Map)this.technicalFacetMap.get(facetTag.getName())).put(facetTag.getLabel(), technicalFacetFieldCount + (int)encodedTechnicalFacet.getCount());
                    }
                    catch (IllegalArgumentException e) {
                        assert (facetTag != null);
                        LOG.debug("error matching decoded technical facet name {} with enum type in [consolidateFacetList]: {}", (Object)facetTag.getName(), (Object)e.getClass().getSimpleName(), (Object)e);
                    }
                }
                continue;
            }
            for (FacetField.Count count : facetField.getValues()) {
                if (!StringUtils.isNotEmpty((CharSequence)count.getName()) || count.getCount() <= 0L) continue;
                LabelFrequency facetValue = new LabelFrequency();
                facetValue.count = count.getCount();
                facetValue.label = count.getName();
                facet.fields.add(facetValue);
            }
            if (facet.fields.isEmpty()) continue;
            facetList.add(facet);
        }
    }

    private void processTechnicalFacets(List<String> requestedTechnicalFacets, boolean defaultFacetsRequested, Map<String, Integer> technicalFacetLimits, Map<String, Integer> technicalFacetOffsets, List<Facet> facetList) {
        for (String requestedFacetName : requestedTechnicalFacets) {
            try {
                boolean cantMatchFacetName = false;
                boolean skipIfNoDefault = false;
                String facetLimit = "f." + requestedFacetName + ".facet.limit";
                String facetOffset = "f." + requestedFacetName + ".facet.offset";
                if (((Map)this.technicalFacetMap.get(requestedFacetName)).isEmpty()) {
                    LOG.debug("couldn't match requested technical facet {}", (Object)requestedFacetName);
                    cantMatchFacetName = true;
                }
                Facet facet = new Facet();
                facet.name = requestedFacetName;
                if (!requestedTechnicalFacets.contains(facet.name) && !defaultFacetsRequested) {
                    skipIfNoDefault = true;
                }
                if (cantMatchFacetName || skipIfNoDefault) continue;
                int from = Math.min(null != technicalFacetOffsets && technicalFacetOffsets.containsKey(facetOffset) ? technicalFacetOffsets.get(facetOffset) : 0, ((Map)this.technicalFacetMap.get(requestedFacetName)).size() - 1);
                int to = Math.min(null != technicalFacetLimits && technicalFacetLimits.containsKey(facetLimit) ? technicalFacetLimits.get(facetLimit) + from : ((Map)this.technicalFacetMap.get(requestedFacetName)).size(), ((Map)this.technicalFacetMap.get(requestedFacetName)).size());
                ArrayList keyList = new ArrayList(((Map)this.technicalFacetMap.get(requestedFacetName)).keySet());
                for (int i = from; i < to; ++i) {
                    LabelFrequency freq = new LabelFrequency();
                    freq.label = (String)keyList.get(i);
                    freq.count = ((Integer)((Map)this.technicalFacetMap.get(requestedFacetName)).get(freq.label)).intValue();
                    facet.fields.add(freq);
                }
                facetList.add(facet);
            }
            catch (IllegalArgumentException e) {
                LOG.error("error matching requested technical facet name {} with enum type in [consolidateFacetList]: {}", (Object)requestedFacetName, (Object)e.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    private void processRangeFacets(List<RangeFacet> rangeFacets, List<Facet> facetList, boolean isV3) {
        for (RangeFacet rangeFacet : rangeFacets) {
            if (rangeFacet.getCounts().isEmpty()) continue;
            ArrayList<LabelFrequency> ranges = new ArrayList<LabelFrequency>();
            for (Object countObject : rangeFacet.getCounts()) {
                RangeFacet.Count count = (RangeFacet.Count)countObject;
                if (!StringUtils.isNotEmpty((CharSequence)count.getValue()) || count.getCount() <= 0) continue;
                LabelFrequency rangeValue = new LabelFrequency();
                rangeValue.count = count.getCount();
                rangeValue.label = this.formatDateString(count.getValue(), rangeFacet.getGap());
                ranges.add(rangeValue);
            }
            if (ranges.isEmpty()) continue;
            FacetWrangler.updateRangeFacets(facetList, (boolean)isV3, (String)rangeFacet.getName(), ranges);
        }
    }

    private static void updateRangeFacets(List<Facet> facetList, boolean isV3, String name, List<LabelFrequency> ranges) {
        if (isV3) {
            Facet facetRanger = new Facet();
            facetRanger.name = name;
            facetRanger.fields.addAll(ranges);
            facetList.add(facetRanger);
        } else {
            FacetRanger facetRanger = new FacetRanger();
            facetRanger.name = name;
            facetRanger.ranges.addAll(ranges);
            facetList.add((Facet)facetRanger);
        }
    }

    private String formatDateString(String value, Object gap) {
        String gapString = gap.toString();
        String[] dateParts = StringUtils.split((String)value, (String)"-T");
        if (StringUtils.containsIgnoreCase((CharSequence)gapString, (CharSequence)"DAY")) {
            return dateParts[0] + "-" + dateParts[1] + "-" + dateParts[2];
        }
        if (StringUtils.containsIgnoreCase((CharSequence)gapString, (CharSequence)"MONTH")) {
            return dateParts[0] + "-" + dateParts[1];
        }
        if (StringUtils.containsIgnoreCase((CharSequence)gapString, (CharSequence)"YEAR")) {
            return dateParts[0];
        }
        return value;
    }
}

