/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api.translation.client.TranslationApiClient;
import eu.europeana.api.translation.definitions.model.TranslationObj;
import eu.europeana.api2.v2.exceptions.TranslationException;
import eu.europeana.api2.v2.model.translate.TranslationMap;
import eu.europeana.api2.v2.service.translate.BaseService;
import eu.europeana.api2.v2.service.translate.LanguageDetectionUtils;
import eu.europeana.api2.v2.service.translate.MetadataChosenLanguageService;
import eu.europeana.api2.v2.service.translate.TranslationUtils;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.edm.utils.EdmUtils;
import eu.europeana.corelib.utils.ComparatorUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class MetadataTranslationService
extends BaseService {
    private static final Logger LOG = LogManager.getLogger(MetadataTranslationService.class);
    private final MetadataChosenLanguageService metadataChosenLanguageService;
    private final Integer translationCharLimit;
    private final Integer translationCharTolerance;

    public MetadataTranslationService(TranslationApiClient translationApiClient, MetadataChosenLanguageService metadataChosenLanguageService, Integer translationCharLimit, Integer translationCharTolerance) {
        super(translationApiClient);
        this.metadataChosenLanguageService = metadataChosenLanguageService;
        this.translationCharLimit = translationCharLimit;
        this.translationCharTolerance = translationCharTolerance;
    }

    public List<BriefBean> searchResultsTranslations(List<BriefBean> beans, String targetLanguage, String authToken) throws eu.europeana.api.translation.service.exception.TranslationException {
        long start = System.currentTimeMillis();
        ArrayList textsToTranslate = new ArrayList();
        int index = 0;
        for (BriefBean bean : beans) {
            LOG.debug("Check search result {}...", (Object)index);
            int finalIndex = index;
            String chosenLanguage = this.metadataChosenLanguageService.getMostRepresentativeLanguage((IdBean)bean, targetLanguage, true);
            LOG.debug("Most representative language chosen for {} search result is  {}", (Object)index, (Object)chosenLanguage);
            if (chosenLanguage == null || StringUtils.equals((CharSequence)chosenLanguage, (CharSequence)targetLanguage)) {
                LOG.debug("Stop the translation workflow for search result {} ...", (Object)index);
            } else {
                TranslationMap gatheredTextForTranslation = new TranslationMap(chosenLanguage);
                ReflectionUtils.doWithFields((Class)bean.getClass(), field -> this.getSearchValueToTranslateForField(bean, field, chosenLanguage, targetLanguage, gatheredTextForTranslation, finalIndex), (ReflectionUtils.FieldFilter)BaseService.searchFieldFilter);
                this.addGatheredTranslations(gatheredTextForTranslation, textsToTranslate, chosenLanguage);
            }
            ++index;
        }
        if (textsToTranslate.isEmpty()) {
            LOG.debug("No values gathered for translations. Stopping the translation workflow for search results");
            return beans;
        }
        if (LOG.isDebugEnabled()) {
            textsToTranslate.stream().forEach(value -> LOG.debug("Text to translate - {} : {}", (Object)value.getSourceLanguage(), value));
        }
        TranslationMap translations = new TranslationMap(targetLanguage);
        for (TranslationMap map : textsToTranslate) {
            TranslationMap translation = this.translate(map, targetLanguage, authToken);
            if (translation.isEmpty()) continue;
            translations.add((Map)translation);
        }
        if (translations.isEmpty()) {
            LOG.debug("Empty or null translation returned by the Translation API Client");
            return beans;
        }
        translations.entrySet().stream().forEach(value -> {
            String[] parts = ((String)value.getKey()).split("\\.");
            int i = Integer.parseInt(parts[0]);
            String fieldName = parts[1];
            LOG.trace("Updating {} index result for field {} ...", (Object)i, (Object)fieldName);
            this.addTranslationToObject(beans.get(i), fieldName, (List)value.getValue(), translations.getSourceLanguage());
        });
        LOG.debug("Translating search results took {} ms", (Object)(System.currentTimeMillis() - start));
        return beans;
    }

    private void addGatheredTranslations(TranslationMap gatheredTextForTranslation, List<TranslationMap> textsToTranslate, String chosenLanguage) {
        if (!gatheredTextForTranslation.isEmpty()) {
            Optional<TranslationMap> existingTranslationMapForChosenLang = textsToTranslate.stream().filter(v -> StringUtils.equals((CharSequence)v.getSourceLanguage(), (CharSequence)chosenLanguage)).findFirst();
            if (existingTranslationMapForChosenLang.isPresent()) {
                existingTranslationMapForChosenLang.get().add((Map)gatheredTextForTranslation);
            } else {
                textsToTranslate.add(gatheredTextForTranslation);
            }
        }
    }

    public FullBean proxyTranslation(FullBean bean, String targetLanguage, String authToken) throws TranslationException, eu.europeana.api.translation.service.exception.TranslationException {
        TranslationMap translations;
        long start = System.currentTimeMillis();
        ArrayList proxies = new ArrayList(bean.getProxies());
        String chosenLanguage = this.metadataChosenLanguageService.getMostRepresentativeLanguage((IdBean)bean, targetLanguage, false);
        LOG.debug("Most representative language chosen for translations is  {}", (Object)chosenLanguage);
        if (chosenLanguage == null || StringUtils.equals((CharSequence)chosenLanguage, (CharSequence)targetLanguage)) {
            LOG.debug("Stop the translation workflow for record {}", (Object)bean.getAbout());
            return bean;
        }
        TranslationMap textToTranslate = new TranslationMap(chosenLanguage);
        TranslationMap prefLabelsAcrossProxyInSourceLang = new TranslationMap(targetLanguage);
        HashSet otherProxyFieldsWithTargetValues = new HashSet();
        for (Proxy proxy : proxies) {
            ReflectionUtils.doWithFields((Class)proxy.getClass(), field -> this.getProxyValuesToTranslateForField(proxy, field, chosenLanguage, targetLanguage, bean, textToTranslate, otherProxyFieldsWithTargetValues, prefLabelsAcrossProxyInSourceLang), (ReflectionUtils.FieldFilter)BaseService.proxyFieldFilter);
        }
        otherProxyFieldsWithTargetValues.stream().forEach(field -> {
            if (textToTranslate.containsKey(field)) {
                textToTranslate.remove(field);
            }
        });
        if (!prefLabelsAcrossProxyInSourceLang.isEmpty()) {
            TranslationUtils.optimisation((TranslationMap)prefLabelsAcrossProxyInSourceLang, (TranslationMap)textToTranslate);
        }
        if (textToTranslate.isEmpty()) {
            LOG.debug("No values gathered for translations. Stopping the translation workflow for record {}", (Object)bean.getAbout());
            return bean;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Text to translate - {}", (Object)textToTranslate);
        }
        if ((translations = this.translate(textToTranslate, targetLanguage, authToken)).isEmpty()) {
            LOG.debug("Empty or null translation returned by the Translation API Client");
            return bean;
        }
        Proxy europeanaProxy = BaseService.getEuropeanaProxy((List)bean.getProxies(), (String)bean.getAbout());
        translations.entrySet().stream().forEach(value -> this.addTranslationToObject((Object)europeanaProxy, (String)value.getKey(), (List)value.getValue(), translations.getSourceLanguage()));
        LOG.debug("Translating record {} took {} ms", (Object)bean.getAbout(), (Object)(System.currentTimeMillis() - start));
        return bean;
    }

    private void getProxyValuesToTranslateForField(Proxy proxy, Field field, String sourceLang, String targetLang, FullBean bean, TranslationMap map, Set<String> otherProxyFieldsWithTargetValues, TranslationMap prefLabelsAcrossProxyInTargetLang) {
        HashMap origFieldData = (HashMap)BaseService.getValueOfTheField((Object)proxy, (boolean)false).apply(field.getName());
        this.getValueFromLanguageMap((HashMap)SerializationUtils.clone((Serializable)origFieldData), field, sourceLang, targetLang, bean, map, otherProxyFieldsWithTargetValues, prefLabelsAcrossProxyInTargetLang);
    }

    public void getValueFromLanguageMap(HashMap<String, List<String>> origFieldData, Field field, String sourceLang, String targetLang, FullBean bean, TranslationMap map, Set<String> otherProxyFieldsWithTargetValues, TranslationMap prefLabelsAcrossProxyInTargetLang) {
        List valuesToTranslateForField;
        if (TranslationUtils.ifValuesShouldBePickedForTranslation(origFieldData, (String)sourceLang, (String)targetLang) && !(valuesToTranslateForField = TranslationUtils.getValuesToTranslate(origFieldData, (String)sourceLang, (String)targetLang, (FullBean)bean, (boolean)false, (Integer)this.translationCharLimit, (Integer)this.translationCharTolerance)).isEmpty()) {
            map.add(field.getName(), valuesToTranslateForField);
        }
        if (origFieldData != null && !origFieldData.isEmpty() && origFieldData.containsKey(targetLang)) {
            otherProxyFieldsWithTargetValues.add(field.getName());
        }
        TranslationUtils.getPrefLabelsAcrossProxyInSourceLang((FullBean)bean, (Field)field, origFieldData, (String)sourceLang, (String)targetLang, (TranslationMap)prefLabelsAcrossProxyInTargetLang);
    }

    private void getSearchValueToTranslateForField(BriefBean bean, Field field, String sourceLang, String targetLang, TranslationMap map, int index) {
        List valuesToTranslateForField;
        HashMap origFieldData = (HashMap)BaseService.getValueOfTheField((Object)bean, (boolean)false).apply(field.getName());
        Map fieldData = EdmUtils.cloneMap((Map)origFieldData);
        if (TranslationUtils.ifValuesShouldBePickedForTranslation((Map)fieldData, (String)sourceLang, (String)targetLang) && !(valuesToTranslateForField = TranslationUtils.getValuesToTranslate((Map)fieldData, (String)sourceLang, (String)targetLang, null, (boolean)true, (Integer)this.translationCharLimit, (Integer)this.translationCharTolerance)).isEmpty()) {
            map.add(index + "." + field.getName(), valuesToTranslateForField);
        }
    }

    private void addTranslationToObject(Object object, String fieldName, List<String> translatedValues, String targetLanguage) {
        Map existingMap = (Map)BaseService.getValueOfTheField((Object)object, (boolean)true).apply(fieldName);
        if (!translatedValues.isEmpty()) {
            List targetLangValues = existingMap.getOrDefault(targetLanguage, new ArrayList());
            targetLangValues.addAll(ComparatorUtils.removeDuplicates(translatedValues));
            existingMap.compute(targetLanguage, (key, val) -> targetLangValues);
        }
    }

    private TranslationMap translate(TranslationMap map, String targetLanguage, String authToken) throws eu.europeana.api.translation.service.exception.TranslationException {
        LinkedHashMap textsPerField = new LinkedHashMap();
        ArrayList textsToTranslate = new ArrayList();
        this.addTextsAndPerFieldCount(map, textsToTranslate, textsPerField);
        LOG.debug("Sending translate request with target language - {} and source language - {}", (Object)targetLanguage, (Object)map.getSourceLanguage());
        this.getTranslationApiClient().setAuthToken(authToken);
        List translationObjs = TranslationUtils.createTranslationRequest(textsToTranslate, (String)targetLanguage, (String)map.getSourceLanguage());
        this.getTranslationApiClient().getTranslationService().translate(translationObjs);
        List translations = this.getResults(translationObjs);
        if (translations.size() != textsToTranslate.size()) {
            throw new IllegalStateException("Expected " + textsToTranslate.size() + " lines of translated text, but received " + translations.size());
        }
        TranslationMap translatedMap = new TranslationMap(targetLanguage);
        if (LanguageDetectionUtils.onlyNulls((List)translations)) {
            return translatedMap;
        }
        int fromIndex = 0;
        for (Map.Entry entry : textsPerField.entrySet()) {
            int toIndex = fromIndex + (Integer)entry.getValue();
            ArrayList values = new ArrayList();
            values.addAll(translations.subList(fromIndex, toIndex));
            translatedMap.add((String)entry.getKey(), this.getTranslationsToAdd(values));
            fromIndex += ((Integer)entry.getValue()).intValue();
        }
        return translatedMap;
    }

    private void addTextsAndPerFieldCount(TranslationMap map, List<String> textsToTranslate, Map<String, Integer> textsPerField) {
        for (Map.Entry entry : map.entrySet()) {
            textsToTranslate.addAll((Collection)entry.getValue());
            textsPerField.put((String)entry.getKey(), ((List)entry.getValue()).size());
        }
    }

    private List<String> getTranslationsToAdd(List<String> translationsForField) {
        translationsForField.removeIf(Objects::isNull);
        ComparatorUtils.removeDuplicates(translationsForField);
        return translationsForField;
    }

    private List<String> getResults(List<TranslationObj> translationObjs) {
        return translationObjs.stream().map(obj -> obj.getTranslation()).collect(Collectors.toList());
    }
}

