/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.model.translate;

import eu.europeana.api2.v2.model.translate.Query;
import eu.europeana.api2.v2.model.translate.QueryPart;
import eu.europeana.api2.v2.model.translate.QueryPartType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryParser {
    public static final String GROUP_TO_CAPTURE = "annotate";
    private static final String[][] ANNOTATIONS = new String[][]{{"\"(?<annotate>[^\"]*?[^\\\\])\"", QueryPartType.QUOTED.toString()}, {"\\[(?<annotate>[^\\[]*?[^\\\\])\\]", QueryPartType.NOTEXT.toString()}, {"\\{(?<annotate>[^\\{]*?[^\\\\])\\}", QueryPartType.NOTEXT.toString()}, {"[^\\-\\w](?<annotate>\\-)\\w+", QueryPartType.UNARY_OPERATOR.toString()}, {"(?<annotate>\\+\\b)", QueryPartType.UNARY_OPERATOR.toString()}, {"[^\\-\\w](?<annotate>NOT)[^\\-\\w]", QueryPartType.UNARY_OPERATOR.toString()}, {"(?<annotate>\\w+?\\s*\\:)", QueryPartType.UNARY_OPERATOR.toString()}, {"(?<annotate>(\\S*[\\~\\^\\*\\/\\?\\\\]\\S*)+)", QueryPartType.NOTEXT.toString()}, {"(?<annotate>\\&\\&|\\|\\|)", QueryPartType.BINARY_OPERATOR.toString()}, {"[^\\-\\w](?<annotate>AND)[^\\-\\w]", QueryPartType.BINARY_OPERATOR.toString()}, {"[^\\-\\w](?<annotate>OR)[^\\-\\w]", QueryPartType.BINARY_OPERATOR.toString()}, {"(?<annotate>\"|\\(|\\)|\\[|\\]|\\{|\\})", QueryPartType.DELIMITER_OPERATOR.toString()}};

    public Query parse(Query query) {
        List annotatedParts = this.annotate(query);
        return new Query(query.getText(), annotatedParts);
    }

    private List<QueryPart> annotate(Query query) {
        List annotatedParts = query.getQueryPartList();
        for (String[] ann : ANNOTATIONS) {
            String regex = ann[0];
            Pattern pattern = Pattern.compile(regex, 256);
            QueryPartType label = QueryPartType.valueOf((String)ann[1]);
            annotatedParts = this.annotateQueryParts(pattern, label, annotatedParts);
        }
        return annotatedParts;
    }

    private List<QueryPart> annotateQueryParts(Pattern pattern, QueryPartType label, List<QueryPart> queryPartList) {
        ArrayList<QueryPart> newList = new ArrayList<QueryPart>();
        for (QueryPart part : queryPartList) {
            if (part.getPartType() == QueryPartType.TEXT) {
                newList.addAll(this.annotate(part, pattern, label));
                continue;
            }
            newList.add(part);
        }
        return newList;
    }

    public List<QueryPart> annotate(QueryPart queryPart, Pattern pattern, QueryPartType partType) {
        int bIndex = queryPart.getBeginIndex();
        ArrayList<QueryPart> queryParts = new ArrayList<QueryPart>();
        String text = queryPart.getText();
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int startGroup = matcher.start(GROUP_TO_CAPTURE);
            int endGroup = matcher.end(GROUP_TO_CAPTURE);
            queryParts.add(new QueryPart(bIndex, startGroup + queryPart.getBeginIndex(), queryPart.getPartType(), queryPart.getQuery()));
            queryParts.add(new QueryPart(startGroup + queryPart.getBeginIndex(), endGroup + queryPart.getBeginIndex(), partType, queryPart.getQuery()));
            bIndex = endGroup + queryPart.getBeginIndex();
        }
        if (bIndex < queryPart.getEndIndex()) {
            queryParts.add(new QueryPart(bIndex, queryPart.getEndIndex(), queryPart.getPartType(), queryPart.getQuery()));
        }
        return queryParts;
    }
}

