/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api.search.syntax.field.FieldDeclaration;
import eu.europeana.api.search.syntax.field.FieldMode;
import eu.europeana.api.search.syntax.field.FieldRegistry;
import eu.europeana.api.search.syntax.field.FieldType;
import eu.europeana.api2.v2.exceptions.DateMathParseException;
import eu.europeana.api2.v2.exceptions.InvalidParamValueException;
import eu.europeana.api2.v2.exceptions.InvalidRangeOrGapException;
import eu.europeana.api2.v2.exceptions.MissingParamException;
import eu.europeana.api2.v2.model.NumericFacetParameter;
import eu.europeana.api2.v2.utils.DateMathParser;
import eu.europeana.corelib.definitions.solr.RangeFacetType;
import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacetParameterUtils {
    private static final String DEFAULT_LIMIT_KEY = "f.DEFAULT.facet.limit";
    private static final String DEFAULT_OFFSET_KEY = "f.DEFAULT.facet.offset";
    private static final int LIMIT_FOR_DATA_PROVIDER = 50;
    private static final int LIMIT_FOR_DEFAULT = 50;
    private static final int LIMIT_FOR_CUSTOM = 50;
    private static final int LIMIT_FOR_TECH_DEFAULT = 50;
    private static final int LIMIT_FOR_TECH_CUSTOM = 50;
    private static final String FACET_RANGE = "facet.range";
    private static final String FACET_RANGE_START = "facet.range.start";
    private static final String FACET_RANGE_END = "facet.range.end";
    private static final String FACET_RANGE_GAP = "facet.range.gap";
    private static final String FACET_MINCOUNT = "facet.mincount";
    private static final String DEFAULT_START = "0001-01-01T00:00:00Z";
    private static final String NOW = "now";
    private static final String DEFAULT_GAP = "+1YEAR";
    private static final long MAX_RANGE_FACETS = 30000L;
    public static final String NEGATIVE_SIGN = "-";
    public static final String DATE_FIELD_FACET_REGEX = "^facet\\.([a-z,A-Z]*)\\.(gap|start|end)$";
    private static List<String> defaultSolrFacetList;
    private static List<String> rangeFacetList;
    private static List<String> rangeSpecifiers;
    private static DateFormat solrDateFormat;
    private static Map<String, String> dateTimeSpecifiersMap;

    public static Map<String, Integer> getSolrFacetParams(String type, String[] solrFacets, Map<String, String[]> parameters, boolean defaultFacetsRequested) {
        HashMap<String, Integer> solrFacetParams = new HashMap<String, Integer>();
        if (defaultFacetsRequested) {
            for (SolrFacetType solrFacetType : SolrFacetType.values()) {
                FacetParameterUtils.saveNumericFacetParam((String)type, (String)solrFacetType.name(), parameters, (boolean)true, (boolean)false, solrFacetParams);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])solrFacets)) {
            for (String string : solrFacets) {
                if (defaultFacetsRequested && defaultSolrFacetList.contains(string)) continue;
                FacetParameterUtils.saveNumericFacetParam((String)type, (String)string, parameters, (boolean)defaultSolrFacetList.contains(string), (boolean)false, solrFacetParams);
            }
        }
        return solrFacetParams;
    }

    public static Map<String, Integer> getTechnicalFacetParams(String type, String[] technicalFacets, Map<String, String[]> parameters, boolean defaultFacetsRequested) {
        HashMap<String, Integer> technicalFacetParams;
        block3: {
            block2: {
                technicalFacetParams = new HashMap<String, Integer>();
                if (!defaultFacetsRequested) break block2;
                for (TechnicalFacetType technicalFacet : TechnicalFacetType.values()) {
                    FacetParameterUtils.saveNumericFacetParam((String)type, (String)technicalFacet.name(), parameters, (boolean)true, (boolean)true, technicalFacetParams);
                }
                break block3;
            }
            if (!ArrayUtils.isNotEmpty((Object[])technicalFacets)) break block3;
            for (String technicalFacetName : technicalFacets) {
                FacetParameterUtils.saveNumericFacetParam((String)type, (String)technicalFacetName, parameters, (boolean)false, (boolean)true, technicalFacetParams);
            }
        }
        return technicalFacetParams;
    }

    public static Map<String, String> getFacetRangeParamsForDateSearch(Map<String, String[]> parameters) throws DateMathParseException, DataFormatException, MissingParamException, InvalidParamValueException {
        HashMap<String, String> dateRangeParams = new HashMap<String, String>();
        HashSet fieldsForFaceting = new HashSet();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String paramName = entry.getKey();
            String[] paramValue = entry.getValue();
            Matcher matcher = Pattern.compile("^facet\\.([a-z,A-Z]*)\\.(gap|start|end)$").matcher(paramName);
            if (!matcher.matches()) continue;
            FacetParameterUtils.generateDateSearchParamNameAndUpdateValue((String)paramName, fieldsForFaceting, dateRangeParams, (String[])paramValue);
        }
        FacetParameterUtils.validateAndUpdateDateFacetingParams(fieldsForFaceting, dateRangeParams);
        return dateRangeParams;
    }

    private static void generateDateSearchParamNameAndUpdateValue(String paramName, HashSet<String> fieldsForFaceting, Map<String, String> dateRangeParams, String[] paramValue) {
        String facetingField;
        String[] splitParamName = paramName.split("\\.");
        String rangeSpecifier = splitParamName[2];
        FieldDeclaration field = FieldRegistry.INSTANCE.getField(splitParamName[1]);
        if (field != null && rangeSpecifiers.contains(rangeSpecifier) && FieldType.DATE.equals((Object)field.getType()) && (facetingField = field.getField(FieldMode.FACET)) != null) {
            fieldsForFaceting.add(facetingField);
            String newKey = "f." + facetingField + ".facet.range." + rangeSpecifier;
            dateRangeParams.put(newKey, paramValue[0]);
        }
    }

    private static void validateAndUpdateDateFacetingParams(HashSet<String> fieldsForFaceting, Map<String, String> dateRangeParams) throws MissingParamException, DateMathParseException, InvalidParamValueException, DataFormatException {
        for (String field : fieldsForFaceting) {
            String startDate = dateRangeParams.get("f." + field + ".facet.range.start");
            Object gap = dateRangeParams.get("f." + field + ".facet.range.gap");
            String endDate = dateRangeParams.get("f." + field + ".facet.range.end");
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)gap)) {
                if (StringUtils.isBlank((CharSequence)endDate)) {
                    endDate = "now";
                }
                startDate = FacetParameterUtils.convertDateInSolrFormat((String)startDate);
                endDate = FacetParameterUtils.convertDateInSolrFormat((String)endDate);
                if (!((String)gap).startsWith("+")) {
                    gap = "+" + (String)gap;
                }
                if (((String)gap).startsWith("-")) {
                    throw new InvalidParamValueException("Negative facet gaps are not allowed!");
                }
            } else {
                throw new MissingParamException(String.format("Parameter facet.%s.start  and facet.%s.gap are mandatory for date search with facets.", field, field));
            }
            String gapValue = StringUtils.chop((String)gap);
            String gapValueUnit = (String)dateTimeSpecifiersMap.get(((String)gap).substring(((String)gap).length() - 1));
            gap = gapValue + gapValueUnit;
            endDate = FacetParameterUtils.adjustEndDateForFaceting((String)endDate, (String)gapValue, (String)gapValueUnit);
            FacetParameterUtils.compareDatesForFaceting((String)startDate, (String)endDate, (String)gapValue, (String)gapValueUnit);
            dateRangeParams.put("f." + field + ".facet.range.start", startDate);
            dateRangeParams.put("f." + field + ".facet.range.end", endDate);
            dateRangeParams.put("f." + field + ".facet.range.gap", (String)gap);
            String facetRange = dateRangeParams.get("facet.range");
            if (StringUtils.isNotBlank((CharSequence)facetRange) && !facetRange.contains(field)) {
                dateRangeParams.put("facet.range", facetRange + "," + field);
                continue;
            }
            dateRangeParams.put("facet.range", field);
        }
    }

    private static void compareDatesForFaceting(String startDate, String endDate, String gapValue, String gapUnit) throws DateMathParseException, InvalidParamValueException {
        Date startDateVal = FacetParameterUtils.parseDate((String)startDate);
        LocalDateTime startDateTime = LocalDateTime.ofInstant(startDateVal.toInstant(), ZoneOffset.UTC);
        Date endDateVal = FacetParameterUtils.parseDate((String)endDate);
        LocalDateTime endDateTime = LocalDateTime.ofInstant(endDateVal.toInstant(), ZoneOffset.UTC);
        if (startDateVal.compareTo(endDateVal) > 0) {
            throw new InvalidParamValueException("Facet start date can not be later than end date !");
        }
        FacetParameterUtils.validateDateAgainstGapValues((String)gapValue, (String)gapUnit, (LocalDateTime)startDateTime, (LocalDateTime)endDateTime);
    }

    private static void validateDateAgainstGapValues(String gapValue, String gapUnit, LocalDateTime startDateTime, LocalDateTime endDateTime) throws InvalidParamValueException {
        long gapInMillis;
        Date currentDate = new Date();
        Date gap = FacetParameterUtils.getDateBasedOnGapDuration((String)gapValue, (String)gapUnit, (Date)currentDate);
        long timespanInMillis = Duration.between(startDateTime, endDateTime).toMillis();
        if (timespanInMillis < (gapInMillis = Duration.between(LocalDateTime.ofInstant(currentDate.toInstant(), ZoneOffset.UTC), LocalDateTime.ofInstant(gap.toInstant(), ZoneOffset.UTC)).toMillis())) {
            throw new InvalidParamValueException("Incorrect gap value :  should not be more than the gap between start and end date!");
        }
        if ((timespanInMillis + 1L) / gapInMillis > 30000L) {
            throw new InvalidParamValueException("Incorrect gap value : should not be more than maximum allowed number of gaps");
        }
    }

    private static Date parseDate(String dateVal) throws DateMathParseException {
        try {
            return solrDateFormat.parse(dateVal);
        }
        catch (ParseException e) {
            throw new DateMathParseException((Throwable)e, dateVal, "startDate");
        }
    }

    private static String adjustEndDateForFaceting(String end, String gapVal, String gapValUnit) throws DateMathParseException {
        try {
            if (end.startsWith("-")) {
                end = end.substring(1);
            }
            Date date = solrDateFormat.parse(end);
            return solrDateFormat.format(FacetParameterUtils.getDateBasedOnGapDuration((String)gapVal, (String)gapValUnit, (Date)date));
        }
        catch (ParseException e) {
            throw new DateMathParseException((Throwable)e, end, end);
        }
    }

    private static Date getDateBasedOnGapDuration(String gapVal, String gapValUnit, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int gapValueForEndDateAdjustment = Integer.parseInt(gapVal);
        if ("YEAR".equals(gapValUnit)) {
            calendar.add(1, gapValueForEndDateAdjustment);
        }
        if ("MONTHS".equals(gapValUnit)) {
            calendar.add(2, gapValueForEndDateAdjustment);
        }
        if ("DAYS".equals(gapValUnit)) {
            calendar.add(5, gapValueForEndDateAdjustment);
        }
        if ("HOURS".equals(gapValUnit)) {
            calendar.add(11, gapValueForEndDateAdjustment);
        }
        if ("MINUTES".equals(gapValUnit)) {
            calendar.add(12, gapValueForEndDateAdjustment);
        }
        if ("SECONDS".equals(gapValUnit)) {
            calendar.add(13, gapValueForEndDateAdjustment);
        }
        return calendar.getTime();
    }

    public static String convertDateInSolrFormat(String val) throws DataFormatException {
        if ("now".equalsIgnoreCase(val)) {
            return FacetParameterUtils.thisVeryMoment();
        }
        Pattern pattern = Pattern.compile("^(-)?\\d{4}(-\\d{2}(-d{2})?)?$");
        Matcher matcher = pattern.matcher(val);
        if (!matcher.matches()) {
            throw new DataFormatException("Invalid date value " + val + "! should be in format YYYY-MM-dd or YYYY-MM  or YYYY");
        }
        String formatedDate = "";
        if (val.startsWith("-")) {
            val = val.substring(1);
            formatedDate = "-";
        }
        return formatedDate + FacetParameterUtils.getDateInSolrFormat((String)val);
    }

    @NotNull
    private static String getDateInSolrFormat(String val) {
        Calendar cal = Calendar.getInstance();
        String[] tokenizedDate = val.split("-");
        int year = 1;
        int month = 0;
        int day = 1;
        if (tokenizedDate.length >= 1) {
            year = Integer.parseInt(tokenizedDate[0]);
        }
        if (tokenizedDate.length >= 2) {
            month = Integer.parseInt(tokenizedDate[1]);
        }
        if (tokenizedDate.length == 3) {
            day = Integer.parseInt(tokenizedDate[2]);
        }
        cal.set(year, month, day, 0, 0, 0);
        return solrDateFormat.format(cal.getTime());
    }

    public static Map<String, String> getDateRangeParams(Map<String, String[]> parameters) throws DateMathParseException, InvalidRangeOrGapException, DataFormatException, MissingParamException, InvalidParamValueException {
        HashMap<String, String> dateRangeParams = new HashMap<String, String>();
        List facetsToRange = FacetParameterUtils.retrieveRangeFacetList(parameters, (String)"facet.range");
        StringBuilder facetRangeValue = new StringBuilder();
        for (String facetToRange : facetsToRange) {
            facetRangeValue.append(facetToRange);
            facetRangeValue.append(",");
        }
        if (!facetsToRange.isEmpty()) {
            dateRangeParams.put("facet.range", StringUtils.chop((String)facetRangeValue.toString()));
        }
        for (String facetToRange : facetsToRange) {
            for (String rangeSpecifier : rangeSpecifiers) {
                String globalSpecifier = "facet.range." + rangeSpecifier;
                String fieldSpecifier = "f." + facetToRange + ".facet.range." + rangeSpecifier;
                if (parameters.containsKey(globalSpecifier)) {
                    dateRangeParams.put(fieldSpecifier, FacetParameterUtils.plusificate((String)parameters.get(globalSpecifier)[0], (String)rangeSpecifier));
                    continue;
                }
                if (parameters.containsKey(fieldSpecifier)) {
                    dateRangeParams.put(fieldSpecifier, FacetParameterUtils.plusificate((String)parameters.get(fieldSpecifier)[0], (String)rangeSpecifier));
                    continue;
                }
                dateRangeParams.put(fieldSpecifier, FacetParameterUtils.getDefaultValue((String)rangeSpecifier));
            }
            DateMathParser.exceedsMaxNrOfGaps((String)((String)dateRangeParams.get("f." + facetToRange + ".facet.range.start")), (String)((String)dateRangeParams.get("f." + facetToRange + ".facet.range.end")), (String)((String)dateRangeParams.get("f." + facetToRange + ".facet.range.gap")), (long)30000L);
        }
        return dateRangeParams;
    }

    public static Map<String, String> getDateRangeParamsV3(Map<String, String[]> parameters) throws DataFormatException, InvalidParamValueException, DateMathParseException, InvalidRangeOrGapException, MissingParamException {
        Map dateRangeParams = FacetParameterUtils.getDateRangeParams(parameters);
        FacetParameterUtils.getFacetRangeParamsForDateSearch(parameters).forEach(dateRangeParams::putIfAbsent);
        return dateRangeParams;
    }

    private static String getDefaultValue(String rangeSpecifier) {
        return switch (rangeSpecifier) {
            case "start" -> "0001-01-01T00:00:00Z";
            case "end" -> FacetParameterUtils.thisVeryMoment();
            case "gap" -> "+1YEAR";
            default -> "";
        };
    }

    private static String plusificate(String plusMinusNow, String rangeSpecifier) {
        if (StringUtils.equalsIgnoreCase((CharSequence)rangeSpecifier, (CharSequence)"gap") && !StringUtils.startsWithAny((CharSequence)plusMinusNow, (CharSequence[])new CharSequence[]{"+", "-"})) {
            return "+" + plusMinusNow;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"now", (CharSequence)plusMinusNow)) {
            return FacetParameterUtils.thisVeryMoment();
        }
        return plusMinusNow;
    }

    private static String thisVeryMoment() {
        return solrDateFormat.format(new Date());
    }

    private static List<String> retrieveRangeFacetList(Map<String, String[]> parameters, String pattern) {
        ArrayList facetsToRangeTemp = new ArrayList();
        ArrayList<String> facetsToRange = new ArrayList<String>();
        if (parameters.containsKey(pattern)) {
            Collections.addAll(facetsToRangeTemp, StringUtils.stripAll((String[])StringUtils.split((String)parameters.get(pattern)[0], (char)',')));
            for (String facetToRangeTemp : facetsToRangeTemp) {
                if (!rangeFacetList.contains(facetToRangeTemp)) continue;
                facetsToRange.add(facetToRangeTemp);
            }
        }
        return facetsToRange;
    }

    private static void saveNumericFacetParam(String type, String name, Map<String, String[]> parameters, boolean isDefault, boolean isTech, Map<String, Integer> facetParams) {
        NumericFacetParameter parameter = null;
        if (type.equals("limit")) {
            parameter = FacetParameterUtils.getFacetLimit((String)name, parameters, (boolean)isDefault, (boolean)isTech);
        } else if (type.equals("offset")) {
            parameter = FacetParameterUtils.getFacetOffset((String)name, parameters, (boolean)isDefault);
        }
        if (parameter != null) {
            facetParams.put(parameter.getName(), parameter.getValue());
        }
    }

    private static NumericFacetParameter getFacetLimit(String facet, Map<String, String[]> parameters, boolean isDefault, boolean isTech) {
        Integer defaultLimit;
        String key = "f." + facet + ".facet.limit";
        if (isTech) {
            defaultLimit = isDefault ? 50 : 50;
        } else {
            int dataProvider = StringUtils.equals((CharSequence)facet, (CharSequence)"DATA_PROVIDER") ? 50 : 50;
            defaultLimit = isDefault ? dataProvider : 50;
        }
        return FacetParameterUtils.extractNumericParameter((String)key, (String)"f.DEFAULT.facet.limit", parameters, (boolean)isDefault, (Integer)defaultLimit);
    }

    private static NumericFacetParameter getFacetOffset(String facet, Map<String, String[]> parameters, boolean isDefault) {
        String key = "f." + facet + ".facet.offset";
        return FacetParameterUtils.extractNumericParameter((String)key, (String)"f.DEFAULT.facet.offset", parameters, (boolean)isDefault, null);
    }

    private static NumericFacetParameter extractNumericParameter(String key, String defaultKey, Map<String, String[]> parameters, boolean isDefault, Integer defaultValue) {
        if (parameters.containsKey(key)) {
            String[] value = parameters.get(key);
            return new NumericFacetParameter(key, value[0]);
        }
        if (isDefault && parameters.containsKey(defaultKey)) {
            String[] value = parameters.get(defaultKey);
            return new NumericFacetParameter(key, value[0]);
        }
        if (defaultValue != null) {
            return new NumericFacetParameter(key, defaultValue);
        }
        return null;
    }

    public static String getLimitForDataProvider() {
        return String.valueOf(50);
    }

    static {
        rangeSpecifiers = Arrays.asList("start", "end", "gap");
        solrDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        defaultSolrFacetList = new ArrayList();
        for (SolrFacetType solrFacetType : SolrFacetType.values()) {
            defaultSolrFacetList.add(solrFacetType.toString());
        }
        rangeFacetList = new ArrayList();
        for (SolrFacetType solrFacetType : RangeFacetType.values()) {
            rangeFacetList.add(solrFacetType.toString());
        }
        dateTimeSpecifiersMap = new HashMap();
        dateTimeSpecifiersMap.put("Y", "YEAR");
        dateTimeSpecifiersMap.put("M", "MONTHS");
        dateTimeSpecifiersMap.put("d", "DAYS");
        dateTimeSpecifiersMap.put("H", "HOURS");
        dateTimeSpecifiersMap.put("m", "MINUTES");
        dateTimeSpecifiersMap.put("s", "SECONDS");
    }
}

