/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api.translation.definitions.language.Language;
import eu.europeana.api2.v2.service.translate.BaseService;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.EuropeanaAggregation;
import eu.europeana.corelib.solr.entity.ProxyImpl;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LanguageFilter {
    private static final Logger LOG = LogManager.getLogger(LanguageFilter.class);

    private LanguageFilter() {
    }

    public static IdBean filter(IdBean bean, List<Language> targetLangs) {
        long startTime = System.currentTimeMillis();
        TreeSet proxyFieldsWithTargetLang = new TreeSet();
        LanguageFilter.iterativeFilterFields((Object)bean, targetLangs, proxyFieldsWithTargetLang);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering language data took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        proxyFieldsWithTargetLang.clear();
        return bean;
    }

    private static void iterativeFilterFields(Object o, List<Language> targetLangs, Set<String> proxyFieldsWithTargetLang) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting object {}", (Object)o.getClass().getName());
        }
        ReflectionUtils.FieldFilter fieldFilter = LanguageFilter.getFieldFilter();
        ReflectionUtils.doWithFields(o.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = field.get(o);
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Field {} has class {}", (Object)field.getName(), fieldValue == null ? null : fieldValue.getClass());
            }
            if (fieldValue instanceof Map) {
                LanguageFilter.filterLanguageMap((String)field.getName(), (Map)((Map)fieldValue), (List)targetLangs, (boolean)LanguageFilter.filterOnlyTargetLanguage((Object)o, (Set)proxyFieldsWithTargetLang, (String)field.getName()));
                if (o.getClass().isAssignableFrom(ProxyImpl.class) && LanguageFilter.ifFieldHasTargetLangValue((Map)((Map)fieldValue), (List)targetLangs)) {
                    proxyFieldsWithTargetLang.add(field.getName());
                }
            } else if (fieldValue instanceof List) {
                for (Object item : (List)fieldValue) {
                    LanguageFilter.iterativeFilterFields(item, (List)targetLangs, (Set)proxyFieldsWithTargetLang);
                }
            } else if (fieldValue instanceof EuropeanaAggregation) {
                LanguageFilter.iterativeFilterFields((Object)fieldValue, (List)targetLangs, (Set)proxyFieldsWithTargetLang);
            } else assert (fieldValue == null) : "Unknown field class " + fieldValue.getClass() + ". Checks do not match field filter";
        }, (ReflectionUtils.FieldFilter)fieldFilter);
    }

    @NotNull
    private static ReflectionUtils.FieldFilter getFieldFilter() {
        return field -> (field.getType().isAssignableFrom(Map.class) || field.getType().isAssignableFrom(List.class) || field.getType().isAssignableFrom(EuropeanaAggregation.class)) && !"fieldMap".equals(field.getName());
    }

    private static boolean filterOnlyTargetLanguage(Object o, Set<String> proxyFieldsWithTargetLang, String fieldName) {
        return o.getClass().isAssignableFrom(ProxyImpl.class) && proxyFieldsWithTargetLang.contains(fieldName);
    }

    private static boolean ifFieldHasTargetLangValue(Map<?, ?> map, List<Language> targetLangs) {
        Set<?> keyset = map.keySet();
        for (Language language : targetLangs) {
            if (!keyset.contains(language.name().toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    private static void filterLanguageMap(String fieldName, Map<?, ?> map, List<Language> targetLangs, boolean filterOnlyTargetLanguage) {
        LOG.debug("    Map {} has {} keys and {} values", (Object)fieldName, (Object)map.keySet().size(), (Object)map.values().size());
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<?, ?> keyValue : map.entrySet()) {
            String origKey = keyValue.getKey().toString();
            String keyLang = origKey.substring(origKey.indexOf(".") + 1);
            if (!(!filterOnlyTargetLanguage || Language.isSupported((String)keyLang) && targetLangs.contains(Language.getLanguage((String)keyLang)))) {
                LOG.debug("     Proxy field {} is already filtered for target lang. Removing key {}, value {}", (Object)fieldName, (Object)origKey, keyValue.getValue());
                keysToRemove.add(keyLang);
                continue;
            }
            if ("def".equals(keyLang) || EuropeanaUriUtils.isUri((String)origKey)) {
                LOG.debug("      Keeping key def, value {}", keyValue.getValue());
                continue;
            }
            if (Language.isNoLinguisticContent((String)keyLang) || Language.isSupported((String)keyLang) && targetLangs.contains(Language.getLanguage((String)keyLang))) {
                LOG.debug("      Keeping key {}, value {}", (Object)origKey, keyValue.getValue());
            } else {
                LOG.debug("      Removing key {}, value {}", (Object)origKey, keyValue.getValue());
                keysToRemove.add(origKey);
            }
            if (map.keySet().size() != keysToRemove.size()) continue;
            LOG.debug("Keys to remove {}. Return all lang-tagged values", (Object)keysToRemove.size());
            return;
        }
        keysToRemove.forEach(map::remove);
    }

    public static void removeNonLanguageAwareFields(IdBean bean) {
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = field.get(bean);
            if (fieldValue != null) {
                ReflectionUtils.setField((Field)field, (Object)bean, null);
            }
        }, (ReflectionUtils.FieldFilter)BaseService.searchFieldRemovalFilter);
    }
}

