/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api.translation.client.TranslationApiClient;
import eu.europeana.api.translation.definitions.language.Language;
import eu.europeana.api.translation.definitions.model.LanguageDetectionObj;
import eu.europeana.api.translation.service.exception.LanguageDetectionException;
import eu.europeana.api2.v2.exceptions.TranslationException;
import eu.europeana.api2.v2.model.translate.LanguageValueFieldMap;
import eu.europeana.api2.v2.service.translate.BaseService;
import eu.europeana.api2.v2.service.translate.LanguageDetectionUtils;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.edm.utils.EdmUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class MetadataLangDetectionService
extends BaseService {
    private static final Logger LOG = LogManager.getLogger(MetadataLangDetectionService.class);

    public MetadataLangDetectionService(TranslationApiClient translationApiClient) {
        super(translationApiClient);
    }

    private <T extends IdBean> String getHintForLanguageDetect(T bean, boolean searchResults) {
        List edmLanguages = LanguageDetectionUtils.getEdmLanguage(bean, (boolean)searchResults);
        if (!edmLanguages.isEmpty()) {
            String edmLang = ((Language)edmLanguages.get(0)).name().toLowerCase(Locale.ROOT);
            if (this.getTranslationApiClient().getLanguageDetectionService().isSupported(edmLang)) {
                LOG.debug("For record {}, hint for lang-detection is {} ", (Object)(searchResults ? bean.getId() : ((FullBean)bean).getAbout()), (Object)edmLang);
                return edmLang;
            }
            LOG.debug("For record {}, edmLanguage - {} , is NOT supported by lang detection service", (Object)bean.getId(), (Object)edmLang);
        }
        return null;
    }

    public List<BriefBean> detectLanguageForSearchResults(List<BriefBean> briefBeans, String authToken) throws TranslationException, LanguageDetectionException {
        long start = System.currentTimeMillis();
        int index = 0;
        for (BriefBean bean : briefBeans) {
            LOG.debug("Check search result {}...", (Object)index);
            ArrayList langValueFieldMapForDetection = new ArrayList();
            ReflectionUtils.doWithFields(bean.getClass(), field -> {
                LanguageValueFieldMap fieldValuesLanguageMap = this.getLiteralsForSearchFields(bean, field);
                if (fieldValuesLanguageMap != null) {
                    langValueFieldMapForDetection.add(fieldValuesLanguageMap);
                }
            }, (ReflectionUtils.FieldFilter)BaseService.searchFieldFilter);
            if (!langValueFieldMapForDetection.isEmpty()) {
                String langHint = this.getHintForLanguageDetect((IdBean)bean, true);
                this.detectLanguageAndUpdate(langValueFieldMapForDetection, (IdBean)bean, langHint, true, start, authToken);
            }
            ++index;
        }
        return briefBeans;
    }

    public FullBean detectLanguageForProxy(FullBean bean, String authToken) throws TranslationException, LanguageDetectionException {
        long start = System.currentTimeMillis();
        ArrayList proxies = new ArrayList(bean.getProxies());
        if (proxies.size() < 2) {
            LOG.error("Unexpected data - expected at least 2 proxies, but found only {}!", (Object)proxies.size());
            return bean;
        }
        String langHint = this.getHintForLanguageDetect((IdBean)bean, false);
        Proxy europeanaProxy = BaseService.getEuropeanaProxy(proxies, (String)bean.getAbout());
        proxies.remove(europeanaProxy);
        for (Proxy proxy : proxies) {
            ArrayList langValueFieldMapForDetection = new ArrayList();
            ReflectionUtils.doWithFields(proxy.getClass(), field -> {
                LanguageValueFieldMap fieldValuesLanguageMap = this.getProxyFieldsValues(proxy, field, bean);
                if (fieldValuesLanguageMap != null) {
                    langValueFieldMapForDetection.add(fieldValuesLanguageMap);
                }
            }, (ReflectionUtils.FieldFilter)BaseService.proxyFieldFilter);
            if (langValueFieldMapForDetection.isEmpty()) continue;
            LOG.debug("For record {} gathered {} fields non-language tagged values for detection. ", (Object)bean.getAbout(), (Object)langValueFieldMapForDetection.size());
            this.detectLanguageAndUpdate(langValueFieldMapForDetection, (IdBean)bean, langHint, false, start, authToken);
        }
        return bean;
    }

    private <T extends IdBean> void detectLanguageAndUpdate(List<LanguageValueFieldMap> langValueFieldMapForDetection, T bean, String langHint, boolean searchResults, long start, String authToken) throws TranslationException, LanguageDetectionException {
        LinkedHashMap textsPerField = new LinkedHashMap();
        ArrayList textsForDetection = new ArrayList();
        LanguageDetectionUtils.getTextsForDetectionRequest(textsForDetection, textsPerField, langValueFieldMapForDetection);
        LOG.debug("Gathering detection values for record {} took {} ms ", (Object)(searchResults ? bean.getId() : ((FullBean)bean).getAbout()), (Object)(System.currentTimeMillis() - start));
        this.getTranslationApiClient().setAuthToken(authToken);
        List objs = this.createLanguageDetectionObj(textsForDetection, langHint);
        this.getTranslationApiClient().getLanguageDetectionService().detectLang(objs);
        List detectedLanguages = this.getResults(objs);
        LOG.debug("Detected languages - {} ", (Object)detectedLanguages);
        if (!LanguageDetectionUtils.onlyNulls((List)detectedLanguages)) {
            List correctLangValueMap = LanguageDetectionUtils.getLangDetectedFieldValueMap(textsPerField, (List)detectedLanguages, textsForDetection);
            if (searchResults) {
                this.updateObject(bean, correctLangValueMap);
            } else {
                Proxy europeanProxy = BaseService.getEuropeanaProxy((List)((FullBean)bean).getProxies(), (String)((FullBean)bean).getAbout());
                this.updateObject((Object)europeanProxy, correctLangValueMap);
            }
            LOG.debug("Language detection for {} took {} ms", (Object)(searchResults ? bean.getId() : ((FullBean)bean).getAbout()), (Object)(System.currentTimeMillis() - start));
        }
    }

    private LanguageValueFieldMap getProxyFieldsValues(Proxy proxy, Field field, FullBean bean) {
        HashMap origFieldData = (HashMap)BaseService.getValueOfTheField((Object)proxy, (boolean)false).apply(field.getName());
        return LanguageDetectionUtils.getValueFromLanguageMap((Map)((Map)((Object)SerializationUtils.clone((Serializable)origFieldData))), (String)field.getName(), (IdBean)bean, (boolean)false);
    }

    private LanguageValueFieldMap getLiteralsForSearchFields(BriefBean bean, Field field) {
        HashMap origFieldData = (HashMap)BaseService.getValueOfTheField((Object)bean, (boolean)false).apply(field.getName());
        Map fieldData = EdmUtils.cloneMap((Map)origFieldData);
        if (fieldData != null && !fieldData.isEmpty() && !LanguageDetectionUtils.mapHasOtherLanguagesThanDef(fieldData.keySet())) {
            return LanguageDetectionUtils.getValueFromLanguageMap((Map)fieldData, (String)field.getName(), (IdBean)bean, (boolean)true);
        }
        return null;
    }

    private List<LanguageDetectionObj> createLanguageDetectionObj(List<String> textsForDetection, String langHint) {
        ArrayList<LanguageDetectionObj> languageDetectionObjs = new ArrayList<LanguageDetectionObj>(textsForDetection.size());
        for (String text : textsForDetection) {
            LanguageDetectionObj obj = new LanguageDetectionObj();
            obj.setHint(langHint);
            obj.setText(text);
            languageDetectionObjs.add(obj);
        }
        return languageDetectionObjs;
    }

    private List<String> getResults(List<LanguageDetectionObj> languageDetectionObjs) {
        return languageDetectionObjs.stream().map(obj -> obj.getDetectedLang()).collect(Collectors.toList());
    }

    private void updateObject(Object object, List<LanguageValueFieldMap> correctLangMap) {
        correctLangMap.stream().forEach(value -> {
            Map map = (Map)BaseService.getValueOfTheField((Object)object, (boolean)true).apply(value.getFieldName());
            for (Map.Entry entry : value.entrySet()) {
                if (StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"def")) continue;
                if (map.containsKey(entry.getKey())) {
                    ((List)map.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                map.put((String)entry.getKey(), (List)entry.getValue());
            }
        });
    }
}

