/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import com.github.jsonldjava.utils.JsonUtils;
import eu.europeana.api.commons.utils.RiotRdfUtils;
import eu.europeana.api.commons.web.exception.HttpException;
import eu.europeana.api.translation.definitions.exceptions.InvalidLanguageException;
import eu.europeana.api.translation.definitions.language.Language;
import eu.europeana.api2.model.json.ApiError;
import eu.europeana.api2.v2.exceptions.InvalidAuthorizationException;
import eu.europeana.api2.v2.exceptions.InvalidConfigurationException;
import eu.europeana.api2.v2.exceptions.InvalidParamValueException;
import eu.europeana.api2.v2.exceptions.TranslationServiceDisabledException;
import eu.europeana.api2.v2.exceptions.TranslationServiceNotAvailableException;
import eu.europeana.api2.v2.model.RecordType;
import eu.europeana.api2.v2.model.enums.Profile;
import eu.europeana.api2.v2.model.json.ObjectResult;
import eu.europeana.api2.v2.model.json.view.FullView;
import eu.europeana.api2.v2.service.RouteDataService;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.utils.HttpCacheUtils;
import eu.europeana.api2.v2.utils.LanguageFilter;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.api2.v2.web.controller.BaseController;
import eu.europeana.api2.v2.web.controller.ObjectController;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.edm.utils.EdmUtils;
import eu.europeana.corelib.record.BaseUrlWrapper;
import eu.europeana.corelib.record.DataSourceWrapper;
import eu.europeana.corelib.record.RecordService;
import eu.europeana.corelib.record.schemaorg.utils.SchemaOrgUtils;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.exception.ProblemType;
import eu.europeana.corelib.web.utils.RequestUtils;
import eu.europeana.metis.mongo.dao.RecordDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.JsonLDWriteContext;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RDFWriterBuilder;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@Api(tags={"Record"})
@RequestMapping(value={"/api/v2/record", "/v2/record", "/record/v2", "/record"})
@SwaggerSelect
public class ObjectController
extends BaseController {
    private static final Logger LOG = LogManager.getLogger(ObjectController.class);
    private static final String MEDIA_TYPE_RDF_UTF8 = "application/rdf+xml; charset=UTF-8";
    private static final String MEDIA_TYPE_JSONLD_UTF8 = "application/ld+json; charset=UTF-8";
    private static final String MEDIA_TYPE_TURTLE_TEXT = "text/turtle";
    private static final String MEDIA_TYPE_TURTLE = "application/turtle";
    private static final String MEDIA_TYPE_TURTLE_X = "application/x-turtle";
    private static Object jsonldContext = new Object();
    private RecordService recordService;
    private TranslationService recordTranslations;
    private HttpCacheUtils httpCacheUtils;
    @Value(value="#{europeanaProperties['translation.record']}")
    private Boolean recordTranslationEnabled;

    @Autowired
    public ObjectController(RouteDataService routeService, RecordService recordService, @Nullable TranslationService recordTranslations, HttpCacheUtils httpCacheUtils) {
        super(routeService);
        this.recordService = recordService;
        this.httpCacheUtils = httpCacheUtils;
        this.recordTranslations = recordTranslations;
        if (this.recordTranslationEnabled == null) {
            this.recordTranslationEnabled = false;
        }
    }

    @ApiOperation(value="get a single record in JSON format", nickname="getSingleRecordJson")
    @GetMapping(value={"/{collectionId}/{recordId}.json"}, produces={"application/json;charset=UTF-8"})
    public ModelAndView record(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="callback", required=false) String callback, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException, HttpException {
        RequestData data = new RequestData(collectionId, recordId, profile, lang, callback, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_JSON, data, response);
    }

    @SwaggerIgnore
    @GetMapping(value={"/context.jsonld", "/context.json-ld"}, produces={"application/ld+json; charset=UTF-8", "application/json;charset=UTF-8"})
    public ModelAndView contextJSONLD(@RequestParam(value="callback", required=false) String callback) throws IOException {
        String jsonld = JsonUtils.toString((Object)jsonldContext);
        return eu.europeana.api2.utils.JsonUtils.toJson((String)jsonld, (String)callback);
    }

    @SwaggerIgnore
    @GetMapping(value={"/{collectionId}/{recordId}.json-ld"}, produces={"application/ld+json; charset=UTF-8", "application/json;charset=UTF-8"})
    public ModelAndView recordJSONLD2(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="callback", required=false) String callback, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException, HttpException {
        return this.recordJSONLD(collectionId, recordId, profile, lang, callback, request, response);
    }

    @ApiOperation(value="get single record in JSON LD format", nickname="getSingleRecordJsonLD")
    @GetMapping(value={"/{collectionId}/{recordId}.jsonld"}, produces={"application/ld+json; charset=UTF-8", "application/json;charset=UTF-8"})
    public ModelAndView recordJSONLD(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="callback", required=false) String callback, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException, HttpException {
        RequestData data = new RequestData(collectionId, recordId, profile, lang, callback, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_JSONLD, data, response);
    }

    @ApiOperation(value="get single record in Schema.org JSON LD format", nickname="getSingleRecordSchemaOrg")
    @GetMapping(value={"/{collectionId}/{recordId}.schema.jsonld"}, produces={"application/ld+json; charset=UTF-8", "application/json;charset=UTF-8"})
    public ModelAndView recordSchemaOrg(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="callback", required=false) String callback, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException, HttpException {
        RequestData data = new RequestData(collectionId, recordId, profile, lang, callback, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_SCHEMA_ORG, data, response);
    }

    @ApiOperation(value="get single record in RDF format)", nickname="getSingleRecordRDF")
    @GetMapping(value={"/{collectionId}/{recordId}.rdf"}, produces={"application/rdf+xml; charset=UTF-8"})
    public ModelAndView recordRdf(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="lang", required=false) String lang, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException, HttpException {
        RequestData data = new RequestData(collectionId, recordId, profile, lang, null, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_RDF, data, response);
    }

    @ApiOperation(value="get single record in turtle format)", nickname="getSingleRecordTurtle")
    @GetMapping(value={"/{collectionId}/{recordId}.ttl"}, produces={"application/turtle", "text/turtle", "application/x-turtle"})
    public ModelAndView recordTurtle(@PathVariable String collectionId, @PathVariable String recordId, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="lang", required=false) String lang, @ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response) throws EuropeanaException, HttpException {
        RequestData data = new RequestData(collectionId, recordId, profile, lang, null, request);
        return (ModelAndView)this.handleRecordRequest(RecordType.OBJECT_TURTLE, data, response);
    }

    private Object handleRecordRequest(RecordType recordType, RequestData data, HttpServletResponse response) throws EuropeanaException, HttpException {
        FullBean bean;
        long startTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving record with id {}, type = {}", (Object)data.europeanaId, (Object)recordType);
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"GET", (CharSequence)data.servletRequest.getMethod()) && !StringUtils.equalsIgnoreCase((CharSequence)"HEAD", (CharSequence)data.servletRequest.getMethod())) {
            response.setStatus(405);
            return null;
        }
        if (data.profiles.contains(Profile.TRANSLATE) && this.getAuthorizationHeader(data.servletRequest) == null) {
            throw new InvalidAuthorizationException();
        }
        data.wskey = ApiKeyUtils.extractApiKeyFromAuthorization((Authentication)this.verifyReadAccess(data.servletRequest));
        Optional dataSource = this.routeService.getRecordServerForRequest(data.servletRequest.getServerName());
        if (dataSource.isEmpty() || ((DataSourceWrapper)dataSource.get()).getRecordDao().isEmpty()) {
            LOG.error("Error while retrieving record id {}, type= {}. No record server configured for route {}", (Object)data.europeanaId, (Object)recordType, (Object)data.servletRequest.getServerName());
            throw new InvalidConfigurationException(ProblemType.CONFIG_ERROR, "No CHO database configured for request route");
        }
        if (data.profiles.contains(Profile.TRANSLATE) && this.recordTranslationEnabled.booleanValue() && !this.recordTranslations.isEnabled()) {
            throw new TranslationServiceDisabledException();
        }
        if (data.lang != null) {
            try {
                data.setLanguages(Language.validateMultiple((String)data.lang));
            }
            catch (InvalidLanguageException e) {
                throw new InvalidParamValueException(e.getMessage());
            }
        }
        if (Objects.isNull(bean = this.recordService.fetchFullBean((DataSourceWrapper)dataSource.get(), data.europeanaId, true))) {
            ModelAndView result;
            response.setStatus(404);
            if (recordType == RecordType.OBJECT_RDF) {
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("error", "Non-existing record identifier");
                result = new ModelAndView("rdf", model);
            } else {
                result = eu.europeana.api2.utils.JsonUtils.toJson((Object)new ApiError(data.wskey, "Invalid record identifier: " + data.europeanaId), (String)data.callback);
            }
            return result;
        }
        String tsUpdated = this.httpCacheUtils.dateToRFC1123String(bean.getTimestampUpdated());
        String eTag = this.httpCacheUtils.generateETag(data.europeanaId + tsUpdated, true, true);
        if (StringUtils.isNotBlank((CharSequence)data.servletRequest.getHeader("If-None-Match"))) {
            if (this.httpCacheUtils.doesAnyIfNoneMatch(data.servletRequest, eTag)) {
                response = this.httpCacheUtils.addDefaultHeaders(response, eTag, tsUpdated);
                response.setStatus(304);
                return null;
            }
        } else if (StringUtils.isNotBlank((CharSequence)data.servletRequest.getHeader("If-Match"))) {
            if (this.httpCacheUtils.doesPreconditionFail(data.servletRequest, eTag)) {
                response.setStatus(412);
                return null;
            }
        } else if (this.httpCacheUtils.isNotModifiedSince(data.servletRequest, bean.getTimestampUpdated())) {
            response.setStatus(304);
            return null;
        }
        RecordDao recordDao = (RecordDao)((DataSourceWrapper)dataSource.get()).getRecordDao().get();
        BaseUrlWrapper baseUrls = this.routeService.getBaseUrlsForRequest(data.servletRequest.getServerName());
        bean = this.recordService.enrichFullBean(recordDao, bean, baseUrls);
        if (this.recordTranslationEnabled.booleanValue() && data.profiles.contains(Profile.TRANSLATE)) {
            if (data.languages == null || data.languages.isEmpty()) {
                data.setLanguages(this.recordTranslations.getDefaultTranslationLanguage(bean));
            }
            if (data.languages != null && !data.languages.isEmpty()) {
                try {
                    bean = this.recordTranslations.translate(bean, ((Language)data.languages.get(0)).name().toLowerCase(Locale.ROOT), this.getAuthorizationHeader(data.servletRequest));
                }
                catch (TranslationServiceNotAvailableException e) {
                    ControllerUtils.redirectForTranslationsLimitException((HttpServletRequest)data.servletRequest, (HttpServletResponse)response, (Set)data.profiles);
                    throw new TranslationServiceNotAvailableException(e.getCause().getMessage(), (Exception)((Object)e));
                }
            }
        }
        if (data.languages != null && !data.languages.isEmpty()) {
            bean = (FullBean)LanguageFilter.filter((IdBean)bean, (List)data.languages);
        }
        response = this.httpCacheUtils.addDefaultHeaders(response, eTag, tsUpdated);
        ModelAndView output = switch (1.$SwitchMap$eu$europeana$api2$v2$model$RecordType[recordType.ordinal()]) {
            case 1 -> this.generateJson(bean, data, startTime);
            case 2 -> this.generateJsonLd(bean, data, response);
            case 3 -> this.generateRdf(bean);
            case 4 -> this.generateSchemaOrg(bean, data, response);
            case 5 -> this.generateTurtle(bean, data, response);
            default -> throw new IllegalArgumentException("Unknown record output type: " + recordType);
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done generating record output in {} ms ", (Object)(System.currentTimeMillis() - startTime));
        }
        return output;
    }

    private ModelAndView generateJson(FullBean bean, RequestData data, long startTime) {
        ObjectResult objectResult = new ObjectResult(data.wskey);
        if (data.profiles.contains(Profile.SCHEMAORG)) {
            try {
                objectResult.schemaOrg = SchemaOrgUtils.toSchemaOrg((FullBeanImpl)((FullBeanImpl)bean));
            }
            catch (IOException e) {
                LOG.error("Error generating schema.org data", (Throwable)e);
            }
        }
        if (data.profiles.contains(Profile.PARAMS)) {
            objectResult.addParams(RequestUtils.getParameterMap((HttpServletRequest)data.servletRequest), new String[]{"wskey"});
            objectResult.addParam("profile", (Object)data.profile);
        }
        objectResult.object = new FullView(bean);
        objectResult.statsDuration = System.currentTimeMillis() - startTime;
        return eu.europeana.api2.utils.JsonUtils.toJson((Object)objectResult, (String)data.callback);
    }

    private ModelAndView generateSchemaOrg(FullBean bean, RequestData data, HttpServletResponse response) {
        try {
            String jsonld = SchemaOrgUtils.toSchemaOrg((FullBeanImpl)((FullBeanImpl)bean));
            return eu.europeana.api2.utils.JsonUtils.toJsonLd((String)jsonld, (String)data.callback);
        }
        catch (IOException e) {
            LOG.error("Error generating schema.org data", (Throwable)e);
            response.setStatus(500);
            ApiError errorDetails = new ApiError(data.servletRequest.getHeader("X-Api-Key"), e.getClass().getSimpleName() + ": " + e.getMessage());
            return eu.europeana.api2.utils.JsonUtils.toJson((Object)errorDetails, (String)data.callback);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ModelAndView generateJsonLd(FullBean bean, RequestData data, HttpServletResponse response) {
        String rdf = EdmUtils.toEDM((FullBeanImpl)((FullBeanImpl)bean));
        try (StringReader reader = new StringReader(rdf);){
            ModelAndView modelAndView;
            try (StringWriter writer = new StringWriter();){
                RiotRdfUtils.disableErrorForSpaceURI();
                Model modelResult = ModelFactory.createDefaultModel().read((Reader)reader, "RDF/XML");
                DatasetGraph graph = DatasetFactory.wrap((Model)modelResult).asDatasetGraph();
                JsonLDWriteContext ctx = new JsonLDWriteContext();
                ctx.setJsonLDContext(jsonldContext);
                RDFWriterBuilder writerBuilder = RDFWriter.create();
                RDFWriter rdfWriter = writerBuilder.source(graph).format(RDFFormat.JSONLD10_FLAT).context((Context)ctx).build();
                rdfWriter.output(writer);
                String orderedJsonLd = ModelUtils.sortHasViews((FullBean)bean, (String)writer.toString());
                modelAndView = eu.europeana.api2.utils.JsonUtils.toJsonLd((String)orderedJsonLd, (String)data.callback);
            }
            return modelAndView;
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException e) {
            LOG.error("Error parsing JSON-LD data", (Throwable)e);
            response.setStatus(500);
            ApiError errorDetails = new ApiError(data.wskey, e.getClass().getSimpleName() + ": " + e.getMessage());
            return eu.europeana.api2.utils.JsonUtils.toJson((Object)errorDetails, (String)data.callback);
        }
    }

    private ModelAndView generateRdf(FullBean bean) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("record", EdmUtils.toEDM((FullBeanImpl)((FullBeanImpl)bean)));
        return new ModelAndView("rdf", model);
    }

    /*
     * Exception decompiling
     */
    private ModelAndView generateTurtle(FullBean bean, RequestData data, HttpServletResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String generateRedirectUrl(HttpServletRequest req, String oldId, String newId) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        String requestUri = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        if (!(requestUri = requestUri.replace(oldId, newId)).contains(newId)) {
            throw new IllegalStateException("Error generating record redirect url");
        }
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(':').append(serverPort);
        }
        url.append(requestUri);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if (queryString != null) {
            url.append('?').append(queryString);
        }
        return url.toString();
    }

    static {
        try {
            InputStream in = ObjectController.class.getResourceAsStream("/jsonld/context.jsonld");
            jsonldContext = JsonUtils.fromInputStream((InputStream)in);
        }
        catch (IOException e) {
            LOG.error("Error reading context.jsonld", (Throwable)e);
        }
    }
}

