/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.indexing.solr.facet.FacetEncoder;
import eu.europeana.indexing.solr.facet.value.AudioDuration;
import eu.europeana.indexing.solr.facet.value.ImageColorEncoding;
import eu.europeana.indexing.solr.facet.value.ImageSize;
import eu.europeana.indexing.solr.facet.value.VideoDuration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TagUtils {
    private TagUtils() {
    }

    public static Set<Integer> encodeColourPalette(List<String> coloursToEncode) {
        HashSet<ImageColorEncoding> encodedColours = new HashSet<ImageColorEncoding>();
        FacetEncoder encoder = new FacetEncoder();
        for (String colourHexValue : coloursToEncode) {
            encodedColours.add(ImageColorEncoding.categorizeImageColor((String)colourHexValue));
        }
        return encoder.getImageFacetValueCodes(null, null, null, null, encodedColours);
    }

    public static ImageSize getImageSize(String size) {
        if (StringUtils.isBlank((CharSequence)size)) {
            return null;
        }
        switch (size) {
            case "small": {
                return ImageSize.SMALL;
            }
            case "medium": {
                return ImageSize.MEDIUM;
            }
            case "large": {
                return ImageSize.LARGE;
            }
            case "huge": 
            case "extra_large": {
                return ImageSize.HUGE;
            }
        }
        return null;
    }

    public static VideoDuration getVideoDurationCode(String duration) {
        if (StringUtils.isBlank((CharSequence)duration)) {
            return null;
        }
        switch (duration) {
            case "short": {
                return VideoDuration.SHORT;
            }
            case "medium": {
                return VideoDuration.MEDIUM;
            }
            case "long": {
                return VideoDuration.LONG;
            }
        }
        return null;
    }

    public static AudioDuration getAudioDurationCode(String duration) {
        if (StringUtils.isBlank((CharSequence)duration)) {
            return null;
        }
        switch (duration) {
            case "tiny": 
            case "very_short": {
                return AudioDuration.TINY;
            }
            case "short": {
                return AudioDuration.SHORT;
            }
            case "medium": {
                return AudioDuration.MEDIUM;
            }
            case "long": {
                return AudioDuration.LONG;
            }
        }
        return null;
    }

    public static boolean isImageMimeType(String type) {
        return StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"image");
    }

    public static boolean isSoundMimeType(String type) {
        return StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"sound") || StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"audio");
    }

    public static boolean isVideoMimeType(String type) {
        return StringUtils.startsWithIgnoreCase((CharSequence)type, (CharSequence)"video");
    }
}

