/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api.translation.definitions.language.Language;
import eu.europeana.api2.v2.service.translate.BaseService;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.EuropeanaAggregation;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LanguageFilter {
    private static final Logger LOG = LogManager.getLogger(LanguageFilter.class);

    private LanguageFilter() {
    }

    public static IdBean filter(IdBean bean, List<Language> targetLangs) {
        long startTime = System.currentTimeMillis();
        LanguageFilter.iterativeFilterFields((Object)bean, targetLangs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering language data took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return bean;
    }

    private static void iterativeFilterFields(Object o, List<Language> targetLangs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting object {}", (Object)o.getClass().getName());
        }
        ReflectionUtils.FieldFilter fieldFilter = field -> (field.getType().isAssignableFrom(Map.class) || field.getType().isAssignableFrom(List.class) || field.getType().isAssignableFrom(EuropeanaAggregation.class)) && !"fieldMap".equals(field.getName());
        ReflectionUtils.doWithFields(o.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = field.get(o);
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Field {} has class {}", (Object)field.getName(), fieldValue == null ? null : fieldValue.getClass());
            }
            if (fieldValue instanceof Map) {
                fieldValue = LanguageFilter.filterLanguageMap((String)field.getName(), (Map)((Map)fieldValue), (List)targetLangs);
                if (fieldValue == null) {
                    LOG.debug("    Deleting map {} entirely", (Object)field.getName());
                    field.set(o, null);
                }
            } else if (fieldValue instanceof List) {
                List list = (List)fieldValue;
                for (Object item : list) {
                    LanguageFilter.iterativeFilterFields(item, (List)targetLangs);
                }
            } else if (fieldValue instanceof EuropeanaAggregation) {
                LanguageFilter.iterativeFilterFields((Object)fieldValue, (List)targetLangs);
            } else assert (fieldValue == null) : "Unknown field class " + fieldValue.getClass() + ". Checks do not match field filter";
        }, (ReflectionUtils.FieldFilter)fieldFilter);
    }

    private static Map filterLanguageMap(String fieldName, Map<?, ?> map, List<Language> targetLangs) {
        if (map == null) {
            return null;
        }
        LOG.debug("    Map {} has {} keys and {} values", (Object)fieldName, (Object)map.keySet().size(), (Object)map.values().size());
        Set<Map.Entry<?, ?>> set = map.entrySet();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<?, ?> keyValue : set) {
            String origKey = keyValue.getKey().toString();
            String keyLang = origKey.substring(origKey.indexOf(".") + 1);
            if ("def".equals(keyLang) || EuropeanaUriUtils.isUri((String)origKey)) {
                LOG.debug("      Keeping key def, value {}", keyValue.getValue());
                continue;
            }
            if (Language.isNoLinguisticContent((String)keyLang) || Language.isSupported((String)keyLang) && targetLangs.contains(Language.getLanguage((String)keyLang))) {
                LOG.debug("      Keeping key {}, value {}", (Object)origKey, keyValue.getValue());
                continue;
            }
            LOG.debug("      Removing key {}, value {}", (Object)origKey, keyValue.getValue());
            keysToRemove.add(origKey);
        }
        if (map.keySet().size() == keysToRemove.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Keys to remove {}. Return all lang-tagged values", (Object)keysToRemove.size());
            }
            return map;
        }
        for (String keyToRemove : keysToRemove) {
            map.remove(keyToRemove);
        }
        return map;
    }

    public static IdBean removeNonLanguageAwareFields(IdBean bean) {
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = field.get(bean);
            if (fieldValue != null) {
                ReflectionUtils.setField((Field)field, (Object)bean, null);
            }
        }, (ReflectionUtils.FieldFilter)BaseService.searchFieldRemovalFilter);
        return bean;
    }
}

