/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.exceptions.DateMathParseException;
import eu.europeana.api2.v2.exceptions.InvalidRangeOrGapException;
import eu.europeana.api2.v2.model.NumericFacetParameter;
import eu.europeana.api2.v2.utils.DateMathParser;
import eu.europeana.corelib.definitions.solr.RangeFacetType;
import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacetParameterUtils {
    private static final String DEFAULT_LIMIT_KEY = "f.DEFAULT.facet.limit";
    private static final String DEFAULT_OFFSET_KEY = "f.DEFAULT.facet.offset";
    private static final int LIMIT_FOR_DATA_PROVIDER = 50;
    private static final int LIMIT_FOR_DEFAULT = 50;
    private static final int LIMIT_FOR_CUSTOM = 50;
    private static final int LIMIT_FOR_TECH_DEFAULT = 50;
    private static final int LIMIT_FOR_TECH_CUSTOM = 50;
    private static final String FACET_RANGE = "facet.range";
    private static final String FACET_RANGE_START = "facet.range.start";
    private static final String FACET_RANGE_END = "facet.range.end";
    private static final String FACET_RANGE_GAP = "facet.range.gap";
    private static final String FACET_MINCOUNT = "facet.mincount";
    private static final String DEFAULT_START = "0001-01-01T00:00:00Z";
    private static final String NOW = "now";
    private static final String DEFAULT_GAP = "+1YEAR";
    private static final long MAX_RANGE_FACETS = 30000L;
    private static List<String> defaultSolrFacetList;
    private static List<String> rangeFacetList;
    private static List<String> rangeSpecifiers;
    private static DateFormat solrDateFormat;

    public static Map<String, Integer> getSolrFacetParams(String type, String[] solrFacets, Map<String, String[]> parameters, boolean defaultFacetsRequested) {
        HashMap<String, Integer> solrFacetParams = new HashMap<String, Integer>();
        if (defaultFacetsRequested) {
            for (SolrFacetType solrFacetType : SolrFacetType.values()) {
                FacetParameterUtils.saveNumericFacetParam((String)type, (String)solrFacetType.name(), parameters, (boolean)true, (boolean)false, solrFacetParams);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])solrFacets)) {
            for (String string : solrFacets) {
                if (defaultFacetsRequested && defaultSolrFacetList.contains(string)) continue;
                FacetParameterUtils.saveNumericFacetParam((String)type, (String)string, parameters, (boolean)defaultSolrFacetList.contains(string), (boolean)false, solrFacetParams);
            }
        }
        return solrFacetParams;
    }

    public static Map<String, Integer> getTechnicalFacetParams(String type, String[] technicalFacets, Map<String, String[]> parameters, boolean defaultFacetsRequested) {
        HashMap<String, Integer> technicalFacetParams;
        block3: {
            block2: {
                technicalFacetParams = new HashMap<String, Integer>();
                if (!defaultFacetsRequested) break block2;
                for (TechnicalFacetType technicalFacet : TechnicalFacetType.values()) {
                    FacetParameterUtils.saveNumericFacetParam((String)type, (String)technicalFacet.name(), parameters, (boolean)true, (boolean)true, technicalFacetParams);
                }
                break block3;
            }
            if (!ArrayUtils.isNotEmpty((Object[])technicalFacets)) break block3;
            for (String technicalFacetName : technicalFacets) {
                FacetParameterUtils.saveNumericFacetParam((String)type, (String)technicalFacetName, parameters, (boolean)false, (boolean)true, technicalFacetParams);
            }
        }
        return technicalFacetParams;
    }

    public static Map<String, String> getDateRangeParams(Map<String, String[]> parameters) throws DateMathParseException, InvalidRangeOrGapException {
        HashMap<String, String> dateRangeParams = new HashMap<String, String>();
        List facetsToRange = FacetParameterUtils.retrieveRangeFacetList(parameters, (String)"facet.range");
        StringBuilder facetRangeValue = new StringBuilder();
        for (String facetToRange : facetsToRange) {
            facetRangeValue.append(facetToRange);
            facetRangeValue.append(",");
        }
        if (!facetsToRange.isEmpty()) {
            dateRangeParams.put("facet.range", StringUtils.chop((String)facetRangeValue.toString()));
        }
        for (String facetToRange : facetsToRange) {
            for (String rangeSpecifier : rangeSpecifiers) {
                String globalSpecifier = "facet.range." + rangeSpecifier;
                String fieldSpecifier = "f." + facetToRange + ".facet.range." + rangeSpecifier;
                if (parameters.containsKey(globalSpecifier)) {
                    dateRangeParams.put(fieldSpecifier, FacetParameterUtils.plusificate((String)parameters.get(globalSpecifier)[0], (String)rangeSpecifier));
                    continue;
                }
                if (parameters.containsKey(fieldSpecifier)) {
                    dateRangeParams.put(fieldSpecifier, FacetParameterUtils.plusificate((String)parameters.get(fieldSpecifier)[0], (String)rangeSpecifier));
                    continue;
                }
                dateRangeParams.put(fieldSpecifier, FacetParameterUtils.getDefaultValue((String)rangeSpecifier));
            }
            DateMathParser.exceedsMaxNrOfGaps((String)((String)dateRangeParams.get("f." + facetToRange + ".facet.range.start")), (String)((String)dateRangeParams.get("f." + facetToRange + ".facet.range.end")), (String)((String)dateRangeParams.get("f." + facetToRange + ".facet.range.gap")), (long)30000L);
        }
        return dateRangeParams;
    }

    private static String getDefaultValue(String rangeSpecifier) {
        return switch (rangeSpecifier) {
            case "start" -> "0001-01-01T00:00:00Z";
            case "end" -> FacetParameterUtils.thisVeryMoment();
            case "gap" -> "+1YEAR";
            default -> "";
        };
    }

    private static String plusificate(String plusMinusNow, String rangeSpecifier) {
        if (StringUtils.equalsIgnoreCase((CharSequence)rangeSpecifier, (CharSequence)"gap") && !StringUtils.startsWithAny((CharSequence)plusMinusNow, (CharSequence[])new CharSequence[]{"+", "-"})) {
            return "+" + plusMinusNow;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"now", (CharSequence)plusMinusNow)) {
            return FacetParameterUtils.thisVeryMoment();
        }
        return plusMinusNow;
    }

    private static String thisVeryMoment() {
        return solrDateFormat.format(new Date());
    }

    private static List<String> retrieveRangeFacetList(Map<String, String[]> parameters, String pattern) {
        ArrayList facetsToRangeTemp = new ArrayList();
        ArrayList<String> facetsToRange = new ArrayList<String>();
        if (parameters.containsKey(pattern)) {
            Collections.addAll(facetsToRangeTemp, StringUtils.stripAll((String[])StringUtils.split((String)parameters.get(pattern)[0], (char)',')));
            for (String facetToRangeTemp : facetsToRangeTemp) {
                if (!rangeFacetList.contains(facetToRangeTemp)) continue;
                facetsToRange.add(facetToRangeTemp);
            }
        }
        return facetsToRange;
    }

    private static void saveNumericFacetParam(String type, String name, Map<String, String[]> parameters, boolean isDefault, boolean isTech, Map<String, Integer> facetParams) {
        NumericFacetParameter parameter = null;
        if (type.equals("limit")) {
            parameter = FacetParameterUtils.getFacetLimit((String)name, parameters, (boolean)isDefault, (boolean)isTech);
        } else if (type.equals("offset")) {
            parameter = FacetParameterUtils.getFacetOffset((String)name, parameters, (boolean)isDefault);
        }
        if (parameter != null) {
            facetParams.put(parameter.getName(), parameter.getValue());
        }
    }

    private static NumericFacetParameter getFacetLimit(String facet, Map<String, String[]> parameters, boolean isDefault, boolean isTech) {
        String key = "f." + facet + ".facet.limit";
        Integer defaultLimit = isTech ? Integer.valueOf(isDefault ? 50 : 50) : Integer.valueOf(isDefault ? (StringUtils.equals((CharSequence)facet, (CharSequence)"DATA_PROVIDER") ? 50 : 50) : 50);
        return FacetParameterUtils.extractNumericParameter((String)key, (String)"f.DEFAULT.facet.limit", parameters, (boolean)isDefault, (Integer)defaultLimit);
    }

    private static NumericFacetParameter getFacetOffset(String facet, Map<String, String[]> parameters, boolean isDefault) {
        String key = "f." + facet + ".facet.offset";
        return FacetParameterUtils.extractNumericParameter((String)key, (String)"f.DEFAULT.facet.offset", parameters, (boolean)isDefault, null);
    }

    private static NumericFacetParameter extractNumericParameter(String key, String defaultKey, Map<String, String[]> parameters, boolean isDefault, Integer defaultValue) {
        if (parameters.containsKey(key)) {
            String[] value = parameters.get(key);
            return new NumericFacetParameter(key, value[0]);
        }
        if (isDefault && parameters.containsKey(defaultKey)) {
            String[] value = parameters.get(defaultKey);
            return new NumericFacetParameter(key, value[0]);
        }
        if (defaultValue != null) {
            return new NumericFacetParameter(key, defaultValue);
        }
        return null;
    }

    public static String getLimitForDataProvider() {
        return String.valueOf(50);
    }

    static {
        rangeSpecifiers = Arrays.asList("start", "end", "gap");
        solrDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        defaultSolrFacetList = new ArrayList();
        for (SolrFacetType solrFacetType : SolrFacetType.values()) {
            defaultSolrFacetList.add(solrFacetType.toString());
        }
        rangeFacetList = new ArrayList();
        for (SolrFacetType solrFacetType : RangeFacetType.values()) {
            rangeFacetList.add(solrFacetType.toString());
        }
    }
}

