/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.model.enums.Profile;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ControllerUtils {
    public static final String ALLOWED_GET_HEAD = "GET, HEAD";
    public static final String ALLOWED_GET_HEAD_POST = "GET, HEAD, POST";
    private static final String ACCEPT = "Accept";
    private static final String PROFILE_PATTERN = "[&?]profile.*?(?=&|\\?|$)";
    private static final String LANG_PATTERN = "[&?]lang.*?(?=&|\\?|$)";
    private static final String PARAM_SEPERATOR = "&";

    private ControllerUtils() {
    }

    public static String getRequestFormat(HttpServletRequest request) {
        String result = null;
        String uri = request.getRequestURI();
        if (uri.contains(".")) {
            result = uri.substring(uri.lastIndexOf(46) + 1, uri.length());
        }
        return result;
    }

    public static String getRequestedMediaType(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("Accept"))) {
            return request.getHeader("Accept");
        }
        return null;
    }

    public static String getRequestedContentType(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getContentType())) {
            return request.getContentType();
        }
        return null;
    }

    public static void addResponseHeaders(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Allow", "GET, HEAD");
    }

    public static void redirectForTranslationsLimitException(HttpServletRequest request, HttpServletResponse response, Set<Profile> profiles) {
        String queryStringWithoutTranslate = ControllerUtils.getQueryStringWithoutTranslate((String)request.getQueryString(), profiles);
        String location = ControllerUtils.removeRequestMapping((String)request.getRequestURI()) + "?" + queryStringWithoutTranslate;
        response.setStatus(307);
        response.setHeader("Location", location);
    }

    public static String removeRequestMapping(String request) {
        return StringUtils.substringAfterLast((String)request, (String)"/");
    }

    public static String getQueryStringWithoutTranslate(String query, Set<Profile> profiles) {
        Object queryString = ControllerUtils.removeProfileFromRequest((String)ControllerUtils.removeLangFromRequest((String)query));
        profiles.remove(Profile.TRANSLATE);
        if (!profiles.isEmpty()) {
            if (StringUtils.startsWith((CharSequence)queryString, (CharSequence)"&")) {
                queryString = StringUtils.removeStart((String)queryString, (String)"&");
            }
            queryString = (String)queryString + "&profile=" + profiles.stream().map(Profile::getName).collect(Collectors.joining(","));
        }
        return queryString;
    }

    private static String removeLangFromRequest(String query) {
        if (StringUtils.startsWith((CharSequence)query, (CharSequence)"lang")) {
            query = "?" + (String)query;
        }
        return ((String)query).replaceAll("[&?]lang.*?(?=&|\\?|$)", "");
    }

    private static String removeProfileFromRequest(String query) {
        if (StringUtils.startsWith((CharSequence)query, (CharSequence)"profile")) {
            query = "?" + (String)query;
        }
        return ((String)query).replaceAll("[&?]profile.*?(?=&|\\?|$)", "");
    }

    public static boolean is5xxError(int httpStatusCode) {
        HttpStatus status = HttpStatus.valueOf((int)httpStatusCode);
        return status.is5xxServerError();
    }
}

