/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api.translation.definitions.language.Language;
import eu.europeana.api.translation.service.exception.LanguageDetectionException;
import eu.europeana.api2.v2.exceptions.TranslationException;
import eu.europeana.api2.v2.exceptions.TranslationServiceNotAvailableException;
import eu.europeana.api2.v2.service.translate.BaseService;
import eu.europeana.api2.v2.service.translate.MetadataLangDetectionService;
import eu.europeana.api2.v2.service.translate.MetadataTranslationService;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import eu.europeana.corelib.web.exception.EuropeanaException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class TranslationService {
    private static final Logger LOG = LogManager.getLogger(TranslationService.class);
    MetadataTranslationService metadataTranslationService;
    MetadataLangDetectionService metadataLangDetectionService;

    @Autowired
    public TranslationService(MetadataTranslationService metadataTranslationService, MetadataLangDetectionService metadataLangDetectionService) {
        this.metadataLangDetectionService = metadataLangDetectionService;
        this.metadataTranslationService = metadataTranslationService;
    }

    public List<BriefBean> translate(List<BriefBean> beans, String targetLanguage, String authToken) throws EuropeanaException {
        try {
            return this.metadataTranslationService.searchResultsTranslations(this.metadataLangDetectionService.detectLanguageForSearchResults(beans, authToken), targetLanguage, authToken);
        }
        catch (LanguageDetectionException | eu.europeana.api.translation.service.exception.TranslationException e) {
            if (ControllerUtils.is5xxError((int)this.getRemoteStatusCode((Exception)e))) {
                throw new TranslationServiceNotAvailableException(e.getMessage(), (Exception)e);
            }
            throw new TranslationException((Exception)e);
        }
    }

    public FullBean translate(FullBean bean, String targetLanguage, String authToken) throws EuropeanaException {
        try {
            Proxy europeanaProxy = BaseService.getEuropeanaProxy((List)bean.getProxies(), (String)bean.getAbout());
            ArrayList translatedDuringIngestion = new ArrayList();
            ReflectionUtils.doWithFields(europeanaProxy.getClass(), field -> translatedDuringIngestion.add(this.languageTaggedValueIsPresent(europeanaProxy, field)), (ReflectionUtils.FieldFilter)BaseService.proxyFieldFilter);
            if (translatedDuringIngestion.contains(Boolean.TRUE)) {
                LOG.info("Record was translated during the ingestion.. ");
                if (StringUtils.equals((String)targetLanguage, (String)Language.PIVOT)) {
                    return bean;
                }
                return this.metadataTranslationService.proxyTranslation(bean, targetLanguage, authToken);
            }
            return this.metadataTranslationService.proxyTranslation(this.metadataLangDetectionService.detectLanguageForProxy(bean, authToken), targetLanguage, authToken);
        }
        catch (LanguageDetectionException | eu.europeana.api.translation.service.exception.TranslationException e) {
            if (ControllerUtils.is5xxError((int)this.getRemoteStatusCode((Exception)e))) {
                throw new TranslationServiceNotAvailableException(e.getMessage(), (Exception)e);
            }
            throw new TranslationException((Exception)e);
        }
    }

    private boolean languageTaggedValueIsPresent(Proxy proxy, Field field) {
        HashMap origFieldData = (HashMap)BaseService.getValueOfTheField((Object)proxy, (boolean)false).apply(field.getName());
        if (origFieldData != null && !origFieldData.isEmpty()) {
            boolean hasLangTaggedLiterals = false;
            for (Map.Entry entry : origFieldData.entrySet()) {
                if (!Language.isSupported((String)((String)entry.getKey())) || !this.hasLiterals((List)entry.getValue())) continue;
                hasLangTaggedLiterals = true;
                break;
            }
            if (hasLangTaggedLiterals) {
                return true;
            }
        }
        return false;
    }

    private boolean hasLiterals(List<String> values) {
        return values.stream().anyMatch(value -> !EuropeanaUriUtils.isUri((String)value));
    }

    public boolean isEnabled() {
        return this.metadataTranslationService != null && this.metadataLangDetectionService != null;
    }

    public List<Language> getDefaultTranslationLanguage(FullBean bean) {
        ArrayList<Language> lang = new ArrayList<Language>();
        Map edmLanguage = bean.getEuropeanaAggregation().getEdmLanguage();
        for (Map.Entry entry : edmLanguage.entrySet()) {
            for (String languageAbbreviation : (List)entry.getValue()) {
                if (Language.isSupported((String)languageAbbreviation)) {
                    lang.add(Language.getLanguage((String)languageAbbreviation));
                    continue;
                }
                LOG.warn("edm:language '{}' is not supported for default translation and filtering ", (Object)languageAbbreviation);
            }
        }
        if (!lang.isEmpty()) {
            LOG.debug("Default translation and filtering applied for language : {} ", lang);
        }
        return lang;
    }

    protected int getRemoteStatusCode(Exception e) {
        if (e.getClass().isAssignableFrom(LanguageDetectionException.class)) {
            return ((LanguageDetectionException)((Object)e)).getRemoteStatusCode();
        }
        if (e.getClass().isAssignableFrom(eu.europeana.api.translation.service.exception.TranslationException.class)) {
            return ((eu.europeana.api.translation.service.exception.TranslationException)((Object)e)).getRemoteStatusCode();
        }
        return 0;
    }
}

