/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.model;

import eu.europeana.api2.v2.exceptions.InvalidParamValueException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GeoDistance {
    private static final String FQ_GEOFILT_SFIELD = "{!geofilt}";
    private static final String LOCATION_SUFFIX = "_wgs";
    private static final String LOCATION_PATTERN = "^(currentLocation|coverageLocation|location)\\s*?,\\s*?(-?\\d+\\.?\\d*)\\s*?,\\s*?(-?\\d+\\.?\\d*)\\s*?,\\s*?(\\d+\\.?\\d*)$";
    private static final String ERROR_PATTERN = "^(.+?)\\s*?,\\s*?(.+?)\\s*?,\\s*?(.+?)\\s*?,\\s*?(.+?)$";
    private static final String SFIELD_PATTERN = "^currentLocation|coverageLocation|location$";
    private static final String LATLONG_PATTERN = "^-?\\d+\\.?\\d*$";
    private static final String DISTANCE_PATTERN = "^\\d+\\.?\\d*$";
    private String qfValue;
    private String sField;
    private Float latitude;
    private Float longitude;
    private Float distance;

    public String getSField() {
        return this.sField;
    }

    public void setSField(String sField) {
        this.sField = sField + LOCATION_SUFFIX;
    }

    public String getFQGeo() {
        return FQ_GEOFILT_SFIELD;
    }

    public void setLatitude(float latitude) throws InvalidParamValueException {
        if ((double)Math.abs(latitude) > 90.0) {
            throw new InvalidParamValueException("The value for latitude must be between -90.0 and 90.0");
        }
        this.latitude = Float.valueOf(latitude);
    }

    public void setLongitude(float longitude) throws InvalidParamValueException {
        if ((double)Math.abs(longitude) > 90.0) {
            throw new InvalidParamValueException("The value for longitude must be between -180.0 and 180.0");
        }
        this.longitude = Float.valueOf(longitude);
    }

    public String getDistance() {
        return String.valueOf(this.distance);
    }

    public void setDistance(float distance) throws InvalidParamValueException {
        if ((double)distance > 20004.0) {
            throw new InvalidParamValueException("The supplied value for distance - '" + distance + "' is larger than the longest possible distance between two points on Earth (20.004 km)");
        }
        this.distance = Float.valueOf(distance);
    }

    public String getPoint() {
        return this.latitude + "," + this.longitude;
    }

    public boolean isInitialised() {
        return null != this.sField && null != this.latitude && null != this.longitude && null != this.distance;
    }

    public void initialise(String qfValue) throws InvalidParamValueException {
        this.qfValue = qfValue;
        if (StringUtils.isBlank((CharSequence)qfValue)) {
            throw new InvalidParamValueException("No value for qf=distance set");
        }
        Pattern compiledLocPattern = Pattern.compile(LOCATION_PATTERN);
        Matcher locMatcher = compiledLocPattern.matcher(qfValue);
        ArrayList<String> geoArgumentList = new ArrayList<String>();
        if (locMatcher.find() && locMatcher.groupCount() == 4) {
            for (int i = 1; i <= locMatcher.groupCount(); ++i) {
                geoArgumentList.add(locMatcher.group(i));
            }
            this.setSField((String)geoArgumentList.get(0));
            this.setLatitude(Float.parseFloat((String)geoArgumentList.get(1)));
            this.setLongitude(Float.parseFloat((String)geoArgumentList.get(2)));
            this.setDistance(Float.parseFloat((String)geoArgumentList.get(3)));
        } else {
            this.handleParameterErrors(qfValue);
        }
    }

    private void handleParameterErrors(String qfValue) throws InvalidParamValueException {
        Pattern errorPattern = Pattern.compile(ERROR_PATTERN);
        Matcher errorMatcher = errorPattern.matcher(qfValue);
        ArrayList<String> wrongArgumentList = new ArrayList<String>();
        if (errorMatcher.find() && errorMatcher.groupCount() == 4) {
            for (int i = 1; i <= errorMatcher.groupCount(); ++i) {
                wrongArgumentList.add(errorMatcher.group(i));
            }
        } else {
            throw new InvalidParamValueException("qf=distance requires four arguments separated by commas: [currentLocation|coverageLocation|location], latitude, longitude, distance");
        }
        this.handleWrongArguments(wrongArgumentList);
    }

    private void handleWrongArguments(List<String> wrongArgumentList) throws InvalidParamValueException {
        Pattern sFieldPattern = Pattern.compile(SFIELD_PATTERN);
        Matcher sFieldMatcher = sFieldPattern.matcher(wrongArgumentList.get(0));
        Pattern latLongPattern = Pattern.compile(LATLONG_PATTERN);
        Matcher latMatcher = latLongPattern.matcher(wrongArgumentList.get(1));
        Matcher longMatcher = latLongPattern.matcher(wrongArgumentList.get(2));
        Pattern distancePattern = Pattern.compile(DISTANCE_PATTERN);
        Matcher distanceMatcher = distancePattern.matcher(wrongArgumentList.get(3));
        if (!sFieldMatcher.find()) {
            throw new InvalidParamValueException("The first argument to qf=distance must be one of [currentLocation|coverageLocation|location] (case sensitive)");
        }
        if (!latMatcher.find()) {
            throw new InvalidParamValueException("The second argument to qf=distance (latitude) must be a positive or negative decimal number");
        }
        if (!longMatcher.find()) {
            throw new InvalidParamValueException("The third argument to qf=distance (longitude) must be a positive or negative decimal number");
        }
        if (!distanceMatcher.find()) {
            throw new InvalidParamValueException("The last argument to qf=distance (distance) must be a positive decimal number");
        }
        throw new InvalidParamValueException("Arguments to qf=distance should conform to ([currentLocation|coverageLocation|location], [-]0 - 90.0, [-]0 - 180.0, decimal number > 0)");
    }
}

