/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.model;

import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import org.apache.commons.lang3.StringUtils;

public class FacetTag {
    private String name;
    private String label;

    public FacetTag(String name, String label) {
        this.name = name;
        this.label = label;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getLabel() {
        if (StringUtils.isBlank((CharSequence)this.label)) {
            return "";
        }
        if (StringUtils.equals((CharSequence)this.name, (CharSequence)TechnicalFacetType.COLOURPALETTE.getRealName())) {
            return this.translateMetisTerms(StringUtils.upperCase((String)this.label));
        }
        return this.translateMetisTerms(StringUtils.lowerCase((String)this.label));
    }

    private String translateMetisTerms(String metisTerm) {
        switch (metisTerm) {
            case "tiny": {
                return "very_short";
            }
            case "huge": {
                return "extra_large";
            }
            case "high": 
            case "color": {
                return "true";
            }
            case "grayscale": 
            case "other": {
                return "false";
            }
        }
        return metisTerm;
    }
}

