/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class EndpointHandlerMappingCustom
extends RequestMappingHandlerMapping {
    Logger log = LogManager.getLogger(EndpointHandlerMappingCustom.class);
    private final Set<MvcEndpoint> endpoints;
    private final CorsConfiguration corsConfiguration;
    private final String prefix;
    private boolean disabled = false;
    private MvcEndpoint handler;

    public EndpointHandlerMappingCustom(Collection<? extends MvcEndpoint> endpoints) {
        this(endpoints, null);
    }

    public EndpointHandlerMappingCustom(Collection<? extends MvcEndpoint> endpoints, CorsConfiguration corsConfiguration) {
        this.prefix = "";
        this.endpoints = new HashSet<MvcEndpoint>(endpoints);
        this.corsConfiguration = corsConfiguration;
        this.setOrder(-100);
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        return this.corsConfiguration;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.disabled) {
            for (MvcEndpoint this.handler : this.endpoints) {
                this.log.info("Registering handler mapping for : {}", (Object)this.handler.getPath());
                this.detectHandlerMethods((Object)this.handler);
            }
        }
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo mapping = super.getMappingForMethod(method, handlerType);
        if (mapping != null) {
            String[] patterns = this.getPatterns((Object)this.handler, mapping);
            return this.withNewPatterns(mapping, patterns);
        }
        return null;
    }

    private String[] getPatterns(Object handler, RequestMappingInfo mapping) {
        Set defaultPatterns;
        String path = this.getPath(handler);
        String prefixVal = StringUtils.hasText((String)this.prefix) ? this.prefix + path : path;
        PatternsRequestCondition patternsCondition = mapping.getPatternsCondition();
        Set set = defaultPatterns = patternsCondition != null ? patternsCondition.getPatterns() : new HashSet();
        if (defaultPatterns.isEmpty()) {
            return new String[]{prefixVal, prefixVal + ".json"};
        }
        ArrayList<CallSite> patterns = new ArrayList<CallSite>(defaultPatterns);
        for (int i = 0; i < patterns.size(); ++i) {
            patterns.set(i, (CallSite)((Object)(prefixVal + (String)patterns.get(i))));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private String getPath(Object handler) {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null && handler instanceof String) {
            handler = applicationContext.getBean((String)handler);
        }
        return handler instanceof MvcEndpoint ? ((MvcEndpoint)handler).getPath() : "";
    }

    private RequestMappingInfo withNewPatterns(RequestMappingInfo mapping, String[] patternStrings) {
        PatternsRequestCondition patterns = new PatternsRequestCondition(patternStrings, null, null, this.useSuffixPatternMatch(), this.useTrailingSlashMatch(), null);
        return new RequestMappingInfo(patterns, mapping.getMethodsCondition(), mapping.getParamsCondition(), mapping.getHeadersCondition(), mapping.getConsumesCondition(), mapping.getProducesCondition(), mapping.getCustomCondition());
    }
}

