/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.api.translation.client.TranslationApiClient;
import eu.europeana.api.translation.client.config.TranslationClientConfiguration;
import eu.europeana.api.translation.client.exception.TranslationApiException;
import eu.europeana.api2.config.RouteConfigLoader;
import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.v2.exceptions.InvalidConfigurationException;
import eu.europeana.api2.v2.model.translate.MultilingualQueryGenerator;
import eu.europeana.api2.v2.model.translate.QueryTranslator;
import eu.europeana.api2.v2.service.ApiAuthorizationService;
import eu.europeana.api2.v2.service.RouteDataService;
import eu.europeana.api2.v2.service.translate.MetadataChosenLanguageService;
import eu.europeana.api2.v2.service.translate.MetadataLangDetectionService;
import eu.europeana.api2.v2.service.translate.MetadataTranslationService;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.api2.v2.utils.HttpCacheUtils;
import eu.europeana.corelib.web.exception.ProblemType;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@ImportResource(value={"classpath:corelib-definitions-context.xml", "classpath:corelib-mongo-context.xml", "classpath:corelib-solr-context.xml", "classpath:corelib-web-context.xml"})
@PropertySource(value={"classpath:europeana.properties"})
public class AppConfig {
    private static final Logger LOG = LogManager.getLogger(AppConfig.class);
    @Value(value="${portal.baseUrl:}")
    private String portalBaseUrl;
    @Value(value="${api2.baseUrl:}")
    private String api2BaseUrl;
    @Value(value="${apikey.service.url:}")
    private String apikeyServiceUrl;
    @Value(value="${apiGateway.baseUrl:}")
    private String apiGatewayBaseUrl;
    @Autowired
    private Environment env;
    @Value(value="${translation.record:false}")
    private Boolean translationRecord;
    @Value(value="${translation.search.query:false}")
    private Boolean translationSearchQuery;
    @Value(value="${translation.search.results:false}")
    private Boolean translationSearchResults;
    @Value(value="${translation.api.endpoint:}")
    private String translationApiEndpoint;
    @Value(value="${translation.char.limit:}")
    private Integer translationCharLimit;
    @Value(value="${translation.char.tolerance:}")
    private Integer translationCharTolerance;

    @PostConstruct
    public void logConfiguration() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Active Spring profiles: {}", (Object)Arrays.toString(this.env.getActiveProfiles()));
            LOG.info("Default Spring profiles: {}", (Object)Arrays.toString(this.env.getDefaultProfiles()));
        }
        if (this.apikeyServiceUrl != null) {
            this.apikeyServiceUrl = this.apikeyServiceUrl.trim();
            if (this.apikeyServiceUrl.isEmpty()) {
                LOG.warn("No API key service host defined!");
            } else if (!this.apikeyServiceUrl.startsWith("http")) {
                LOG.warn("No protocol defined for API key service host! Using http://");
                this.apikeyServiceUrl = this.apikeyServiceUrl + "http://";
            }
        }
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertySourcesPlaceholderConfigurer.setIgnoreResourceNotFound(true);
        propertySourcesPlaceholderConfigurer.setLocalOverride(true);
        propertySourcesPlaceholderConfigurer.setLocations(new Resource[]{new ClassPathResource("europeana.properties"), new ClassPathResource("europeana.user.properties")});
        return propertySourcesPlaceholderConfigurer;
    }

    @Bean
    public HttpCacheUtils httpCacheUtils() {
        return new HttpCacheUtils();
    }

    @Bean
    public Api2UrlService api2UrlService() {
        Api2UrlService urlService = new Api2UrlService(this.routeConfigLoader().getRouteBaseUrlMap(), this.portalBaseUrl, this.api2BaseUrl, this.apikeyServiceUrl, this.apiGatewayBaseUrl);
        LogManager.getLogger(Api2UrlService.class).info("Portal base url = {}", (Object)urlService.getPortalBaseUrl(""));
        LogManager.getLogger(Api2UrlService.class).info("API2 base url = {}", (Object)urlService.getApi2BaseUrl(""));
        LogManager.getLogger(Api2UrlService.class).info("Apikey service url = {}", (Object)urlService.getApikeyServiceUrl());
        LogManager.getLogger(Api2UrlService.class).info("Api gateway base url = {}", (Object)urlService.getApiGatewayBaseUrl(""));
        return urlService;
    }

    @Bean
    public MultilingualQueryGenerator multilingualQueryGenerator() throws InvalidConfigurationException {
        return new MultilingualQueryGenerator(new QueryTranslator(this.getTranslationApiClient()));
    }

    @Bean
    public RouteConfigLoader routeConfigLoader() {
        return new RouteConfigLoader();
    }

    @Bean
    public RouteDataService routeService() {
        return new RouteDataService();
    }

    @Bean(name={"apiKeyClientDetails"})
    public EuropeanaClientDetailsService getApiKeyClientDetailsService() {
        EuropeanaClientDetailsService clientDetails = new EuropeanaClientDetailsService();
        clientDetails.setApiKeyServiceUrl(this.apikeyServiceUrl);
        return clientDetails;
    }

    @Bean
    public ApiAuthorizationService getAuthorizationService() {
        return new ApiAuthorizationService();
    }

    @Bean
    public TranslationApiClient getTranslationApiClient() throws InvalidConfigurationException {
        try {
            if (this.translationRecord.booleanValue() || this.translationSearchQuery.booleanValue() || this.translationSearchResults.booleanValue()) {
                TranslationClientConfiguration configuration = new TranslationClientConfiguration(this.loadProperties());
                return new TranslationApiClient(configuration);
            }
        }
        catch (TranslationApiException e) {
            throw new InvalidConfigurationException(ProblemType.TRANSLATION_API_URL_ERROR);
        }
        return null;
    }

    @Bean
    public TranslationService translationService() throws InvalidConfigurationException {
        if (this.translationRecord.booleanValue() || this.translationSearchQuery.booleanValue() || this.translationSearchResults.booleanValue()) {
            return new TranslationService(new MetadataTranslationService(this.getTranslationApiClient(), new MetadataChosenLanguageService(this.getTranslationApiClient()), this.translationCharLimit, this.translationCharTolerance), new MetadataLangDetectionService(this.getTranslationApiClient()));
        }
        return null;
    }

    private Properties loadProperties() {
        Properties properties = new Properties();
        properties.put("translation.api.endpoint", this.translationApiEndpoint);
        return properties;
    }
}

