/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api2.ApiKeyException;
import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.v2.service.ApiAuthorizationService;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiKeyUtils {
    private static final Logger LOG = LogManager.getLogger(ApiKeyUtils.class);
    private static final int MAXCONNTOTAL = 200;
    private static final int MAXCONNPERROUTE = 100;
    @Resource
    private Api2UrlService urlService;
    private CloseableHttpClient httpClient;
    @Resource
    ApiAuthorizationService authorizationService;

    public ApiKeyUtils() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(100);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    @PreDestroy
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public void authorizeReadAccess(HttpServletRequest servletRequest) throws ApiKeyException {
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtils.isBlank((CharSequence)ApiKeyUtils.extractApiKeyFromRequest((HttpServletRequest)servletRequest))) {
                throw new ApiKeyException(ProblemType.APIKEY_MISSING, null, 400);
            }
            this.performReadAccessAuthorization(servletRequest);
        }
        catch (ApplicationAuthenticationException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            int statusCode = e.getStatus() != null ? e.getStatus().value() : 401;
            throw new ApiKeyException(ProblemType.APIKEY_DOES_NOT_EXIST, servletRequest.getHeader("X-Api-Key"), statusCode);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validation of apiKey took {} ms", (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    private void performReadAccessAuthorization(HttpServletRequest servletRequest) throws ApplicationAuthenticationException {
        if (StringUtils.isBlank((CharSequence)this.urlService.getApikeyServiceUrl())) {
            LOG.warn("API Key Service URL not defined ,validation disabled!!!");
            return;
        }
        this.authorizationService.authorizeReadAccess(servletRequest);
    }

    public static String extractApiKeyFromRequest(HttpServletRequest request) {
        return request.getHeader("X-Api-Key") != null ? request.getHeader("X-Api-Key") : request.getParameter("wskey");
    }
}

