/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api2.v2.model.translate.Language;
import eu.europeana.api2.v2.service.translate.FieldValuesLanguageMap;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.api2.v2.service.translate.TranslationUtils;
import eu.europeana.api2.v2.service.translate.TranslationsMap;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.edm.utils.EdmUtils;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import eu.europeana.corelib.web.exception.EuropeanaException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class SearchResultTranslateService {
    private static final Logger LOG = LogManager.getLogger(SearchResultTranslateService.class);
    private static final Set<String> FIELDS_TO_TRANSLATE = Set.of("dcTitleLangAware", "dcDescriptionLangAware", "dcCreatorLangAware");
    private final TranslationService translationService;
    @Value(value="#{europeanaProperties['translation.truncate.after']}")
    private Integer truncateFieldAfter;
    @Value(value="#{europeanaProperties['translation.truncate.hardlimit']}")
    private Integer truncateFieldHardLimit;

    public SearchResultTranslateService(TranslationService translationService) {
        this.translationService = translationService;
    }

    public boolean isEnabled() {
        return this.translationService != null;
    }

    public List<BriefBean> translateSearchResults(List<BriefBean> results, String targetLang) throws EuropeanaException {
        long startTime = System.currentTimeMillis();
        TranslationsMap textsToTranslate = new TranslationsMap(this.getTextsToTranslate(results, targetLang));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translate results - Gathering data took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        long startTimeTranslate = System.currentTimeMillis();
        FieldValuesLanguageMap translations = textsToTranslate.translate(this.translationService, targetLang, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translate results - Send/receive translation request took {} ms", (Object)(System.currentTimeMillis() - startTimeTranslate));
        }
        long startTimeOutput = System.currentTimeMillis();
        for (Map.Entry entry : translations.entrySet()) {
            TranslationUtils.addTranslationsToList(results, (String)((String)entry.getKey()), (String)this.getSolrKeyName((String)entry.getKey(), targetLang), (List)((List)entry.getValue()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translate results - Generating output took {} ms", (Object)(System.currentTimeMillis() - startTimeOutput));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translate results - Total time {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return results;
    }

    private String getSolrKeyName(String fieldName, String lang) {
        return "null." + lang.toLowerCase(Locale.ROOT);
    }

    private List<FieldValuesLanguageMap> getTextsToTranslate(List<BriefBean> searchResults, String targetLang) {
        ArrayList<FieldValuesLanguageMap> result = new ArrayList<FieldValuesLanguageMap>();
        ReflectionUtils.FieldFilter resultFieldFilter = field -> field.getType().isAssignableFrom(Map.class) && FIELDS_TO_TRANSLATE.contains(field.getName());
        int index = 0;
        for (BriefBean resultItem : searchResults) {
            LOG.debug("Check search result {}...", (Object)index);
            int finalIndex = index++;
            ReflectionUtils.doWithFields(resultItem.getClass(), field -> {
                ReflectionUtils.makeAccessible((Field)field);
                LOG.debug("  Inspecting field {}..", (Object)field.getName());
                FieldValuesLanguageMap toTranslate = this.getValuesToTranslate(resultItem, finalIndex, field, targetLang);
                if (toTranslate != null && !toTranslate.isEmpty()) {
                    LOG.trace("    Adding value {}", (Object)toTranslate);
                    result.add(toTranslate);
                }
            }, (ReflectionUtils.FieldFilter)resultFieldFilter);
        }
        return result;
    }

    private FieldValuesLanguageMap getValuesToTranslate(BriefBean resultItem, int index, Field field, String targetLang) {
        FieldValuesLanguageMap result = this.getFieldValuesForLang(resultItem, index, field, targetLang);
        if (result != null) {
            LOG.debug("  Found value(s) with target language {} for item {}, field {}, no translation needed", (Object)targetLang, (Object)index, (Object)field.getName());
            return null;
        }
        if (!Language.ENGLISH.equals(targetLang)) {
            result = this.getFieldValuesForLang(resultItem, index, field, Language.ENGLISH);
        }
        if (result == null) {
            result = this.getFieldValuesForLang(resultItem, index, field, "def");
        }
        if (result == null) {
            result = this.getFieldValuesForLang(resultItem, index, field, null);
        }
        if (result == null) {
            LOG.trace("  Found no values for item {}, field {}", (Object)index, (Object)field.getName());
        } else {
            LOG.debug("  Found value for item {}, field {} with {} language", (Object)index, (Object)field.getName(), (Object)result.getSourceLanguage());
        }
        return result;
    }

    private FieldValuesLanguageMap getFieldValuesForLang(BriefBean resultItem, int index, Field field, String lang) {
        FieldValuesLanguageMap result = null;
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)resultItem);
        if (value instanceof Map) {
            Map fieldData = EdmUtils.cloneMap((Map)((Map)value));
            String fieldName = index + "." + field.getName();
            result = this.getNonUriValuesFromLanguageMap(fieldData, fieldName, lang);
        } else if (value != null) {
            LOG.warn("Unexpected data - field {} did not return a map", (Object)field.getName());
        }
        LOG.trace("    Item {}, field {}, lang {}, result = {}", (Object)index, (Object)field.getName(), (Object)lang, result);
        return result;
    }

    protected FieldValuesLanguageMap getNonUriValuesFromLanguageMap(Map<String, List<String>> map, String fieldName, String lang) {
        FieldValuesLanguageMap result = null;
        if (lang != null) {
            List values = this.filterOutUris(TranslationUtils.getValuesToTranslateFromMultilingualMap(map, (String)lang, (Integer)this.truncateFieldAfter, (Integer)this.truncateFieldHardLimit));
            if (values != null && !values.isEmpty()) {
                result = new FieldValuesLanguageMap(lang, fieldName, values);
            }
        } else if (!map.keySet().isEmpty()) {
            for (String key : map.keySet()) {
                if (Language.isSupported((String)key)) {
                    List values = this.filterOutUris(TranslationUtils.getValuesToTranslateFromMultilingualMap(map, (String)key, (Integer)this.truncateFieldAfter, (Integer)this.truncateFieldHardLimit));
                    result = new FieldValuesLanguageMap(Language.getLanguage((String)key).name().toLowerCase(Locale.ROOT), fieldName, values);
                    if (result == null) continue;
                    break;
                }
                LOG.debug("  Skipping unsupported language {} in field {}", (Object)key, (Object)fieldName);
            }
        }
        return result;
    }

    private List<String> filterOutUris(List<String> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.stream().filter(v -> !EuropeanaUriUtils.isUri((String)v)).collect(Collectors.toList());
    }
}

