/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.corelib.utils.ComparatorUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldValuesLanguageMap
extends LinkedHashMap<String, List<String>> {
    private static final long serialVersionUID = 7857857025275959529L;
    private static final Logger LOG = LogManager.getLogger(FieldValuesLanguageMap.class);
    @Nonnull
    private final String sourceLanguage;

    public FieldValuesLanguageMap(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public FieldValuesLanguageMap(String sourceLanguage, Map<String, List<String>> map) {
        super.putAll(map);
        this.sourceLanguage = sourceLanguage;
    }

    public FieldValuesLanguageMap(String sourceLanguage, String fieldName, List<String> textsToTranslate) {
        super.put(fieldName, textsToTranslate);
        this.sourceLanguage = sourceLanguage;
    }

    @Override
    public List<String> put(String fieldName, List<String> textsToTranslate) {
        if (this.containsKey((Object)fieldName)) {
            throw new IllegalArgumentException("Key " + fieldName + " already exists for language " + this.sourceLanguage + " with value " + this.get((Object)fieldName) + ". Use merge function instead!");
        }
        return super.put(fieldName, textsToTranslate);
    }

    public boolean remove(String fieldName, List<String> valuesToRemove) {
        List values = (List)this.get((Object)fieldName);
        for (String valueToRemove : valuesToRemove) {
            if (values.remove(valueToRemove)) continue;
            throw new IllegalArgumentException("Could not find and remove value " + valueToRemove);
        }
        return true;
    }

    public long getNrCharacters() {
        long result = 0L;
        for (List values : this.values()) {
            for (String value : values) {
                result += (long)value.length();
            }
        }
        return result;
    }

    public void merge(FieldValuesLanguageMap map) {
        if (!this.getSourceLanguage().equals(map.getSourceLanguage())) {
            throw new IllegalArgumentException("Maps with different source languages should not be merged");
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (this.containsKey((Object)key)) {
                List mergedValues = this.mergeValues((List)this.get((Object)key), values, key);
                this.remove((Object)key);
                this.put(key, mergedValues);
                continue;
            }
            this.put(key, values);
        }
    }

    private List<String> mergeValues(List<String> values1, List<String> values2, String fieldName) {
        ArrayList<String> mergedValues = new ArrayList<String>(values1);
        for (String value2 : values2) {
            boolean valuePresent = false;
            for (String value1 : values1) {
                if (!ComparatorUtils.sameValueWithoutSpace((String)value1, (String)value2)) continue;
                valuePresent = true;
                break;
            }
            if (valuePresent) {
                LOG.debug("Field {} - Found duplicate value {}", (Object)fieldName, (Object)value2);
                continue;
            }
            LOG.debug("Field {} - Merging value {}", (Object)fieldName, (Object)value2);
            mergedValues.add(value2);
        }
        return mergedValues;
    }

    @Nonnull
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldValuesLanguageMap that = (FieldValuesLanguageMap)o;
        return this.sourceLanguage.equals(that.sourceLanguage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceLanguage);
    }
}

