/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import eu.europeana.api2.utils.SolrLocalParamFormatter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolrEscapeDeserializer
extends JsonDeserializer<String> {
    private final Logger log = LogManager.getLogger(SolrEscapeDeserializer.class);
    private final SolrLocalParamFormatter formatter = new SolrLocalParamFormatter();

    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        try {
            return this.formatter.parse(jsonParser.getText(), Locale.getDefault());
        }
        catch (ParseException e) {
            this.log.warn("Error sanitizing JSON input: ", (Throwable)e);
            return null;
        }
    }
}

