/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.api2.config.RouteConfigLoader;
import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.v2.model.translate.MultilingualQueryGenerator;
import eu.europeana.api2.v2.model.translate.QueryTranslator;
import eu.europeana.api2.v2.service.ApiAuthorizationService;
import eu.europeana.api2.v2.service.RouteDataService;
import eu.europeana.api2.v2.service.translate.GoogleTranslationService;
import eu.europeana.api2.v2.service.translate.PangeanicTranslationService;
import eu.europeana.api2.v2.service.translate.PangeanicV2TranslationService;
import eu.europeana.api2.v2.service.translate.SearchResultTranslateService;
import eu.europeana.api2.v2.service.translate.TranslationEngine;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.api2.v2.utils.HttpCacheUtils;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@ImportResource(value={"classpath:corelib-definitions-context.xml", "classpath:corelib-mongo-context.xml", "classpath:corelib-solr-context.xml", "classpath:corelib-web-context.xml"})
@PropertySource(value={"classpath:europeana.properties"})
public class AppConfig {
    private static final Logger LOG = LogManager.getLogger(AppConfig.class);
    @Value(value="${portal.baseUrl:}")
    private String portalBaseUrl;
    @Value(value="${api2.baseUrl:}")
    private String api2BaseUrl;
    @Value(value="${apikey.service.url:}")
    private String apikeyServiceUrl;
    @Value(value="${apiGateway.baseUrl:}")
    private String apiGatewayBaseUrl;
    @Value(value="${translation.engine:NONE}")
    private String translationEngineString;
    private TranslationService translationService;
    @Value(value="${translation.search.query:false}")
    private Boolean translationSearchQuery;
    @Value(value="${translation.search.results:false}")
    private Boolean translationSearchResults;
    @Autowired
    private Environment env;

    @PostConstruct
    public void logConfiguration() {
        TranslationEngine engine;
        if (LOG.isInfoEnabled()) {
            LOG.info("CF_INSTANCE_INDEX  = {}, CF_INSTANCE_GUID = {}, CF_INSTANCE_IP  = {}", (Object)System.getenv("CF_INSTANCE_INDEX"), (Object)System.getenv("CF_INSTANCE_GUID"), (Object)System.getenv("CF_INSTANCE_IP"));
            LOG.info("Active Spring profiles: {}", (Object)Arrays.toString(this.env.getActiveProfiles()));
            LOG.info("Default Spring profiles: {}", (Object)Arrays.toString(this.env.getDefaultProfiles()));
        }
        if (this.apikeyServiceUrl != null) {
            this.apikeyServiceUrl = this.apikeyServiceUrl.trim();
            if (this.apikeyServiceUrl.isEmpty()) {
                LOG.warn("No API key service host defined!");
            } else if (!this.apikeyServiceUrl.startsWith("http")) {
                LOG.warn("No protocol defined for API key service host! Using http://");
                this.apikeyServiceUrl = this.apikeyServiceUrl + "http://";
            }
        }
        if (TranslationEngine.PANGEANIC.equals((Object)(engine = TranslationEngine.fromString((String)this.translationEngineString)))) {
            this.translationService = new PangeanicTranslationService();
        } else if (TranslationEngine.GOOGLE.equals((Object)engine)) {
            this.translationService = new GoogleTranslationService();
        } else if (TranslationEngine.PANGEANIC2.equals((Object)engine)) {
            this.translationService = new PangeanicV2TranslationService();
        }
        LOG.info("No translation engine available.");
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertySourcesPlaceholderConfigurer.setIgnoreResourceNotFound(true);
        propertySourcesPlaceholderConfigurer.setLocalOverride(true);
        propertySourcesPlaceholderConfigurer.setLocations(new Resource[]{new ClassPathResource("europeana.properties"), new ClassPathResource("europeana.user.properties")});
        return propertySourcesPlaceholderConfigurer;
    }

    @Bean
    public ApiKeyUtils apiKeyUtils() {
        return new ApiKeyUtils();
    }

    @Bean
    public HttpCacheUtils httpCacheUtils() {
        return new HttpCacheUtils();
    }

    @Bean
    public Api2UrlService api2UrlService() {
        Api2UrlService urlService = new Api2UrlService(this.routeConfigLoader().getRouteBaseUrlMap(), this.portalBaseUrl, this.api2BaseUrl, this.apikeyServiceUrl, this.apiGatewayBaseUrl);
        LogManager.getLogger(Api2UrlService.class).info("Portal base url = {}", (Object)urlService.getPortalBaseUrl(""));
        LogManager.getLogger(Api2UrlService.class).info("API2 base url = {}", (Object)urlService.getApi2BaseUrl(""));
        LogManager.getLogger(Api2UrlService.class).info("Apikey service url = {}", (Object)urlService.getApikeyServiceUrl());
        LogManager.getLogger(Api2UrlService.class).info("Api gateway base url = {}", (Object)urlService.getApiGatewayBaseUrl(""));
        return urlService;
    }

    @Bean
    public TranslationService translationService() {
        return this.translationService;
    }

    @Bean
    MultilingualQueryGenerator multilingualQueryGenerator() {
        if (this.translationSearchQuery.booleanValue() && this.translationService != null) {
            return new MultilingualQueryGenerator(new QueryTranslator(this.translationService));
        }
        return null;
    }

    @Bean
    SearchResultTranslateService searchResultTranslationService() {
        if (this.translationSearchResults.booleanValue() && this.translationService != null) {
            return new SearchResultTranslateService(this.translationService);
        }
        return null;
    }

    @Bean
    public RouteConfigLoader routeConfigLoader() {
        return new RouteConfigLoader();
    }

    @Bean
    public RouteDataService routeService() {
        return new RouteDataService();
    }

    @Bean(name={"apiKeyClientDetails"})
    public EuropeanaClientDetailsService getApiKeyClientDetailsService() {
        EuropeanaClientDetailsService clientDetails = new EuropeanaClientDetailsService();
        clientDetails.setApiKeyServiceUrl(this.apikeyServiceUrl);
        return clientDetails;
    }

    @Bean
    public ApiAuthorizationService getAuthorizarionService() {
        return new ApiAuthorizationService();
    }
}

