/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api2.v2.exceptions.InvalidConfigurationException;
import eu.europeana.api2.v2.exceptions.JsonSerializationException;
import eu.europeana.api2.v2.service.RouteDataService;
import eu.europeana.api2.v2.utils.ApiKeyUtils;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.web.exception.ProblemType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseController {
    private static final Logger LOG = LogManager.getLogger(BaseController.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    @Resource
    protected SearchService searchService;
    @Resource
    protected ApiKeyUtils apiKeyUtils;
    protected RouteDataService routeService;
    protected ObjectMapper mapper = new ObjectMapper();

    @Autowired
    protected BaseController(RouteDataService routeService) {
        this.routeService = routeService;
    }

    protected SolrClient getSolrClient(String route) throws InvalidConfigurationException {
        Optional solrClient = this.routeService.getSolrClientForRequest(route);
        if (solrClient.isEmpty()) {
            LOG.error("No Solr client configured for route {}", (Object)route);
            throw new InvalidConfigurationException(ProblemType.CONFIG_ERROR, "No search engine configured for request route");
        }
        return (SolrClient)solrClient.get();
    }

    protected String serializeToJson(Object object) throws JsonSerializationException {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        this.mapper.setDateFormat((DateFormat)df);
        try {
            return this.mapper.writer().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationException((Exception)((Object)e));
        }
    }
}

