/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api.commons.definitions.statistics.UsageStatsFields;
import eu.europeana.api.commons.definitions.statistics.search.HighQualityMetric;
import eu.europeana.corelib.definitions.solr.model.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UsageStatsUtils
extends UsageStatsFields {
    private static final String URL_PREFIX = "\"http://data.europeana.eu/";
    private static final String ORGANIZATION_QUERY = "foaf_organization:*";
    public static final String QUERY_ALL = "*";
    public static final String QUERY_OR = " OR ";
    public static final String QUERY_ALL_MINUS_0 = "NOT contentTier:0";
    public static final String QUERY_T0 = "contentTier:0";
    public static final String QUERY_T2 = "contentTier:(2 OR 3 OR 4)";
    public static final String QUERY_T2_TA = "contentTier:(2 OR 3 OR 4) AND NOT metadataTier:0";
    public static final String QUERY_T3 = "contentTier:(3 OR 4)";
    public static final String QUERY_TA = "NOT metadataTier:0";
    private static final String SOLR_SOUND = "SOUND";

    public static Query createQueryForLinkedItems(String entityType) {
        if (StringUtils.equals((String)entityType, (String)"organization")) {
            Query query = new Query(ORGANIZATION_QUERY);
            query.setPageSize(0);
            return query;
        }
        StringBuilder q = new StringBuilder(URL_PREFIX);
        q.append(entityType).append("/\"");
        Query query = new Query(q.toString());
        query.setPageSize(0);
        return query;
    }

    public static Query createAllQuery() {
        StringBuilder q = new StringBuilder();
        ArrayList<String> entityTypes = new ArrayList<String>(Arrays.asList("place", "agent", "organization", "timespan", "concept"));
        for (String type : entityTypes) {
            q.append(URL_PREFIX).append(type).append("/\"").append(QUERY_OR);
        }
        Query query = new Query(StringUtils.removeEnd((String)q.toString(), (String)QUERY_OR));
        query.setPageSize(0);
        return query;
    }

    public static HighQualityMetric processFacetMap(Map<String, Long> valueCountmap) {
        HighQualityMetric metric = new HighQualityMetric();
        for (Map.Entry<String, Long> entry : valueCountmap.entrySet()) {
            if (StringUtils.equals((String)entry.getKey(), (String)"IMAGE")) {
                metric.setImage(entry.getValue().longValue());
            }
            if (StringUtils.equals((String)entry.getKey(), (String)"TEXT")) {
                metric.setText(entry.getValue().longValue());
            }
            if (StringUtils.equals((String)entry.getKey(), (String)SOLR_SOUND)) {
                metric.setAudio(entry.getValue().longValue());
            }
            if (StringUtils.equals((String)entry.getKey(), (String)"VIDEO")) {
                metric.setVideo(entry.getValue().longValue());
            }
            if (!StringUtils.equals((String)entry.getKey(), (String)"3D")) continue;
            metric.setThreeD(entry.getValue().longValue());
        }
        metric.setAll(metric.getOverall());
        return metric;
    }
}

