/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpCacheUtils {
    private static final Logger LOG = LogManager.getLogger(HttpCacheUtils.class);
    public static final String IFNONEMATCH = "If-None-Match";
    public static final String IFMATCH = "If-Match";
    private static final String IFMODIFIEDSINCE = "If-Modified-Since";
    private static final String ANY = "\"*\"";
    private static final String GZIPSUFFIX = "-gzip\"";
    private static final String ALLOWED = "GET, HEAD, POST";
    private static final String CACHE_CONTROL = "public, max-age=";
    private static final String DEFAULT_MAX_AGE = "86400";
    private static String apiVersion;

    public String generateETag(String data, boolean weakETag, boolean includeApiVersion) {
        String eTag = "\"" + this.getSHA256Hash(data, includeApiVersion) + "\"";
        if (weakETag) {
            return "W/" + eTag;
        }
        return eTag;
    }

    private String getSHA256Hash(String data, boolean includeApiVersion) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            if (includeApiVersion) {
                data = (String)data + apiVersion;
            }
            byte[] encodedhash = digest.digest(((String)data).getBytes(StandardCharsets.UTF_8));
            return HttpCacheUtils.bytesToHex((byte[])encodedhash);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error creating SHA-265 hash", (Throwable)e);
            return null;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte aHash : hash) {
            String hex = Integer.toHexString(0xFF & aHash);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private ZonedDateTime stringToZonedUTC(String dateString) {
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        Date date = DateUtils.parseDate((String)dateString);
        if (date == null) {
            LOG.error("Error parsing request header Date string: " + dateString);
            return null;
        }
        return this.dateToZonedUTC(date);
    }

    private ZonedDateTime dateToZonedUTC(Date date) {
        return date.toInstant().atOffset(ZoneOffset.UTC).toZonedDateTime().withNano(0);
    }

    public String dateToRFC1123String(Date date) {
        return DateUtils.formatDate((Date)date);
    }

    public HttpServletResponse addDefaultHeaders(HttpServletResponse response, String eTag, String lastModified) {
        return this.addDefaultHeaders(response, eTag, lastModified, "86400");
    }

    public HttpServletResponse addDefaultHeaders(HttpServletResponse response, String eTag, String lastModified, String cacheMaxAge) {
        if (StringUtils.isNotBlank((CharSequence)eTag)) {
            response.addHeader("ETag", eTag);
        }
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            response.addHeader("Last-Modified", lastModified);
        }
        response.addHeader("Cache-Control", "public, max-age=" + (cacheMaxAge == null ? "86400" : cacheMaxAge));
        response.addHeader("Allow", "GET, HEAD, POST");
        return response;
    }

    public boolean doesAnyIfNoneMatch(HttpServletRequest request, String eTag) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-None-Match")) && this.doesAnyETagMatch(request.getHeader("If-None-Match"), eTag);
    }

    public boolean isNotModifiedSince(HttpServletRequest request, Date tsUpdated) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Modified-Since")) && Objects.requireNonNull(this.stringToZonedUTC(request.getHeader("If-Modified-Since"))).compareTo(this.dateToZonedUTC(tsUpdated)) >= 0;
    }

    @Deprecated
    public boolean isModifiedSince(HttpServletRequest request, Date tsUpdated) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Modified-Since")) && Objects.requireNonNull(this.stringToZonedUTC(request.getHeader("If-Modified-Since"))).compareTo(this.dateToZonedUTC(tsUpdated)) < 0;
    }

    public boolean doesPreconditionFail(HttpServletRequest request, String eTag) {
        return StringUtils.isNotBlank((CharSequence)request.getHeader("If-Match")) && !this.doesAnyETagMatch(request.getHeader("If-Match"), eTag);
    }

    private boolean doesAnyETagMatch(String eTags, String eTagToMatch) {
        if (StringUtils.equals((CharSequence)"\"*\"", (CharSequence)eTags)) {
            return true;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{eTags, eTagToMatch})) {
            for (String eTag : StringUtils.stripAll((String[])StringUtils.split((String)eTags, (String)","))) {
                if (!this.matchesDespiteGzipSuffix(eTag, eTagToMatch)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesDespiteGzipSuffix(String eTag, String eTagToMatch) {
        return StringUtils.equalsIgnoreCase((CharSequence)StringUtils.replaceIgnoreCase((String)eTag, (String)"-gzip\"", (String)"\""), (CharSequence)eTagToMatch);
    }

    static {
        try (InputStream is = HttpCacheUtils.class.getClassLoader().getResourceAsStream("build.properties");){
            if (is == null) {
                LOG.warn("No build.properties file found.");
            } else {
                Properties buildProps = new Properties();
                buildProps.load(is);
                apiVersion = buildProps.getProperty("info.app.version");
            }
        }
        catch (IOException e) {
            LOG.warn("Error reading build.properties file", (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)apiVersion)) {
            LOG.warn("Unable to read API version from build.properties file, using current date instead");
            apiVersion = DateUtils.formatDate((Date)new Date());
        } else {
            LOG.info("API version = " + apiVersion);
        }
    }
}

