/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.model.translate;

import eu.europeana.api2.v2.model.translate.Query;
import eu.europeana.api2.v2.model.translate.QueryParser;
import eu.europeana.api2.v2.model.translate.QueryTranslator;
import eu.europeana.corelib.web.exception.EuropeanaException;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MultilingualQueryGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MultilingualQueryGenerator.class);
    @Value(value="#{europeanaProperties['translation.search.query']}")
    private boolean isQueryTranslationEnabled;
    private QueryTranslator queryTranslator;

    @Autowired
    public MultilingualQueryGenerator(QueryTranslator queryTranslator) {
        this.queryTranslator = queryTranslator;
    }

    public String getMultilingualQuery(String queryString, String targetLanguage, String sourceLanguage) throws EuropeanaException {
        return this.getMultilingualQuery(new Query(queryString), targetLanguage, sourceLanguage);
    }

    private String getMultilingualQuery(Query query, String targetLanguage, String sourceLanguage) throws EuropeanaException, IndexOutOfBoundsException {
        LOG.debug("target language {}, source language {}", (Object)targetLanguage, (Object)sourceLanguage);
        QueryParser qParser = new QueryParser();
        query = qParser.parse(query);
        String translation = this.queryTranslator.translate(query, targetLanguage, sourceLanguage);
        if (StringUtils.isNotBlank((CharSequence)translation)) {
            if (StringUtils.equals((CharSequence)query.getText(), (CharSequence)translation)) {
                return query.getText();
            }
            return "(" + query.getText() + ") OR (" + translation + ")";
        }
        return query.getText();
    }

    public boolean isEnabled() {
        return this.isQueryTranslationEnabled && this.queryTranslator.isServiceConfigured();
    }

    @PreDestroy
    public void close() {
        if (this.queryTranslator != null) {
            this.queryTranslator.close();
        }
    }
}

