/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.config;

import eu.europeana.corelib.record.BaseUrlWrapper;
import eu.europeana.corelib.utils.ConfigUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RouteConfigLoader {
    private final Map<String, String> routeDataSourceMap = new HashMap();
    private final Map<String, String> routeSolrMap = new HashMap();
    private final Map<String, BaseUrlWrapper> routeBaseUrlMap = new HashMap();
    private static final String SEPARATOR = ".";
    private static final String HOSTNAME_SEPARATOR = ",";
    private static final String PORTAL_BASEURL_PROP = "portal.baseUrl";
    private static final String GATEWAY_BASEURL_PROP = "apiGateway.baseUrl";
    private static final String API_BASEURL_PROP = "api2.baseUrl";
    @Autowired
    @Qualifier(value="europeanaProperties")
    private Properties properties;

    public RouteConfigLoader() {
    }

    public RouteConfigLoader(@Autowired @Qualifier(value="europeanaProperties") Properties properties) {
        this.properties = properties;
    }

    @PostConstruct
    void loadRouteConfig() {
        String defaultApiBaseUrl = this.properties.getProperty(API_BASEURL_PROP, "");
        String defaultGatewayBaseUrl = this.properties.getProperty(GATEWAY_BASEURL_PROP, "");
        String defaultPortalBaseUrl = this.properties.getProperty(PORTAL_BASEURL_PROP, "");
        int routeNo = 1;
        while (ConfigUtils.containsKeyPrefix((Properties)this.properties, (String)("route" + routeNo))) {
            String baseProp = "route" + routeNo + SEPARATOR;
            String routePath = this.properties.getProperty(baseProp + "path");
            String dataSourceId = this.properties.getProperty(baseProp + "data-source");
            String solrId = this.properties.getProperty(baseProp + "solr");
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{routePath, dataSourceId, solrId})) {
                throw new IllegalStateException(String.format("Empty route mapping found in config - route:%s, data-source:%s, solr:%s, configProp:%s", routePath, dataSourceId, solrId, baseProp));
            }
            List hostnames = this.getHostNames(routePath);
            hostnames.forEach(hostname -> {
                if (this.routeDataSourceMap.containsKey(hostname)) {
                    throw new IllegalStateException(String.format("Duplicate host name in route config - hostname: %s, route: %s, configProp: %s", hostname, routePath, baseProp));
                }
            });
            String routeApiBaseUrl = this.properties.getProperty(baseProp + API_BASEURL_PROP, defaultApiBaseUrl);
            String routeGatewayBaseUrl = this.properties.getProperty(baseProp + GATEWAY_BASEURL_PROP, defaultGatewayBaseUrl);
            String routePortalBaseUrl = this.properties.getProperty(baseProp + PORTAL_BASEURL_PROP, defaultPortalBaseUrl);
            hostnames.forEach(hostname -> {
                this.routeDataSourceMap.put(hostname, dataSourceId);
                this.routeSolrMap.put(hostname, solrId);
                this.routeBaseUrlMap.put(hostname, new BaseUrlWrapper(routeApiBaseUrl, routeGatewayBaseUrl, routePortalBaseUrl));
            });
            ++routeNo;
        }
    }

    public Map<String, String> getRouteDataSourceMap() {
        return Collections.unmodifiableMap(this.routeDataSourceMap);
    }

    public Map<String, String> getRouteSolrMap() {
        return Collections.unmodifiableMap(this.routeSolrMap);
    }

    public Map<String, BaseUrlWrapper> getRouteBaseUrlMap() {
        return Collections.unmodifiableMap(this.routeBaseUrlMap);
    }

    private List<String> getHostNames(String routePath) {
        if (routePath.contains(HOSTNAME_SEPARATOR)) {
            return Arrays.asList(routePath.split("\\s*,\\s*"));
        }
        return Arrays.asList(routePath);
    }
}

