/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.web.controller;

import eu.europeana.api2.model.utils.Api2UrlService;
import eu.europeana.api2.utils.JsonUtils;
import eu.europeana.api2.utils.SolrEscape;
import eu.europeana.api2.utils.XmlUtils;
import eu.europeana.api2.v2.exceptions.DateMathParseException;
import eu.europeana.api2.v2.exceptions.InvalidParamValueException;
import eu.europeana.api2.v2.exceptions.InvalidRangeOrGapException;
import eu.europeana.api2.v2.exceptions.MissingParamException;
import eu.europeana.api2.v2.exceptions.TranslationServiceDisabledException;
import eu.europeana.api2.v2.model.GeoDistance;
import eu.europeana.api2.v2.model.SearchRequest;
import eu.europeana.api2.v2.model.enums.Profile;
import eu.europeana.api2.v2.model.json.SearchResults;
import eu.europeana.api2.v2.model.json.view.ApiView;
import eu.europeana.api2.v2.model.json.view.BriefView;
import eu.europeana.api2.v2.model.json.view.RichView;
import eu.europeana.api2.v2.model.translate.Language;
import eu.europeana.api2.v2.model.translate.MultilingualQueryGenerator;
import eu.europeana.api2.v2.model.xml.kml.KmlResponse;
import eu.europeana.api2.v2.model.xml.rss.Channel;
import eu.europeana.api2.v2.model.xml.rss.Item;
import eu.europeana.api2.v2.model.xml.rss.RssResponse;
import eu.europeana.api2.v2.service.FacetWrangler;
import eu.europeana.api2.v2.service.HitMaker;
import eu.europeana.api2.v2.service.RouteDataService;
import eu.europeana.api2.v2.service.translate.SearchResultTranslateService;
import eu.europeana.api2.v2.utils.BoostParamUtils;
import eu.europeana.api2.v2.utils.ControllerUtils;
import eu.europeana.api2.v2.utils.FacetParameterUtils;
import eu.europeana.api2.v2.utils.LanguageFilter;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.api2.v2.utils.TagUtils;
import eu.europeana.api2.v2.web.controller.BaseController;
import eu.europeana.api2.v2.web.controller.SearchController;
import eu.europeana.api2.v2.web.swagger.SwaggerIgnore;
import eu.europeana.api2.v2.web.swagger.SwaggerSelect;
import eu.europeana.corelib.definitions.edm.beans.ApiBean;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.beans.RichBean;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.edm.exceptions.SolrQueryException;
import eu.europeana.corelib.edm.utils.CountryUtils;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.utils.StringArrayUtils;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.exception.ProblemType;
import eu.europeana.corelib.web.model.rights.RightReusabilityCategorizer;
import eu.europeana.corelib.web.utils.NavigationUtils;
import eu.europeana.corelib.web.utils.RequestUtils;
import eu.europeana.indexing.solr.facet.FacetEncoder;
import eu.europeana.indexing.solr.facet.value.AudioDuration;
import eu.europeana.indexing.solr.facet.value.AudioQuality;
import eu.europeana.indexing.solr.facet.value.ImageAspectRatio;
import eu.europeana.indexing.solr.facet.value.ImageColorEncoding;
import eu.europeana.indexing.solr.facet.value.ImageColorSpace;
import eu.europeana.indexing.solr.facet.value.ImageSize;
import eu.europeana.indexing.solr.facet.value.MimeTypeEncoding;
import eu.europeana.indexing.solr.facet.value.VideoDuration;
import eu.europeana.indexing.solr.facet.value.VideoQuality;
import eu.europeana.metis.schema.model.MediaType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SwaggerSelect
@Api(tags={"Search"})
public class SearchController
extends BaseController {
    private static final Logger LOG = LogManager.getLogger(SearchController.class);
    private static final String PORTAL = "portal";
    private static final String FACETS = "facets";
    private static final String TRANSLATE = "translate";
    private static final String DEBUG = "debug";
    private static final String SPELLING = "spelling";
    private static final String BREADCRUMB = "breadcrumb";
    private static final String FACET_RANGE = "facet.range";
    private static final String HITS = "hits";
    private static final String UTF8 = "UTF-8";
    private static final Pattern COUNTRY_PATTERN = Pattern.compile("COUNTRY:\"(.*?)\"|COUNTRY:(.*?)(&|\\s|$)");
    @Resource
    private Api2UrlService urlService;
    @Resource(name="api2_mvc_xmlUtils")
    private XmlUtils xmlUtils;
    @Value(value="${api.search.rowLimit}")
    private Integer apiRowLimit;
    @Value(value="${api.search.hl.MaxAnalyzedChars}")
    private String hlMaxAnalyzedChars;
    @Value(value="#{europeanaProperties['translation.search.query']}")
    private Boolean queryTranslationEnabled;
    @Value(value="#{europeanaProperties['translation.search.results']}")
    private Boolean resultsTranslationEnabled;
    private MultilingualQueryGenerator queryGenerator;
    private SearchResultTranslateService resultTranslator;

    @Autowired
    public SearchController(RouteDataService routeService, MultilingualQueryGenerator queryGenerator, SearchResultTranslateService resultTranslator) {
        super(routeService);
        this.queryGenerator = queryGenerator;
        this.resultTranslator = resultTranslator;
    }

    @ApiOperation(value="search for records post", nickname="searchRecordsPost", response=Void.class)
    @PostMapping(value={"/api/v2/search.json", "/record/v2/search.json", "/record/search.json"}, produces={"application/json"}, consumes={"application/json"})
    public ModelAndView searchJsonPost(@RequestParam(value="wskey") String apikey, @RequestBody SearchRequest searchRequest, HttpServletRequest request, HttpServletResponse response) throws EuropeanaException {
        return this.searchJsonGet(apikey, searchRequest.getQuery(), searchRequest.getQf(), searchRequest.getReusability(), StringUtils.join((Object[])searchRequest.getProfile(), (String)","), searchRequest.getStart(), searchRequest.getRows(), searchRequest.getFacet(), searchRequest.getTheme(), StringUtils.join((Object[])searchRequest.getSort(), (String)","), searchRequest.getColourPalette(), searchRequest.isThumbnail(), searchRequest.isMedia(), searchRequest.isTextFulltext(), searchRequest.isLandingPage(), searchRequest.getCursor(), searchRequest.getCallback(), searchRequest.getHit().getFl(), searchRequest.getHit().getSelectors(), null, null, null, searchRequest.getBoost(), request, response);
    }

    @ApiOperation(value="search for records", nickname="searchRecords", response=Void.class)
    @GetMapping(value={"/api/v2/search.json", "/record/v2/search.json", "/record/search.json"}, produces={"application/json"})
    public ModelAndView searchJsonGet(@RequestParam(value="wskey") String apikey, @SolrEscape @RequestParam(value="query") String queryString, @RequestParam(value="qf", required=false) String[] refinementArray, @RequestParam(value="reusability", required=false) String[] reusabilityArray, @RequestParam(value="profile", required=false, defaultValue="standard") String profile, @RequestParam(value="start", required=false, defaultValue="1") int start, @RequestParam(value="rows", required=false, defaultValue="12") int rows, @RequestParam(value="facet", required=false) String[] mixedFacetArray, @RequestParam(value="theme", required=false) String theme, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="colourpalette", required=false) String[] colourPaletteArray, @RequestParam(value="thumbnail", required=false) Boolean thumbnail, @RequestParam(value="media", required=false) Boolean media, @RequestParam(value="text_fulltext", required=false) Boolean fullText, @RequestParam(value="landingpage", required=false) Boolean landingPage, @RequestParam(value="cursor", required=false) String cursorMark, @RequestParam(value="callback", required=false) String callback, @SolrEscape @RequestParam(value="hit.fl", required=false) String hlFl, @RequestParam(value="hit.selectors", required=false) String hlSelectors, @RequestParam(value="q.source", required=false) String querySourceLang, @RequestParam(value="q.target", required=false) String queryTargetLang, @RequestParam(value="lang", required=false) String lang, @RequestParam(value="boost", required=false) String boostParam, HttpServletRequest request, HttpServletResponse response) throws EuropeanaException {
        Set colourPaletteTags;
        boolean isTranslateProfileActive;
        this.apiKeyUtils.validateApiKey(apikey);
        if (StringUtils.isBlank((CharSequence)queryString)) {
            throw new SolrQueryException(ProblemType.SEARCH_QUERY_EMPTY);
        }
        BoostParamUtils.validateBoostParam((String)boostParam);
        List filterLanguages = null;
        if (lang != null) {
            filterLanguages = Language.validateMultiple((String)lang);
        }
        if ((isTranslateProfileActive = StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)TRANSLATE)) && (this.queryTranslationEnabled.booleanValue() && this.queryGenerator == null || this.resultsTranslationEnabled.booleanValue() && this.resultTranslator == null)) {
            throw new TranslationServiceDisabledException();
        }
        queryString = ((String)queryString).trim();
        if (StringUtils.isNotEmpty((CharSequence)boostParam)) {
            queryString = boostParam + (String)queryString;
        }
        queryString = this.fixCountryCapitalization((String)queryString);
        queryString = ((String)queryString).replace(":https://", ":http://");
        LOG.debug("ORIGINAL QUERY: |{}|", queryString);
        if (this.queryTranslationEnabled.booleanValue() && isTranslateProfileActive && StringUtils.isNotBlank((CharSequence)queryTargetLang)) {
            this.validateQueryTranslateParams(querySourceLang, queryTargetLang);
            queryString = this.queryGenerator.getMultilingualQuery((String)queryString, queryTargetLang, querySourceLang);
            LOG.debug("TRANSLATED QUERY: |{}|", queryString);
        }
        boolean isMinimalProfileActive = StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)Profile.MINIMAL.getName());
        String translateTargetLang = null;
        if (this.resultsTranslationEnabled.booleanValue() && isTranslateProfileActive && isMinimalProfileActive) {
            if (filterLanguages == null || filterLanguages.isEmpty()) {
                Language.validateSingle(null);
            }
            translateTargetLang = ((Language)filterLanguages.get(0)).name();
        }
        if (cursorMark != null && start > 1) {
            throw new SolrQueryException(ProblemType.SEARCH_START_AND_CURSOR, "Parameters 'start' and 'cursorMark' cannot be used together");
        }
        String[] qfArray = (String[])request.getParameterMap().get("qf");
        if (qfArray != null && qfArray.length != refinementArray.length) {
            refinementArray = qfArray;
        }
        if (StringUtils.isNotBlank((CharSequence)theme)) {
            if (StringUtils.containsAny((CharSequence)theme, (CharSequence)"+ #%^&*-='\"<>`!@[]{}\\/|")) {
                throw new SolrQueryException(ProblemType.SEARCH_THEME_MULTIPLE);
            }
            refinementArray = (String[])ArrayUtils.add((Object[])refinementArray, (Object)("collection:" + theme));
        }
        ArrayList colourPalette = new ArrayList();
        if (ArrayUtils.isNotEmpty((Object[])colourPaletteArray)) {
            StringArrayUtils.addToList(colourPalette, (String[])colourPaletteArray);
        }
        colourPalette.replaceAll(String::toUpperCase);
        if (!colourPalette.isEmpty() && !(colourPaletteTags = TagUtils.encodeColourPalette(colourPalette)).isEmpty()) {
            queryString = this.filterQueryBuilder(colourPaletteTags.iterator(), (String)queryString, " AND ", false);
        }
        ArrayList filterTags = new ArrayList();
        GeoDistance geoDistance = new GeoDistance();
        try {
            refinementArray = this.processQfParameters(refinementArray, media, thumbnail, fullText, landingPage, filterTags, geoDistance);
        }
        catch (InvalidParamValueException e) {
            throw new SolrQueryException(ProblemType.INVALID_PARAMETER_VALUE, e.getErrorDetails());
        }
        if (!filterTags.isEmpty()) {
            queryString = this.filterQueryBuilder(filterTags.iterator(), (String)queryString, " OR ", true);
        }
        Object[] reusabilities = StringArrayUtils.splitWebParameter((String[])reusabilityArray);
        Object[] mixedFacets = StringArrayUtils.splitWebParameter((String[])mixedFacetArray);
        boolean rangeFacetsSpecified = request.getParameterMap().containsKey(FACET_RANGE);
        boolean noFacetsSpecified = ArrayUtils.isEmpty((Object[])mixedFacets);
        boolean facetsRequested = StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)PORTAL) || StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)FACETS);
        boolean defaultFacetsRequested = facetsRequested && !rangeFacetsSpecified && (noFacetsSpecified || ArrayUtils.contains((Object[])mixedFacets, (Object)"DEFAULT"));
        boolean defaultOrReusabilityFacetsRequested = defaultFacetsRequested || facetsRequested && ArrayUtils.contains((Object[])mixedFacets, (Object)"REUSABILITY");
        Map separatedFacets = ModelUtils.separateAndLimitFacets((String[])mixedFacets, (boolean)defaultFacetsRequested);
        Object[] solrFacets = (String[])ArrayUtils.addAll((Object[])((String[])separatedFacets.get("solrfacets")), (Object[])((String[])separatedFacets.get("customfacets")));
        String[] technicalFacets = (String[])separatedFacets.get("technicalfacets");
        rows = Math.min(rows, this.apiRowLimit);
        Map valueReplacements = null;
        if (ArrayUtils.isNotEmpty((Object[])reusabilities) && null != (valueReplacements = RightReusabilityCategorizer.mapValueReplacements((String[])reusabilities, (boolean)true)) && !valueReplacements.isEmpty()) {
            refinementArray = (String[])ArrayUtils.addAll((Object[])refinementArray, (Object[])new String[]{"REUSABILITY:list"});
        }
        if (geoDistance.isInitialised()) {
            if (StringUtils.containsIgnoreCase((CharSequence)sort, (CharSequence)"distance")) {
                sort = StringUtils.replaceIgnoreCase((String)sort, (String)"distance", (String)"geodist()");
            }
        } else if (StringUtils.containsIgnoreCase((CharSequence)sort, (CharSequence)"distance")) {
            sort = RegExUtils.removePattern((String)sort, (String)"distance\\s?(asc|desc)?(\\s|,)*");
        }
        Class clazz = this.selectBean(profile);
        Query query = new Query(SearchUtils.rewriteQueryFields((String)SearchUtils.fixBuggySolrIndex((String)queryString))).setApiQuery(true).setRefinements(refinementArray).setPageSize(rows).setStart(start - 1).setSort(sort).setCurrentCursorMark(cursorMark).setParameter("facet.mincount", "1").setParameter("fl", IdBeanImpl.getFields((Class)this.getBeanImpl(clazz))).setSpellcheckAllowed(false);
        if (geoDistance.isInitialised()) {
            query.addGeoParamsToQuery(geoDistance.getSField(), geoDistance.getPoint(), geoDistance.getDistance());
        }
        if (facetsRequested) {
            Map parameterMap = request.getParameterMap();
            try {
                query.setSolrFacets((String[])solrFacets).setDefaultFacetsRequested(defaultFacetsRequested).convertAndSetSolrParameters(FacetParameterUtils.getSolrFacetParams((String)"limit", (String[])solrFacets, (Map)parameterMap, (boolean)defaultFacetsRequested)).convertAndSetSolrParameters(FacetParameterUtils.getSolrFacetParams((String)"offset", (String[])solrFacets, (Map)parameterMap, (boolean)defaultFacetsRequested)).setFacetDateRangeParameters(FacetParameterUtils.getDateRangeParams((Map)parameterMap)).setTechnicalFacets(technicalFacets).setTechnicalFacetLimits(FacetParameterUtils.getTechnicalFacetParams((String)"limit", (String[])technicalFacets, (Map)parameterMap, (boolean)defaultFacetsRequested)).setTechnicalFacetOffsets(FacetParameterUtils.getTechnicalFacetParams((String)"offset", (String[])technicalFacets, (Map)parameterMap, (boolean)defaultFacetsRequested)).setFacetsAllowed(true);
            }
            catch (DateMathParseException e) {
                String errorDetails = "Error parsing value '" + e.getParsing() + "' supplied for facet.range " + e.getWhatsParsed();
                throw new SolrQueryException(ProblemType.SEARCH_FACET_RANGE_INVALID, errorDetails);
            }
            catch (InvalidRangeOrGapException e) {
                throw new SolrQueryException(ProblemType.SEARCH_FACET_RANGE_INVALID, e.getMessage());
            }
        } else {
            query.setFacetsAllowed(false);
        }
        if (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)HITS)) {
            int nrSelectors;
            if (StringUtils.isBlank((CharSequence)hlSelectors)) {
                nrSelectors = 1;
            } else {
                try {
                    nrSelectors = Integer.parseInt(hlSelectors);
                    if (nrSelectors < 1) {
                        throw new SolrQueryException(ProblemType.SEARCH_HITSELECTOR_INVALID, "Parameter hit.selectors must be greater than 0");
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new SolrQueryException(ProblemType.SEARCH_HITSELECTOR_INVALID, "Parameter hit.selectors must be an integer");
                }
            }
            query.setParameter("hl", "on");
            query.setParameter("hl.fl", StringUtils.isBlank((CharSequence)hlFl) ? "fulltext.*" : hlFl);
            query.setNrSelectors("hl.snippets", nrSelectors);
            query.setParameter("hl.maxAnalyzedChars", this.hlMaxAnalyzedChars);
        }
        if (null != valueReplacements && !valueReplacements.isEmpty()) {
            query.setValueReplacements(valueReplacements);
        }
        if (defaultOrReusabilityFacetsRequested) {
            query.setQueryFacets(RightReusabilityCategorizer.getQueryFacets());
        }
        if (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)PORTAL) || StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)SPELLING)) {
            query.setSpellcheckAllowed(true);
        }
        if (facetsRequested && !query.hasParameter("f.DATA_PROVIDER.facet.limit") && (ArrayUtils.contains((Object[])solrFacets, (Object)"DATA_PROVIDER") || ArrayUtils.contains((Object[])solrFacets, (Object)"DEFAULT"))) {
            query.setParameter("f.DATA_PROVIDER.facet.limit", FacetParameterUtils.getLimitForDataProvider());
        }
        SearchResults result = this.createResults(apikey, profile, query, clazz, request.getServerName(), translateTargetLang, filterLanguages);
        if (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)"params")) {
            result.addParams(RequestUtils.getParameterMap((HttpServletRequest)request), new String[]{"apikey"});
            result.addParam("profile", (Object)profile);
            result.addParam("start", (Object)start);
            result.addParam("rows", (Object)rows);
            result.addParam("sort", (Object)sort);
        }
        response.setCharacterEncoding(UTF8);
        response.addHeader("Allow", "GET, HEAD, POST");
        return JsonUtils.toJson((Object)result, (String)callback);
    }

    private Language validateQueryTranslateParams(String querySourceLang, String queryTargetLang) throws EuropeanaException {
        Language result = null;
        if (queryTargetLang != null) {
            result = Language.validateSingle((String)queryTargetLang);
        }
        if (querySourceLang != null) {
            Language.validateSingle((String)querySourceLang);
            if (queryTargetLang == null) {
                throw new MissingParamException("Parameter q.target is required when q.source is specified");
            }
        }
        return result;
    }

    private String filterQueryBuilder(Iterator<Integer> it, String queryString, String andOrOr, boolean addBrackets) {
        StringBuilder filterQuery = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            filterQuery.append(queryString);
            filterQuery.append(" AND ");
        }
        if (addBrackets) {
            filterQuery.append("(");
        }
        if (it.hasNext()) {
            filterQuery.append("filter_tags:");
            filterQuery.append(it.next().toString());
        }
        while (it.hasNext()) {
            filterQuery.append(andOrOr);
            filterQuery.append("filter_tags:");
            filterQuery.append(it.next().toString());
        }
        if (addBrackets) {
            filterQuery.append(")");
        }
        return filterQuery.toString();
    }

    protected String[] processQfParameters(String[] refinementArray, Boolean media, Boolean thumbnail, Boolean fullText, Boolean landingPage, List<Integer> filterTags, GeoDistance geoDistance) throws InvalidParamValueException {
        boolean hasImageRefinements = false;
        boolean hasAudioRefinements = false;
        boolean hasVideoRefinements = false;
        boolean hasBrokenTechFacet = false;
        boolean hasGeoDistanceSearch = false;
        FacetEncoder facetEncoder = new FacetEncoder();
        ArrayList<Object> newRefinements = new ArrayList<Object>();
        HashSet imageMimeTypeRefinements = new HashSet();
        HashSet audioMimeTypeRefinements = new HashSet();
        HashSet videoMimeTypeRefinements = new HashSet();
        HashSet textMimeTypeRefinements = new HashSet();
        HashSet<ImageSize> imageSizeRefinements = new HashSet<ImageSize>();
        HashSet<ImageAspectRatio> imageAspectRatioRefinements = new HashSet<ImageAspectRatio>();
        HashSet<AudioDuration> audioDurationRefinements = new HashSet<AudioDuration>();
        HashSet<VideoDuration> videoDurationRefinements = new HashSet<VideoDuration>();
        HashSet<ImageColorSpace> imageColourSpaceRefinements = new HashSet<ImageColorSpace>();
        HashSet<VideoQuality> videoHDRefinements = new HashSet<VideoQuality>();
        HashSet<AudioQuality> audioHQRefinements = new HashSet<AudioQuality>();
        HashSet<ImageColorEncoding> imageColourPaletteRefinements = new HashSet<ImageColorEncoding>();
        if (refinementArray != null) {
            block44: for (String qf : refinementArray) {
                String refinementValue;
                if (StringUtils.contains((CharSequence)qf, (CharSequence)":")) {
                    refinementValue = StringUtils.substringAfter((String)qf, (String)":").toLowerCase(Locale.GERMAN).replaceAll("^\"|\"$", "");
                    block20 : switch (StringUtils.substringBefore((String)qf, (String)":")) {
                        case "MIME_TYPE": {
                            MimeTypeEncoding mte = MimeTypeEncoding.categorizeMimeType((String)refinementValue);
                            if (null == mte) {
                                hasBrokenTechFacet = true;
                                break;
                            }
                            switch (1.$SwitchMap$eu$europeana$metis$schema$model$MediaType[MediaType.getMediaType((String)refinementValue).ordinal()]) {
                                case 1: {
                                    CollectionUtils.addIgnoreNull(imageMimeTypeRefinements, (Object)mte);
                                    break block20;
                                }
                                case 2: {
                                    CollectionUtils.addIgnoreNull(audioMimeTypeRefinements, (Object)mte);
                                    break block20;
                                }
                                case 3: {
                                    CollectionUtils.addIgnoreNull(videoMimeTypeRefinements, (Object)mte);
                                    break block20;
                                }
                                case 4: {
                                    CollectionUtils.addIgnoreNull(textMimeTypeRefinements, (Object)mte);
                                    break block20;
                                }
                                case 5: {
                                    break block20;
                                }
                            }
                            break;
                        }
                        case "IMAGE_SIZE": {
                            ImageSize imageSize = TagUtils.getImageSize((String)refinementValue);
                            if (Objects.nonNull(imageSize)) {
                                imageSizeRefinements.add(imageSize);
                                hasImageRefinements = true;
                                break;
                            }
                            hasBrokenTechFacet = true;
                            break;
                        }
                        case "IMAGE_COLOUR": 
                        case "IMAGE_COLOR": {
                            Boolean whatYouWant = this.parseValidBoolean(refinementValue);
                            if (null == whatYouWant) {
                                hasBrokenTechFacet = true;
                                break;
                            }
                            if (whatYouWant.booleanValue()) {
                                imageColourSpaceRefinements.add(ImageColorSpace.COLOR);
                                hasImageRefinements = true;
                                break;
                            }
                            imageColourSpaceRefinements.add(ImageColorSpace.GRAYSCALE);
                            hasImageRefinements = true;
                            break;
                        }
                        case "IMAGE_GREYSCALE": 
                        case "IMAGE_GRAYSCALE": {
                            Boolean whatYouWant = this.parseValidBoolean(refinementValue);
                            if (null == whatYouWant) {
                                hasBrokenTechFacet = true;
                                break;
                            }
                            if (whatYouWant.booleanValue()) {
                                imageColourSpaceRefinements.add(ImageColorSpace.GRAYSCALE);
                                hasImageRefinements = true;
                                break;
                            }
                            imageColourSpaceRefinements.add(ImageColorSpace.COLOR);
                            hasImageRefinements = true;
                            break;
                        }
                        case "COLOURPALETTE": 
                        case "COLORPALETTE": {
                            ImageColorEncoding imageColorEncoding = ImageColorEncoding.categorizeImageColor((String)refinementValue);
                            if (Objects.nonNull(imageColorEncoding)) {
                                imageColourPaletteRefinements.add(imageColorEncoding);
                                hasImageRefinements = true;
                                break;
                            }
                            hasBrokenTechFacet = true;
                            break;
                        }
                        case "IMAGE_ASPECTRATIO": {
                            if (StringUtils.containsIgnoreCase((CharSequence)refinementValue, (CharSequence)"portrait")) {
                                imageAspectRatioRefinements.add(ImageAspectRatio.PORTRAIT);
                                hasImageRefinements = true;
                                break;
                            }
                            if (StringUtils.containsIgnoreCase((CharSequence)refinementValue, (CharSequence)"landscape")) {
                                imageAspectRatioRefinements.add(ImageAspectRatio.LANDSCAPE);
                                hasImageRefinements = true;
                                break;
                            }
                            hasBrokenTechFacet = true;
                            break;
                        }
                        case "SOUND_HQ": {
                            Boolean whatYouWant = this.parseValidBoolean(refinementValue);
                            if (null == whatYouWant) {
                                hasBrokenTechFacet = true;
                                break;
                            }
                            if (!whatYouWant.booleanValue()) continue block44;
                            audioHQRefinements.add(AudioQuality.HIGH);
                            hasAudioRefinements = true;
                            break;
                        }
                        case "SOUND_DURATION": {
                            AudioDuration audioDuration = TagUtils.getAudioDurationCode((String)refinementValue);
                            if (Objects.nonNull(audioDuration)) {
                                audioDurationRefinements.add(audioDuration);
                                hasAudioRefinements = true;
                                break;
                            }
                            hasBrokenTechFacet = true;
                            break;
                        }
                        case "VIDEO_HD": {
                            Boolean whatYouWant = this.parseValidBoolean(refinementValue);
                            if (null == whatYouWant) {
                                hasBrokenTechFacet = true;
                                break;
                            }
                            if (!whatYouWant.booleanValue()) continue block44;
                            videoHDRefinements.add(VideoQuality.HIGH);
                            hasVideoRefinements = true;
                            break;
                        }
                        case "VIDEO_DURATION": {
                            VideoDuration videoDuration = TagUtils.getVideoDurationCode((String)refinementValue);
                            if (Objects.nonNull(videoDuration)) {
                                videoDurationRefinements.add(videoDuration);
                                hasVideoRefinements = true;
                                break;
                            }
                            hasBrokenTechFacet = true;
                            break;
                        }
                        case "MEDIA": {
                            if (null != media) continue block44;
                            media = Boolean.valueOf(refinementValue);
                            break;
                        }
                        case "THUMBNAIL": {
                            if (null != thumbnail) continue block44;
                            thumbnail = Boolean.valueOf(refinementValue);
                            break;
                        }
                        case "TEXT_FULLTEXT": {
                            if (null != fullText) continue block44;
                            fullText = Boolean.valueOf(refinementValue);
                            break;
                        }
                        case "LANDINGPAGE": {
                            if (null != landingPage) continue block44;
                            landingPage = Boolean.valueOf(refinementValue);
                            break;
                        }
                        case "COUNTRY": {
                            newRefinements.add(this.fixCountryCapitalization(qf));
                            break;
                        }
                        default: {
                            newRefinements.add(qf);
                            break;
                        }
                    }
                    continue;
                }
                if (StringUtils.contains((CharSequence)qf, (CharSequence)"distance")) {
                    if (hasGeoDistanceSearch) {
                        throw new InvalidParamValueException("Only one distance query can be supplied");
                    }
                    refinementValue = StringUtils.substringAfter((String)qf, (String)"distance(").replaceAll("^\"|\"$", "").replaceAll("[\\(\\)]", "");
                    geoDistance.initialise(refinementValue);
                    if (!geoDistance.isInitialised()) continue;
                    newRefinements.add(geoDistance.getFQGeo());
                    hasGeoDistanceSearch = true;
                    continue;
                }
                newRefinements.add(qf);
            }
        }
        if (null != media) {
            newRefinements.add("has_media:" + media.toString());
        }
        if (null != thumbnail) {
            newRefinements.add("has_thumbnails:" + thumbnail.toString());
        }
        if (null != fullText) {
            newRefinements.add("is_fulltext:" + fullText.toString());
        }
        if (null != landingPage) {
            newRefinements.add("has_landingpage:" + landingPage.toString());
        }
        if (hasImageRefinements || CollectionUtils.isNotEmpty(imageMimeTypeRefinements)) {
            filterTags.addAll(facetEncoder.getImageFacetSearchCodes(imageMimeTypeRefinements, imageSizeRefinements, imageColourSpaceRefinements, imageAspectRatioRefinements, imageColourPaletteRefinements));
        }
        if (hasAudioRefinements || CollectionUtils.isNotEmpty(audioMimeTypeRefinements)) {
            filterTags.addAll(facetEncoder.getAudioFacetSearchCodes(audioMimeTypeRefinements, audioHQRefinements, audioDurationRefinements));
        }
        if (hasVideoRefinements || CollectionUtils.isNotEmpty(videoMimeTypeRefinements)) {
            filterTags.addAll(facetEncoder.getVideoFacetSearchCodes(videoMimeTypeRefinements, videoHDRefinements, videoDurationRefinements));
        }
        if (CollectionUtils.isNotEmpty(textMimeTypeRefinements)) {
            filterTags.addAll(facetEncoder.getTextFacetSearchCodes(textMimeTypeRefinements));
        }
        if (hasBrokenTechFacet && filterTags.isEmpty()) {
            filterTags.add(0);
        }
        if (LOG.isDebugEnabled()) {
            for (Integer filterTag : filterTags) {
                if (filterTag == null) continue;
                LOG.debug("filterTag = {}", (Object)Integer.toBinaryString(filterTag));
            }
        }
        return newRefinements.toArray(new String[0]);
    }

    private String fixCountryCapitalization(String queryPart) {
        String result = queryPart;
        Matcher matcher = COUNTRY_PATTERN.matcher(result);
        while (matcher.find()) {
            String countryName = matcher.group(1);
            boolean withQuotes = StringUtils.isNotEmpty((CharSequence)countryName);
            if (!withQuotes) {
                countryName = matcher.group(2);
            }
            StringBuilder s = new StringBuilder(result.substring(0, matcher.start()));
            s.append("COUNTRY:");
            if (withQuotes) {
                s.append("\"");
            }
            s.append(CountryUtils.capitalizeCountry((String)countryName));
            if (withQuotes) {
                s.append("\"");
            } else {
                s.append(matcher.group(3));
            }
            s.append(result.substring(matcher.end(), result.length()));
            result = s.toString();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Found {} at {},{}, countryName is {}", (Object)matcher.group(), (Object)matcher.start(), (Object)matcher.end(), (Object)countryName);
            LOG.debug("Converted to {}", (Object)result);
        }
        return result;
    }

    private Boolean parseValidBoolean(String value) {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)value, (CharSequence[])new CharSequence[]{"true", "false"})) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    private Class<? extends IdBean> selectBean(String profile) {
        Class clazz = StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)"minimal") ? BriefBean.class : (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)"rich") ? RichBean.class : ApiBean.class);
        return clazz;
    }

    private Class<? extends IdBeanImpl> getBeanImpl(Class clazz) {
        if (BriefBean.class.equals((Object)clazz)) {
            return BriefBeanImpl.class;
        }
        if (RichBean.class.equals((Object)clazz)) {
            return RichBeanImpl.class;
        }
        return ApiBeanImpl.class;
    }

    private <T extends IdBean> SearchResults<T> createResults(String apiKey, String profile, Query query, Class<T> clazz, String requestRoute, String translateTargetLang, List<Language> filterLanguages) throws EuropeanaException {
        List allQueryFacetsMap;
        SearchResults response = new SearchResults(apiKey);
        SolrClient solrClient = this.getSolrClient(requestRoute);
        ResultSet resultSet = StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)DEBUG) ? this.searchService.search(solrClient, clazz, query, true) : this.searchService.search(solrClient, clazz, query);
        response.totalResults = resultSet.getResultSize();
        if (StringUtils.isNotBlank((CharSequence)resultSet.getCurrentCursorMark()) && StringUtils.isNotBlank((CharSequence)resultSet.getNextCursorMark()) && !resultSet.getNextCursorMark().equalsIgnoreCase(resultSet.getCurrentCursorMark())) {
            response.nextCursor = resultSet.getNextCursorMark();
        }
        response.itemsCount = resultSet.getResults().size();
        response.items = resultSet.getResults();
        if (translateTargetLang != null) {
            this.resultTranslator.translateSearchResults(resultSet.getResults(), translateTargetLang);
        }
        if (filterLanguages != null) {
            for (IdBean result : resultSet.getResults()) {
                LanguageFilter.filter((IdBean)result, filterLanguages);
            }
        }
        ArrayList<Object> beans = new ArrayList<Object>();
        for (IdBean b : resultSet.getResults()) {
            if (b instanceof RichBean) {
                beans.add(new RichView((RichBean)b, profile, apiKey, requestRoute));
                continue;
            }
            if (b instanceof ApiBean) {
                beans.add(new ApiView((ApiBean)b, profile, apiKey, requestRoute));
                continue;
            }
            if (!(b instanceof BriefBean)) continue;
            beans.add(new BriefView((BriefBean)b, profile, apiKey, requestRoute));
        }
        List facetFields = resultSet.getFacetFields();
        if (MapUtils.isNotEmpty((Map)resultSet.getQueryFacets()) && !(allQueryFacetsMap = SearchUtils.extractQueryFacets((Map)resultSet.getQueryFacets())).isEmpty()) {
            facetFields.addAll(allQueryFacetsMap);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("results: {}", (Object)beans.size());
        }
        response.items = beans;
        if (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)FACETS) || StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)PORTAL)) {
            response.facets = new FacetWrangler().consolidateFacetList(resultSet.getFacetFields(), resultSet.getRangeFacets(), query.getTechnicalFacets(), query.isDefaultFacetsRequested(), query.getTechnicalFacetLimits(), query.getTechnicalFacetOffsets());
        }
        if (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)BREADCRUMB) || StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)PORTAL)) {
            response.breadCrumbs = NavigationUtils.createBreadCrumbList((Query)query);
        }
        if (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)HITS) && MapUtils.isNotEmpty((Map)resultSet.getHighlighting())) {
            response.hits = new HitMaker().createHitList(resultSet.getHighlighting(), query.getNrSelectors());
        }
        if (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)SPELLING) || StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)PORTAL)) {
            response.spellcheck = ModelUtils.convertSpellCheck((SpellCheckResponse)resultSet.getSpellcheck());
        }
        if (StringUtils.containsIgnoreCase((CharSequence)profile, (CharSequence)DEBUG)) {
            response.debug = resultSet.getSolrQueryString();
        }
        return response;
    }

    @SwaggerIgnore
    @GetMapping(value={"/api/v2/search.kml"}, produces={"application/vnd.google-earth.kml+xml", "application/xml", "application/xhtml+xml"})
    @ResponseBody
    @Deprecated(since="jan 2018")
    public KmlResponse searchKml(@SolrEscape @RequestParam(value="query") String queryString, @RequestParam(value="qf", required=false) String[] refinementArray, @RequestParam(value="start", required=false, defaultValue="1") int start, @RequestParam(value="wskey") String apikey, HttpServletRequest request, HttpServletResponse response) throws EuropeanaException {
        this.apiKeyUtils.validateApiKey(apikey);
        SolrClient solrClient = this.getSolrClient(request.getServerName());
        String[] qfArray = (String[])request.getParameterMap().get("qf");
        if (qfArray != null && qfArray.length != refinementArray.length) {
            refinementArray = qfArray;
        }
        KmlResponse kmlResponse = new KmlResponse();
        Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setRefinements(refinementArray).setApiQuery(true).setSpellcheckAllowed(false).setFacetsAllowed(false);
        query.setRefinements(new String[]{"pl_wgs84_pos_lat_long:[* TO *]"});
        ResultSet resultSet = this.searchService.search(solrClient, BriefBean.class, query);
        kmlResponse.document.extendedData.totalResults.value = Long.toString(resultSet.getResultSize());
        kmlResponse.document.extendedData.startIndex.value = Integer.toString(start);
        kmlResponse.setItems(resultSet.getResults());
        return kmlResponse;
    }

    @ApiOperation(value="basic search function following the OpenSearch specification", nickname="openSearch")
    @GetMapping(value={"/api/v2/opensearch.rss", "/record/v2/opensearch.rss", "/record/opensearch.rss"}, produces={"application/rss+xml", "application/xml", "application/xhtml+xml"})
    @ResponseBody
    public ModelAndView openSearchRss(@SolrEscape @RequestParam(value="searchTerms") String queryString, @RequestParam(value="startIndex", required=false, defaultValue="1") int start, @RequestParam(value="count", required=false, defaultValue="12") int count, HttpServletRequest request, HttpServletResponse response) throws EuropeanaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("openSearch query with terms: {}", (Object)queryString);
        }
        ControllerUtils.addResponseHeaders((HttpServletResponse)response);
        RssResponse rss = new RssResponse();
        Channel channel = rss.channel;
        channel.startIndex.value = start;
        channel.itemsPerPage.value = count;
        channel.query.searchTerms = queryString;
        channel.query.startPage = start;
        SolrClient solrClient = this.getSolrClient(request.getServerName());
        Query query = new Query(SearchUtils.rewriteQueryFields((String)queryString)).setApiQuery(true).setPageSize(count).setStart(start - 1).setFacetsAllowed(false).setSpellcheckAllowed(false);
        ResultSet resultSet = this.searchService.search(solrClient, BriefBean.class, query);
        channel.totalResults.value = resultSet.getResultSize();
        for (BriefBean bean : resultSet.getResults()) {
            Item item = new Item();
            item.guid = this.urlService.getRecordPortalUrl(request.getServerName(), bean.getId());
            item.title = this.getTitle(bean);
            item.description = this.getDescription(bean);
            item.link = item.guid;
            channel.items.add(item);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning rss result: {}", (Object)rss);
        }
        String xml = this.xmlUtils.toString((Object)rss);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("rss", xml);
        response.setCharacterEncoding(UTF8);
        response.setContentType("application/xml");
        return new ModelAndView("rss", model);
    }

    @SwaggerIgnore
    @GetMapping(value={"/api/v2/decodetags.json", "/api/v2/tagdecoder.json"}, produces={"application/json"})
    public ModelAndView decodeTags(@RequestParam(value="tag") String tag) {
        if (tag.matches("[0-9]+") && tag.length() > 7) {
            return JsonUtils.toJson((Object)ModelUtils.findAllFacetsInTag((Integer)Integer.valueOf(tag)));
        }
        return JsonUtils.toJson((Object)"Cannot decode this tag: it must be numerical and 8 digits long");
    }

    private String getTitle(BriefBean bean) {
        if (!ArrayUtils.isEmpty((Object[])bean.getTitle())) {
            for (String title : bean.getTitle()) {
                if (StringUtils.isBlank((CharSequence)title)) continue;
                return title;
            }
        }
        return (String)(bean.getDataProvider() == null ? "Unknown data provider " : bean.getDataProvider()[0] + " ") + bean.getId();
    }

    private String getDescription(BriefBean bean) {
        StringBuilder sb = new StringBuilder();
        if (bean.getDcCreator() != null && bean.getDcCreator().length > 0 && StringUtils.isNotBlank((CharSequence)bean.getDcCreator()[0])) {
            sb.append(bean.getDcCreator()[0]);
        }
        if (bean.getYear() != null && bean.getYear().length > 0) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(StringUtils.join((Object[])bean.getYear(), (String)", "));
        }
        if (!ArrayUtils.isEmpty((Object[])bean.getProvider())) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(StringUtils.join((Object[])bean.getProvider(), (String)", "));
        }
        return sb.toString();
    }
}

