/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import eu.europeana.api2.v2.model.translate.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class MetadataTranslationUtils {
    public static final int MAX_CONNECTIONS = 100;
    public static final int MAX_CONNECTIONS_PER_ROUTE = 100;
    public static final int TOKEN_MIN_AGE = 30000;
    public static final String MODE = "mode";
    public static final String MODE_EUROPEANA = "EUROPEANA";
    public static final String SOURCE_LANG = "src_lang";
    public static final String TARGET_LANG = "tgt_lang";
    public static final String INCLUDE_SRC = "include_src";
    public static final String TEXT = "text";
    public static final String TRANSLATIONS = "translations";
    public static final String TRANSLATE_SOURCE = "src";
    public static final String TRANSLATE_TARGET = "tgt";
    public static final String SOURCE_DETECTED = "src_detected";
    public static final String DETECTED_LANGUAGE = "detected_langs";

    private MetadataTranslationUtils() {
    }

    public static JSONObject createTranslateRequestBody(List<String> texts, String targetLanguage, String sourceLanguage, String apikey, boolean v2) throws JSONException {
        JSONObject body = new JSONObject();
        JSONArray textArray = new JSONArray();
        for (String text : texts) {
            textArray.put((Object)text);
        }
        if (v2) {
            body.put("apikey", (Object)apikey);
            body.put(MODE, (Object)MODE_EUROPEANA);
            body.put(TRANSLATE_SOURCE, (Object)textArray);
            body.put(SOURCE_LANG, (Object)sourceLanguage);
            body.put(INCLUDE_SRC, (Object)"true");
            body.put(TARGET_LANG, (Object)targetLanguage);
        } else {
            body.put(TEXT, (Object)textArray);
            if (StringUtils.isNotEmpty((CharSequence)sourceLanguage)) {
                body.put(TRANSLATE_SOURCE, (Object)sourceLanguage);
            }
            body.put(TRANSLATE_TARGET, (Object)targetLanguage);
        }
        return body;
    }

    public static JSONObject createDetectRequestBody(List<String> texts, String hint, String apikey) throws JSONException {
        JSONObject body = new JSONObject();
        JSONArray textArray = new JSONArray();
        for (String text : texts) {
            textArray.put((Object)text);
        }
        body.put("apikey", (Object)apikey);
        body.put(MODE, (Object)MODE_EUROPEANA);
        body.put(TRANSLATE_SOURCE, (Object)textArray);
        if (StringUtils.isNotEmpty((CharSequence)hint)) {
            body.put(SOURCE_LANG, (Object)hint);
        }
        return body;
    }

    public static Map<String, List<String>> getDetectedLangValueMap(List<String> texts, List<String> detectedLanguage) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        int i = 0;
        for (String langDetected : detectedLanguage) {
            if (map.containsKey(langDetected)) {
                ((List)map.get(langDetected)).add(texts.get(i));
            } else {
                map.put(langDetected, new ArrayList<String>(Arrays.asList(texts.get(i))));
            }
            ++i;
        }
        return map;
    }

    public static List<String> getResults(List<String> texts, Map<String, String> translateResult, boolean nonTranslatedDataExists) {
        ArrayList<String> translations = new ArrayList<String>();
        if (texts.size() != translateResult.size()) {
            for (String text : texts) {
                if (translateResult.containsKey(text)) {
                    translations.add(translateResult.get(text));
                    continue;
                }
                if (!nonTranslatedDataExists) continue;
                translations.add(text);
            }
        } else {
            for (Map.Entry<String, String> entry : translateResult.entrySet()) {
                translations.add(entry.getValue());
            }
        }
        return translations;
    }

    public static boolean noTranslationRequired(String lang) {
        return StringUtils.equals((CharSequence)lang, (CharSequence)"zxx") || StringUtils.equals((CharSequence)lang, (CharSequence)"def") || StringUtils.equals((CharSequence)lang, (CharSequence)Language.ENGLISH);
    }

    public static boolean nonTranslatedDataExists(List<String> detectedLanguages) {
        return detectedLanguages.contains("zxx") || detectedLanguages.contains("def") || detectedLanguages.contains(Language.ENGLISH);
    }
}

