/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api2.v2.model.translate.Language;
import eu.europeana.api2.v2.service.translate.FieldValuesLanguageMap;
import eu.europeana.api2.v2.service.translate.PangeanicV2TranslationService;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.api2.v2.service.translate.TranslationUtils;
import eu.europeana.api2.v2.service.translate.TranslationsMap;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.entity.ContextualClass;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import eu.europeana.corelib.web.exception.EuropeanaException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class RecordTranslateService {
    private static final Logger LOG = LogManager.getLogger(RecordTranslateService.class);
    private static final Set<String> EXCLUDE_PROXY_MAP_FIELDS = Set.of("dcLanguage", "year", "userTags", "edmRights");
    private static final List<String> ENTITIES = List.of("agents", "concepts", "places", "timespans");
    private final TranslationService translationService;

    public RecordTranslateService(TranslationService translationService) {
        this.translationService = translationService;
    }

    public List<Language> getDefaultTranslationLanguage(FullBean bean) {
        ArrayList<Language> lang = new ArrayList<Language>();
        Map edmLanguage = bean.getEuropeanaAggregation().getEdmLanguage();
        for (Map.Entry entry : edmLanguage.entrySet()) {
            for (String languageAbbreviation : (List)entry.getValue()) {
                if (Language.isSupported((String)languageAbbreviation)) {
                    lang.add(Language.getLanguage((String)languageAbbreviation));
                    continue;
                }
                LOG.warn("edm:language '{}' is not supported for default translation and filtering ", (Object)languageAbbreviation);
            }
        }
        if (!lang.isEmpty()) {
            LOG.debug("Default translation and filtering applied for language : {} ", lang);
        }
        return lang;
    }

    private Language getHintForLangDetect(FullBean bean) {
        List defaultTranslationLanguage = this.getDefaultTranslationLanguage(bean);
        if (!defaultTranslationLanguage.isEmpty()) {
            return (Language)defaultTranslationLanguage.get(0);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.translationService != null;
    }

    public FullBean translateProxyFields(FullBean bean, List<Language> targetLangs) throws EuropeanaException {
        long startTime = System.currentTimeMillis();
        String targetLang = targetLangs.get(0).name().toLowerCase(Locale.ROOT);
        TranslationsMap textsToTranslate = new TranslationsMap(this.getProxyFieldsToTranslate(bean, targetLang));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translate - Gathering data took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        long startTimeTranslate = System.currentTimeMillis();
        Language edmLang = null;
        if (this.translationService.getClass().equals(PangeanicV2TranslationService.class)) {
            edmLang = this.getHintForLangDetect(bean);
        }
        if (!textsToTranslate.isEmpty()) {
            LOG.info("Translate - record {}", (Object)bean.getAbout());
        }
        FieldValuesLanguageMap translations = textsToTranslate.translate(this.translationService, targetLang, edmLang);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translate - Send/receive translation request took {} ms", (Object)(System.currentTimeMillis() - startTimeTranslate));
        }
        long startTimeOutput = System.currentTimeMillis();
        for (Map.Entry entry : translations.entrySet()) {
            this.generateTranslatedField(bean, (String)entry.getKey(), targetLang, (List)entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translate - Generating output took {} ms", (Object)(System.currentTimeMillis() - startTimeOutput));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translate - Total time {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return bean;
    }

    private List<FieldValuesLanguageMap> getProxyFieldsToTranslate(FullBean bean, String targetLang) {
        ArrayList<FieldValuesLanguageMap> result = new ArrayList<FieldValuesLanguageMap>();
        ArrayList proxies = new ArrayList(bean.getProxies());
        if (proxies.size() < 2) {
            LOG.error("Unexpected data - expected at least 2 proxies, but found only {}!", (Object)proxies.size());
            return result;
        }
        Proxy europeanaProxy = (Proxy)proxies.remove(0);
        if (!europeanaProxy.isEuropeanaProxy()) {
            LOG.error("Unexpected data - first proxy is not Europeana proxy!");
            return result;
        }
        Proxy mainProxy = (Proxy)proxies.get(0);
        boolean moreThanOneProxy = proxies.size() > 1;
        ReflectionUtils.FieldFilter proxyFieldFilter = field -> field.getType().isAssignableFrom(Map.class) && !EXCLUDE_PROXY_MAP_FIELDS.contains(field.getName());
        ReflectionUtils.doWithFields(mainProxy.getClass(), field -> {
            boolean hasStaticTranslation = moreThanOneProxy && this.hasStaticTranslations(mainProxy, field);
            LOG.trace("Processing field {}, hasStaticTranslation {}...", (Object)field.getName(), (Object)hasStaticTranslation);
            List toTranslate = this.getProxyFieldToTranslate(proxies, field, hasStaticTranslation, targetLang);
            if (!toTranslate.isEmpty()) {
                for (FieldValuesLanguageMap map : toTranslate) {
                    result.addAll(this.checkValuesForUris(bean, map, hasStaticTranslation, targetLang));
                }
            }
        }, (ReflectionUtils.FieldFilter)proxyFieldFilter);
        return result;
    }

    boolean hasStaticTranslations(Proxy aggregatorProxy, Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        Object o = ReflectionUtils.getField((Field)field, (Object)aggregatorProxy);
        if (o instanceof Map) {
            Map map = (Map)o;
            return map.keySet().size() > 1 || map.keySet().size() == 1 && !"def".equals(map.get(0));
        }
        return false;
    }

    private List<FieldValuesLanguageMap> getProxyFieldToTranslate(List<Proxy> proxies, Field field, boolean hasStaticTranslations, String targetLang) {
        List result = this.getProxyValueForLang(proxies, field, targetLang, true);
        if (!result.isEmpty()) {
            if (result.size() > 1 && ((FieldValuesLanguageMap)result.get(1)).getSourceLanguage().equals("def")) {
                LOG.debug("  Found uri value in def for {},translation needed", (Object)field.getName());
                return Collections.singletonList((FieldValuesLanguageMap)result.get(1));
            }
            LOG.debug("  Found value with target language for {}, no translation needed", (Object)field.getName());
            return Collections.emptyList();
        }
        if (!Language.ENGLISH.equals(targetLang)) {
            result = this.getProxyValueForLang(proxies, field, Language.ENGLISH, true);
        }
        if (result.isEmpty() && !hasStaticTranslations && (result = this.getProxyValueForLang(proxies, field, "def", false)).isEmpty()) {
            result = this.getProxyValueForLang(proxies, field, null, false);
        }
        if (result.isEmpty()) {
            LOG.trace("  Found no values for field {}", (Object)field.getName());
        } else {
            LOG.debug("  Found value for field {} with {} language", (Object)field.getName(), (Object)((FieldValuesLanguageMap)result.get(0)).getSourceLanguage());
        }
        return result;
    }

    private List<FieldValuesLanguageMap> getProxyValueForLang(List<Proxy> proxies, Field field, String lang, boolean checkForUriInDef) {
        List<Object> result = new ArrayList<FieldValuesLanguageMap>();
        for (Proxy proxy : proxies) {
            ReflectionUtils.makeAccessible((Field)field);
            Object value = ReflectionUtils.getField((Field)field, (Object)proxy);
            if (value instanceof Map) {
                HashMap origFieldData = (HashMap)value;
                result = this.getValueFromLanguageMap((Map)((Object)SerializationUtils.clone((Serializable)origFieldData)), field.getName(), lang, checkForUriInDef);
            } else if (value != null) {
                LOG.warn("Unexpected data - field {} did not return a map", (Object)field.getName());
            }
            if (result.isEmpty()) continue;
            break;
        }
        return result;
    }

    private List<FieldValuesLanguageMap> getValueFromLanguageMap(Map<String, List<String>> map, String fieldName, String lang, boolean checkForUriInDef) {
        if (lang == null && !map.keySet().isEmpty()) {
            for (String key2 : map.keySet()) {
                if (Language.isSupported((String)key2)) {
                    return Collections.singletonList(new FieldValuesLanguageMap(Language.getLanguage((String)key2).name().toLowerCase(Locale.ROOT), fieldName, map.get(key2)));
                }
                LOG.debug("  Found value for field {} in unsupported language {}", (Object)fieldName, (Object)key2);
            }
        } else if (lang != null && (map.containsKey(lang) || map.keySet().stream().anyMatch(key -> key.startsWith(lang)))) {
            return this.getValuesFromLanguageMap(map, fieldName, lang, checkForUriInDef);
        }
        return Collections.emptyList();
    }

    private List<FieldValuesLanguageMap> getValuesFromLanguageMap(Map<String, List<String>> map, String fieldName, String lang, boolean checkForUriInDef) {
        FieldValuesLanguageMap defMapWithUriValues;
        List valuesToTranslate = TranslationUtils.getValuesToTranslateFromMultilingualMap(map, (String)lang);
        FieldValuesLanguageMap valueMap = new FieldValuesLanguageMap(lang, fieldName, valuesToTranslate);
        if (checkForUriInDef && map.containsKey("def") && (defMapWithUriValues = this.getUriValuesFromDef(map.get("def"), fieldName)) != null) {
            LOG.debug("  Found uri for field {} in def tag for language {}", (Object)fieldName, (Object)lang);
            return Arrays.asList(valueMap, defMapWithUriValues);
        }
        return Collections.singletonList(valueMap);
    }

    private FieldValuesLanguageMap getUriValuesFromDef(List<String> valuesToCheck, String fieldName) {
        ArrayList<String> valuesToTranslate = new ArrayList<String>();
        for (String value : valuesToCheck) {
            if (!EuropeanaUriUtils.isUri((String)value)) continue;
            valuesToTranslate.add(value);
        }
        if (!valuesToTranslate.isEmpty()) {
            return new FieldValuesLanguageMap("def", fieldName, valuesToTranslate);
        }
        return null;
    }

    private List<FieldValuesLanguageMap> checkValuesForUris(FullBean bean, FieldValuesLanguageMap map, boolean hasStaticTranslation, String targetLang) {
        if (map.keySet().size() != 1) {
            throw new IllegalArgumentException("Resolving uri's is only supported for maps with 1 key");
        }
        String field = (String)map.keySet().iterator().next();
        List valuesToCheck = (List)map.get((Object)field);
        ArrayList<String> urisToRemove = new ArrayList<String>();
        ArrayList<FieldValuesLanguageMap> prefLabelsToTranslate = new ArrayList<FieldValuesLanguageMap>();
        for (Object value : valuesToCheck) {
            if (!EuropeanaUriUtils.isUri((String)value)) continue;
            urisToRemove.add((String)value);
            if (hasStaticTranslation) {
                LOG.debug("Removing uri {}...", value);
                continue;
            }
            LOG.debug("Checking uri {}...", value);
            ContextualClass entity = this.findEntity(bean, (String)value);
            if (entity == null) {
                LOG.debug("  No entity found");
                continue;
            }
            FieldValuesLanguageMap prefLabel = this.getEntityPrefLabel(entity, field, targetLang);
            if (prefLabel == null) {
                LOG.debug("  Entity found, but no preflabel to translate");
                continue;
            }
            LOG.debug("  Entity found, adding prefLabel with {} language to translate", (Object)prefLabel.getSourceLanguage());
            prefLabelsToTranslate.add(prefLabel);
        }
        map.remove(field, urisToRemove);
        ArrayList<FieldValuesLanguageMap> result = new ArrayList<FieldValuesLanguageMap>();
        for (FieldValuesLanguageMap prefLabelMap : prefLabelsToTranslate) {
            if (prefLabelMap.getSourceLanguage().equals(map.getSourceLanguage())) {
                map.merge(prefLabelMap);
                continue;
            }
            result.add(prefLabelMap);
        }
        List originalValues = (List)map.get((Object)field);
        if (!originalValues.isEmpty()) {
            result.add(0, map);
        }
        return result;
    }

    private ContextualClass findEntity(FullBean bean, String uri) {
        ArrayList result = new ArrayList();
        ReflectionUtils.FieldFilter entityFilter = field -> ENTITIES.contains(field.getName()) && result.isEmpty();
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            Object o = ReflectionUtils.getField((Field)field, (Object)bean);
            LOG.trace("Searching for entities with type {}...", (Object)field.getName());
            if (o instanceof List) {
                List entities = (List)o;
                for (ContextualClass entity : entities) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)uri, (CharSequence)entity.getAbout())) continue;
                    LOG.debug("  Found matching entity {}", (Object)entity.getAbout());
                    result.add(entity);
                    break;
                }
            }
        }, (ReflectionUtils.FieldFilter)entityFilter);
        if (result.isEmpty()) {
            return null;
        }
        return (ContextualClass)result.get(0);
    }

    private FieldValuesLanguageMap getEntityPrefLabel(ContextualClass entity, String fieldName, String targetLang) {
        FieldValuesLanguageMap entityPrefLabel = null;
        Map prefLabels = entity.getPrefLabel();
        if (prefLabels == null) {
            LOG.debug("  Entity {} has no prefLabels", (Object)entity.getAbout());
            return null;
        }
        List result = this.getValueFromLanguageMap(prefLabels, entity.getAbout(), targetLang, false);
        if (!result.isEmpty()) {
            LOG.debug("  Found prefLabel with target language for {}, no translation needed", (Object)entity.getAbout());
            return null;
        }
        if (!Language.ENGLISH.equals(targetLang)) {
            result = this.getValueFromLanguageMap(prefLabels, entity.getAbout(), Language.ENGLISH, false);
        }
        if (result.isEmpty() && (result = this.getValueFromLanguageMap(prefLabels, entity.getAbout(), "def", false)).isEmpty()) {
            result = this.getValueFromLanguageMap(prefLabels, entity.getAbout(), null, false);
        }
        if (result.isEmpty()) {
            LOG.debug("  Found no preflabels for {}", (Object)entity.getAbout());
        } else {
            entityPrefLabel = (FieldValuesLanguageMap)result.get(0);
            LOG.debug("  Found preflabel with language {} for {} ", (Object)entityPrefLabel.getSourceLanguage(), (Object)entity.getAbout());
            entityPrefLabel.put(fieldName, entityPrefLabel.remove(entity.getAbout()));
        }
        return entityPrefLabel;
    }

    private void generateTranslatedField(FullBean bean, String key, String lang, List<String> values) {
        Proxy proxy = (Proxy)bean.getProxies().get(0);
        if (proxy == null || !proxy.isEuropeanaProxy()) {
            LOG.error("First proxy of record {} is not an EuropeanaProxy!", (Object)bean.getAbout());
            return;
        }
        TranslationUtils.addTranslationsToObject((Object)proxy, (String)key, (String)lang, values);
    }
}

