/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api2.v2.exceptions.TranslationException;
import eu.europeana.api2.v2.model.translate.Language;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.api2.v2.utils.MetadataTranslationUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Service;

@Service
@PropertySources(value={@PropertySource(value={"classpath:europeana.properties"}), @PropertySource(value={"classpath:europeana.user.properties"}, ignoreResourceNotFound=true)})
public class PangeanicV2TranslationService
implements TranslationService {
    private static final Logger LOG = LogManager.getLogger(PangeanicV2TranslationService.class);
    @Value(value="${translation.pangeanic.endpoint.translate:}")
    private String translateEndpoint;
    @Value(value="${translation.pangeanic.endpoint.detect:}")
    private String detectEndpoint;
    private CloseableHttpClient translateClient;

    @PostConstruct
    private void init() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(100);
        this.translateClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        LOG.info("Pangeanic translation service is initialized. Translate Endpoint is {}. Detect language Endpoint is {}", (Object)this.translateEndpoint, (Object)this.detectEndpoint);
    }

    public List<String> translate(List<String> texts, String targetLanguage, Language sourceLangHint) throws TranslationException {
        String hint = sourceLangHint != null ? sourceLangHint.name().toLowerCase(Locale.ROOT) : null;
        return this.translateWithLangDetect(texts, targetLanguage, hint);
    }

    public List<String> translate(List<String> texts, String targetLanguage, String sourceLanguage) throws TranslationException {
        try {
            HttpPost post = this.createTranslateRequest(texts, targetLanguage, sourceLanguage, "");
            return MetadataTranslationUtils.getResults(texts, (Map)this.sendTranslateRequestAndParse(post), (boolean)false);
        }
        catch (IOException | JSONException e) {
            throw new TranslationException((Exception)e);
        }
    }

    private List<String> translateWithLangDetect(List<String> texts, String targetLanguage, String hint) throws TranslationException {
        try {
            HttpPost post = this.createDetectlanguageRequest(texts, hint, "");
            List detectedLanguages = this.sendDetectRequestAndParse(post);
            Map detectedLangValueMap = MetadataTranslationUtils.getDetectedLangValueMap(texts, (List)detectedLanguages);
            LOG.debug("Pangeanic detect lang request with hint {} is executed. Detected languages are {} ", (Object)hint, detectedLangValueMap.keySet());
            LinkedHashMap translations = new LinkedHashMap();
            for (Map.Entry entry : detectedLangValueMap.entrySet()) {
                if (MetadataTranslationUtils.noTranslationRequired((String)((String)entry.getKey()))) {
                    if (((String)entry.getKey()).equals("def")) {
                        LOG.debug("NOT translating data for empty lang detected values {} ", entry.getValue());
                        continue;
                    }
                    LOG.debug("NOT translating data for lang '{}' and values {} ", entry.getKey(), entry.getValue());
                    continue;
                }
                HttpPost translateRequest = this.createTranslateRequest((List)entry.getValue(), targetLanguage, (String)entry.getKey(), "");
                translations.putAll(this.sendTranslateRequestAndParse(translateRequest));
            }
            return MetadataTranslationUtils.getResults(texts, translations, (boolean)MetadataTranslationUtils.nonTranslatedDataExists((List)detectedLanguages));
        }
        catch (IOException | JSONException e) {
            throw new TranslationException((Exception)e);
        }
    }

    private HttpPost createTranslateRequest(List<String> texts, String targetLanguage, String sourceLanguage, String apikey) throws JSONException {
        HttpPost post = new HttpPost(this.translateEndpoint);
        JSONObject body = MetadataTranslationUtils.createTranslateRequestBody(texts, (String)targetLanguage, (String)sourceLanguage, (String)apikey, (boolean)true);
        post.setEntity((HttpEntity)new StringEntity(body.toString(), StandardCharsets.UTF_8));
        post.setHeader("Accept", "application/json");
        post.setHeader("Content-Type", "application/json");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending POST {}", (Object)post.getURI());
            LOG.trace("  body {}", (Object)body);
            LOG.trace("  headers:");
            for (Header header : post.getAllHeaders()) {
                LOG.trace("  {}: {}", (Object)header.getName(), (Object)header.getValue());
            }
        }
        return post;
    }

    private HttpPost createDetectlanguageRequest(List<String> texts, String hint, String apikey) throws JSONException {
        HttpPost post = new HttpPost(this.detectEndpoint);
        JSONObject body = MetadataTranslationUtils.createDetectRequestBody(texts, (String)hint, (String)apikey);
        post.setEntity((HttpEntity)new StringEntity(body.toString(), StandardCharsets.UTF_8));
        post.setHeader("Accept", "application/json");
        post.setHeader("Content-Type", "application/json");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending POST {}", (Object)post.getURI());
            LOG.trace("  body {}", (Object)body);
            LOG.trace("  headers:");
            for (Header header : post.getAllHeaders()) {
                LOG.trace("  {}: {}", (Object)header.getName(), (Object)header.getValue());
            }
        }
        return post;
    }

    private Map<String, String> sendTranslateRequestAndParse(HttpPost post) throws IOException, JSONException, TranslationException {
        try (CloseableHttpResponse response = this.translateClient.execute((HttpUriRequest)post);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Error from Pangeanic Translation API: " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject obj = new JSONObject(json);
            LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
            if (!obj.has("translations")) {
                throw new TranslationException("Pangeanic Translation API returned empty response");
            }
            JSONArray translations = obj.getJSONArray("translations");
            for (int i = 0; i < translations.length(); ++i) {
                JSONObject object = (JSONObject)((JSONArray)translations.get(i)).get(0);
                results.put(object.getString("src"), object.getString("tgt"));
            }
            if (results.isEmpty()) {
                throw new TranslationException("Translation failed for source language - " + obj.get("src_lang"));
            }
            LinkedHashMap<String, String> linkedHashMap = results;
            return linkedHashMap;
        }
    }

    public List<String> sendDetectRequestAndParse(HttpPost post) throws IOException, JSONException, TranslationException {
        try (CloseableHttpResponse response = this.translateClient.execute((HttpUriRequest)post);){
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Error from Pangeanic Translation API: " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            if (json.isEmpty()) {
                throw new TranslationException("Language detect returned an empty response");
            }
            JSONObject obj = new JSONObject(json);
            ArrayList<String> result = new ArrayList<String>();
            JSONArray detectedLangs = obj.getJSONArray("detected_langs");
            for (int i = 0; i < detectedLangs.length(); ++i) {
                JSONObject object = (JSONObject)detectedLangs.get(i);
                if (object.has("src_detected")) {
                    result.add(object.getString("src_detected"));
                    continue;
                }
                result.add("def");
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    public void close() {
        if (this.translateClient != null) {
            try {
                this.translateClient.close();
            }
            catch (IOException e) {
                LOG.error("Error closing connection to Pangeanic Translation API", (Throwable)e);
            }
        }
    }
}

