/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import eu.europeana.api2.v2.service.translate.FieldValuesLanguageMap;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.api2.v2.service.translate.TranslationUtils;
import eu.europeana.corelib.web.exception.EuropeanaException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TranslationsMap
extends LinkedHashMap<String, FieldValuesLanguageMap> {
    private static final long serialVersionUID = 3953283538425288592L;

    public TranslationsMap(List<FieldValuesLanguageMap> textsToTranslate) {
        this.addAll(textsToTranslate);
    }

    private void add(FieldValuesLanguageMap mapToAdd) {
        if (mapToAdd != null) {
            if (this.containsKey((Object)mapToAdd.getSourceLanguage())) {
                FieldValuesLanguageMap existingMap = (FieldValuesLanguageMap)this.get((Object)mapToAdd.getSourceLanguage());
                for (Map.Entry entry : mapToAdd.entrySet()) {
                    if (existingMap.containsKey(entry.getKey())) {
                        existingMap.merge(new FieldValuesLanguageMap(mapToAdd.getSourceLanguage(), (String)entry.getKey(), (List)entry.getValue()));
                        continue;
                    }
                    existingMap.put((String)entry.getKey(), (List)entry.getValue());
                }
            } else {
                this.put((Object)mapToAdd.getSourceLanguage(), (Object)mapToAdd);
            }
        }
    }

    private void addAll(List<FieldValuesLanguageMap> maps) {
        for (FieldValuesLanguageMap map : maps) {
            this.add(map);
        }
    }

    public FieldValuesLanguageMap translate(TranslationService translationService, String targetLanguage) throws EuropeanaException {
        ArrayList<FieldValuesLanguageMap> translations = new ArrayList<FieldValuesLanguageMap>();
        long nrCharacters = 0L;
        for (FieldValuesLanguageMap mapToTranslate : this.values()) {
            nrCharacters += mapToTranslate.getNrCharacters();
            if (mapToTranslate.getSourceLanguage().equals("def")) {
                FieldValuesLanguageMap translatedDefMap = TranslationUtils.removeIfOriginalIsSameAsTranslated((FieldValuesLanguageMap)TranslationUtils.translate((TranslationService)translationService, (FieldValuesLanguageMap)mapToTranslate, (String)targetLanguage), (FieldValuesLanguageMap)mapToTranslate);
                if (translatedDefMap == null) continue;
                translations.add(translatedDefMap);
                continue;
            }
            translations.add(TranslationUtils.translate((TranslationService)translationService, (FieldValuesLanguageMap)mapToTranslate, (String)targetLanguage));
        }
        FieldValuesLanguageMap result = new FieldValuesLanguageMap(targetLanguage);
        for (FieldValuesLanguageMap translation : translations) {
            result.merge(translation);
        }
        return result;
    }
}

