/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.service.translate;

import com.google.api.gax.rpc.ResourceExhaustedException;
import eu.europeana.api2.v2.exceptions.TranslationException;
import eu.europeana.api2.v2.exceptions.TranslationServiceLimitException;
import eu.europeana.api2.v2.service.translate.FieldValuesLanguageMap;
import eu.europeana.api2.v2.service.translate.TranslationService;
import eu.europeana.corelib.utils.ComparatorUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TranslationUtils {
    public static final String FIELD_NAME_INDEX_SEPARATOR = ".";
    public static final String FIELD_NAME_INDEX_REGEX = "\\.";
    private static final Logger LOG = LogManager.getLogger(TranslationUtils.class);

    private TranslationUtils() {
    }

    public static FieldValuesLanguageMap translate(TranslationService translationService, FieldValuesLanguageMap toTranslate, String targetLanguage) throws TranslationException, TranslationServiceLimitException {
        List translations;
        LinkedHashMap<String, Integer> linesPerField = new LinkedHashMap<String, Integer>();
        ArrayList linesToTranslate = new ArrayList();
        for (Map.Entry entry : toTranslate.entrySet()) {
            List lines = (List)entry.getValue();
            linesPerField.put((String)entry.getKey(), lines.size());
            linesToTranslate.addAll(lines);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Key {}, values to translate {}", entry.getKey(), (Object)lines);
        }
        try {
            if ("def".equals(toTranslate.getSourceLanguage())) {
                LOG.debug("Sending translate query with language detect...");
                translations = translationService.translate(linesToTranslate, targetLanguage);
            } else {
                LOG.debug("Sending translate query with source language {} and target language {}...", (Object)toTranslate.getSourceLanguage(), (Object)targetLanguage);
                translations = translationService.translate(linesToTranslate, targetLanguage, toTranslate.getSourceLanguage());
            }
        }
        catch (ResourceExhaustedException e) {
            throw new TranslationServiceLimitException((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw new TranslationException((Exception)e);
        }
        if (translations.size() != linesToTranslate.size()) {
            throw new IllegalStateException("Expected " + linesToTranslate.size() + " lines of translated text, but received " + translations.size());
        }
        FieldValuesLanguageMap result = new FieldValuesLanguageMap(targetLanguage);
        int counter = 0;
        for (String key : toTranslate.keySet()) {
            int nrLines = (Integer)linesPerField.get(key);
            if (nrLines == 0) {
                result.put(key, null);
            } else {
                result.put(key, translations.subList(counter, counter + nrLines));
            }
            counter += nrLines;
        }
        return result;
    }

    public static FieldValuesLanguageMap removeIfOriginalIsSameAsTranslated(FieldValuesLanguageMap translatedMap, FieldValuesLanguageMap mapToTranslate) {
        HashMap actualTranslationMap = new HashMap();
        for (Map.Entry translated : translatedMap.entrySet()) {
            ArrayList<String> actualTranslatedValues = new ArrayList<String>();
            for (int i = 0; i < ((List)translated.getValue()).size(); ++i) {
                String origValue = (String)((List)mapToTranslate.get(translated.getKey())).get(i);
                if (!ComparatorUtils.sameValueWithoutSpace((String)origValue, (String)((String)((List)translated.getValue()).get(i)))) {
                    actualTranslatedValues.add((String)((List)translated.getValue()).get(i));
                    continue;
                }
                LOG.debug("Skipping translated def value as it's the same as original: {}", (Object)origValue);
            }
            if (actualTranslatedValues.isEmpty()) continue;
            actualTranslationMap.put((String)translated.getKey(), actualTranslatedValues);
        }
        if (!actualTranslationMap.isEmpty()) {
            return new FieldValuesLanguageMap(translatedMap.getSourceLanguage(), actualTranslationMap);
        }
        return null;
    }

    public static List<String> getValuesToTranslateFromMultilingualMap(Map<String, List<String>> map, String lang) {
        List valuesToTranslate = map.get(lang);
        if (valuesToTranslate == null || valuesToTranslate.isEmpty()) {
            valuesToTranslate = map.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(lang)).map(Map.Entry::getValue).findFirst().orElse(null);
        }
        return valuesToTranslate;
    }

    public static void addTranslationsToObject(Object object, String fieldName, String lang, List<String> values) {
        Field field = ReflectionUtils.findField(object.getClass(), (String)fieldName);
        if (field == null) {
            LOG.error("Cannot find field with name {} in object {}", (Object)fieldName, (Object)object.getClass().getSimpleName());
        } else {
            ReflectionUtils.makeAccessible((Field)field);
            Object o = ReflectionUtils.getField((Field)field, (Object)object);
            if (o instanceof Map) {
                Map map = (Map)o;
                if (map.containsKey(lang)) {
                    LOG.error("Object {} already has values for field {} and language {}!", object.getClass(), (Object)fieldName, (Object)lang);
                } else {
                    LOG.trace("Adding to field {}, key {} and value {}", (Object)fieldName, (Object)lang, values);
                    map.put(lang, values);
                }
            } else {
                LinkedHashMap<String, List<String>> newMap = new LinkedHashMap<String, List<String>>();
                newMap.put(lang, values);
                ReflectionUtils.setField((Field)field, (Object)object, newMap);
            }
        }
    }

    public static void addTranslationsToList(List list, String fieldName, String solrKeyName, List<String> values) {
        try {
            LOG.trace("   add fieldName = {}, solrKeyname = {}, values = {}", (Object)fieldName, (Object)solrKeyName, values);
            String[] parts = fieldName.split("\\.");
            int index = Integer.valueOf(parts[0]);
            String fName = parts[1];
            TranslationUtils.addTranslationsToObject(list.get(index), (String)fName, (String)solrKeyName, values);
        }
        catch (RuntimeException e) {
            LOG.warn("Error reading fieldName {}. Unable to add translation for it.", (Object)fieldName, (Object)e);
        }
    }
}

