/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.europeana.api2.v2.model.FacetTag;
import eu.europeana.api2.v2.model.json.common.LabelFrequency;
import eu.europeana.api2.v2.model.json.view.submodel.SpellCheck;
import eu.europeana.api2.v2.utils.ModelUtils;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.entity.Aggregation;
import eu.europeana.corelib.definitions.solr.SolrFacetType;
import eu.europeana.corelib.definitions.solr.TechnicalFacetType;
import eu.europeana.indexing.solr.facet.EncodedFacet;
import eu.europeana.indexing.solr.facet.value.AudioDuration;
import eu.europeana.indexing.solr.facet.value.AudioQuality;
import eu.europeana.indexing.solr.facet.value.ImageAspectRatio;
import eu.europeana.indexing.solr.facet.value.ImageColorEncoding;
import eu.europeana.indexing.solr.facet.value.ImageColorSpace;
import eu.europeana.indexing.solr.facet.value.ImageSize;
import eu.europeana.indexing.solr.facet.value.MediaTypeEncoding;
import eu.europeana.indexing.solr.facet.value.MimeTypeEncoding;
import eu.europeana.indexing.solr.facet.value.VideoDuration;
import eu.europeana.indexing.solr.facet.value.VideoQuality;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.response.SpellCheckResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelUtils {
    private static final Logger LOG = LogManager.getLogger(ModelUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String TECHNICALFACETS = "technicalfacets";
    private static final String SOLRFACETS = "solrfacets";
    private static final String CUSTOMFACETS = "customfacets";
    private static final String DEFAULT = "DEFAULT";
    private static final String JSONLD_GRAPH = "@graph";
    private static final String JSONLD_TYPE = "@type";
    private static final String JSONLD_AGGREGATION_RDF_TYPE = "ore:Aggregation";
    private static final String JSONLD_EDM_HAS_VIEW = "edm:hasView";
    private static final String JSONLD_RDF_ID = "@id";
    private static final int FACET_LIMIT = 150;
    private static final List<String> technicalFacetList = new ArrayList();
    private static final List<String> solrFacetList = new ArrayList();
    private static final List<String> enumFacetList = new ArrayList();

    private ModelUtils() {
    }

    public static FacetTag decodeFacetTag(Integer tag) {
        MediaTypeEncoding mediaType = (MediaTypeEncoding)EncodedFacet.MEDIA_TYPE.decodeValue(tag.intValue());
        MimeTypeEncoding mimeType = (MimeTypeEncoding)EncodedFacet.MIME_TYPE.decodeValue(tag.intValue());
        if (mimeType != null) {
            return new FacetTag("MIME_TYPE", mimeType.getValue());
        }
        switch (1.$SwitchMap$eu$europeana$indexing$solr$facet$value$MediaTypeEncoding[mediaType.ordinal()]) {
            case 1: {
                ImageAspectRatio imageAspectRatio = (ImageAspectRatio)EncodedFacet.IMAGE_ASPECT_RATIO.decodeValue(tag.intValue());
                if (imageAspectRatio != null) {
                    return new FacetTag("IMAGE_ASPECTRATIO", imageAspectRatio.toString());
                }
                ImageColorEncoding imageColorEncoding = (ImageColorEncoding)EncodedFacet.IMAGE_COLOR_ENCODING.decodeValue(tag.intValue());
                if (imageColorEncoding != null) {
                    return new FacetTag("COLOURPALETTE", imageColorEncoding.getHexStringWithHash());
                }
                ImageColorSpace imageColorSpace = (ImageColorSpace)EncodedFacet.IMAGE_COLOR_SPACE.decodeValue(tag.intValue());
                if (imageColorSpace != null) {
                    return new FacetTag("IMAGE_COLOUR", imageColorSpace.toString());
                }
                ImageSize imageSize = (ImageSize)EncodedFacet.IMAGE_SIZE.decodeValue(tag.intValue());
                if (imageSize != null) {
                    return new FacetTag("IMAGE_SIZE", imageSize.toString());
                }
                return new FacetTag("", "");
            }
            case 2: {
                AudioDuration audioDuration = (AudioDuration)EncodedFacet.AUDIO_DURATION.decodeValue(tag.intValue());
                if (audioDuration != null) {
                    return new FacetTag("SOUND_DURATION", audioDuration.toString());
                }
                AudioQuality audioQuality = (AudioQuality)EncodedFacet.AUDIO_QUALITY.decodeValue(tag.intValue());
                if (audioQuality != null) {
                    return new FacetTag("SOUND_HQ", audioQuality.toString());
                }
                return new FacetTag("", "");
            }
            case 3: {
                VideoDuration videoDuration = (VideoDuration)EncodedFacet.VIDEO_DURATION.decodeValue(tag.intValue());
                if (videoDuration != null) {
                    return new FacetTag("VIDEO_DURATION", videoDuration.toString());
                }
                VideoQuality videoQuality = (VideoQuality)EncodedFacet.VIDEO_QUALITY.decodeValue(tag.intValue());
                if (videoQuality != null) {
                    return new FacetTag("VIDEO_HD", videoQuality.toString());
                }
                return new FacetTag("", "");
            }
        }
        return new FacetTag("", "");
    }

    public static Map<String, String> findAllFacetsInTag(Integer tag) {
        HashMap<String, String> result = new HashMap<String, String>();
        MediaTypeEncoding mediaType = (MediaTypeEncoding)EncodedFacet.MEDIA_TYPE.decodeValue(tag.intValue());
        if (mediaType != null) {
            result.put("MEDIA_TYPE", mediaType.toString());
            switch (1.$SwitchMap$eu$europeana$indexing$solr$facet$value$MediaTypeEncoding[mediaType.ordinal()]) {
                case 1: {
                    ImageSize imageSize;
                    ImageColorSpace imageColorSpace;
                    ImageColorEncoding imageColorEncoding;
                    ImageAspectRatio imageAspectRatio = (ImageAspectRatio)EncodedFacet.IMAGE_ASPECT_RATIO.decodeValue(tag.intValue());
                    if (imageAspectRatio != null) {
                        result.put("IMAGE_ASPECTRATIO", imageAspectRatio.toString());
                    }
                    if ((imageColorEncoding = (ImageColorEncoding)EncodedFacet.IMAGE_COLOR_ENCODING.decodeValue(tag.intValue())) != null) {
                        result.put("COLOURPALETTE", imageColorEncoding.getHexStringWithHash());
                    }
                    if ((imageColorSpace = (ImageColorSpace)EncodedFacet.IMAGE_COLOR_SPACE.decodeValue(tag.intValue())) != null) {
                        result.put("IMAGE_COLOUR", imageColorSpace.toString());
                    }
                    if ((imageSize = (ImageSize)EncodedFacet.IMAGE_SIZE.decodeValue(tag.intValue())) == null) break;
                    result.put("IMAGE_SIZE", imageSize.toString());
                    break;
                }
                case 2: {
                    AudioQuality audioQuality;
                    AudioDuration audioDuration = (AudioDuration)EncodedFacet.AUDIO_DURATION.decodeValue(tag.intValue());
                    if (audioDuration != null) {
                        result.put("SOUND_DURATION", audioDuration.toString());
                    }
                    if ((audioQuality = (AudioQuality)EncodedFacet.AUDIO_QUALITY.decodeValue(tag.intValue())) == null) break;
                    result.put("SOUND_HQ", audioQuality.toString());
                    break;
                }
                case 3: {
                    VideoQuality videoQuality;
                    VideoDuration videoDuration = (VideoDuration)EncodedFacet.VIDEO_DURATION.decodeValue(tag.intValue());
                    if (videoDuration != null) {
                        result.put("VIDEO_DURATION", videoDuration.toString());
                    }
                    if ((videoQuality = (VideoQuality)EncodedFacet.VIDEO_QUALITY.decodeValue(tag.intValue())) == null) break;
                    result.put("VIDEO_HD", videoQuality.toString());
                    break;
                }
            }
        } else {
            result.put("MEDIA_TYPE", "Unknown");
        }
        MimeTypeEncoding mimeType = (MimeTypeEncoding)EncodedFacet.MIME_TYPE.decodeValue(tag.intValue());
        if (mimeType != null) {
            result.put("MIME_TYPE", mimeType.getValue());
        }
        return result;
    }

    @Deprecated(since="May 2021")
    public static SpellCheck convertSpellCheck(SpellCheckResponse response) {
        if (response != null) {
            SpellCheck spellCheck = new SpellCheck();
            spellCheck.correctlySpelled = response.isCorrectlySpelled();
            for (SpellCheckResponse.Suggestion suggestion : response.getSuggestions()) {
                for (int i = 0; i < suggestion.getNumFound(); ++i) {
                    LabelFrequency value = new LabelFrequency();
                    value.label = (String)suggestion.getAlternatives().get(i);
                    value.count = ((Integer)suggestion.getAlternativeFrequencies().get(i)).longValue();
                    spellCheck.suggestions.add(value);
                }
            }
            return spellCheck;
        }
        return null;
    }

    public static Map<String, String[]> separateAndLimitFacets(String[] mixedFacetArray, boolean defaultFacetsRequested) {
        HashMap<String, String[]> facetListMap = new HashMap<String, String[]>();
        if (defaultFacetsRequested) {
            facetListMap.put("technicalfacets", technicalFacetList.toArray(new String[0]));
            facetListMap.put("solrfacets", solrFacetList.toArray(new String[0]));
        } else if (ArrayUtils.isNotEmpty((Object[])mixedFacetArray)) {
            facetListMap.put("technicalfacets", ((List)CollectionUtils.intersection((Collection)technicalFacetList, Arrays.asList(mixedFacetArray))).toArray(new String[0]));
            facetListMap.put("solrfacets", ((List)CollectionUtils.intersection((Collection)solrFacetList, Arrays.asList(mixedFacetArray))).toArray(new String[0]));
        }
        if (ArrayUtils.isNotEmpty((Object[])mixedFacetArray)) {
            List customSolrFacetList = (List)CollectionUtils.subtract(Arrays.asList(mixedFacetArray), (Collection)enumFacetList);
            if (customSolrFacetList.contains("DEFAULT")) {
                customSolrFacetList.remove("DEFAULT");
            }
            String[] customSolrFacets = customSolrFacetList.toArray(new String[0]);
            if (defaultFacetsRequested) {
                facetListMap.put("customfacets", ModelUtils.safelyLimitArray((String[])customSolrFacets, (int)(150 - enumFacetList.size())));
            } else {
                facetListMap.put("customfacets", ModelUtils.safelyLimitArray((String[])customSolrFacets, (int)(150 - (((String[])facetListMap.get("technicalfacets")).length + ((String[])facetListMap.get("solrfacets")).length))));
            }
        }
        return facetListMap;
    }

    private static String[] safelyLimitArray(String[] input, int limit) {
        if (limit >= input.length) {
            return input;
        }
        return Arrays.copyOfRange(input, 0, limit);
    }

    public static String sortHasViews(FullBean bean, String jsonString) {
        try {
            if (ModelUtils.hasViewSortingRequired((FullBean)bean)) {
                return jsonString;
            }
            LinkedHashMap<String, Object> sortedHasView = new LinkedHashMap<String, Object>(((Aggregation)bean.getAggregations().get(0)).getHasView().length);
            for (String view : ((Aggregation)bean.getAggregations().get(0)).getHasView()) {
                sortedHasView.put(StringUtils.wrap((String)view, (String)"\""), null);
            }
            ObjectNode node = (ObjectNode)mapper.readValue(jsonString, ObjectNode.class);
            if (node.has("@graph")) {
                for (JsonNode jsonNode : node.get("@graph")) {
                    if (!StringUtils.contains((CharSequence)jsonNode.get("@type").toString(), (CharSequence)StringUtils.wrap((String)"ore:Aggregation", (String)"\""))) continue;
                    ModelUtils.addOrderedHasView((JsonNode)jsonNode, sortedHasView);
                    break;
                }
                return node.toString();
            }
        }
        catch (JsonProcessingException e) {
            LOG.error("Error sorting the we resources", (Throwable)e);
        }
        return jsonString;
    }

    private static void addOrderedHasView(JsonNode aggregationNode, Map<String, JsonNode> sortedHasView) {
        Iterator hasViewIterator = aggregationNode.get("edm:hasView").iterator();
        while (hasViewIterator.hasNext()) {
            JsonNode idNode = (JsonNode)hasViewIterator.next();
            sortedHasView.replace(idNode.get("@id").toString(), idNode);
            hasViewIterator.remove();
        }
        ((ArrayNode)aggregationNode.get("edm:hasView")).addAll(sortedHasView.values());
    }

    private static boolean hasViewSortingRequired(FullBean bean) {
        return ((Aggregation)bean.getAggregations().get(0)).getHasView() == null || ((Aggregation)bean.getAggregations().get(0)).getHasView().length == 1;
    }

    static {
        for (TechnicalFacetType technicalFacetType : TechnicalFacetType.values()) {
            technicalFacetList.add(technicalFacetType.name());
        }
        for (TechnicalFacetType technicalFacetType : SolrFacetType.values()) {
            solrFacetList.add(technicalFacetType.toString());
        }
        enumFacetList.addAll(technicalFacetList);
        enumFacetList.addAll(solrFacetList);
    }
}

