/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api2.v2.utils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public final class ControllerUtils {
    public static final String ALLOWED_GET_HEAD = "GET, HEAD";
    public static final String ALLOWED_GET_HEAD_POST = "GET, HEAD, POST";
    private static final String ACCEPT = "Accept";

    private ControllerUtils() {
    }

    public static String getRequestFormat(HttpServletRequest request) {
        String result = null;
        String uri = request.getRequestURI();
        if (uri.contains(".")) {
            result = uri.substring(uri.lastIndexOf(46) + 1, uri.length());
        }
        return result;
    }

    public static String getRequestedMediaType(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader(ACCEPT))) {
            return request.getHeader(ACCEPT);
        }
        return null;
    }

    public static String getRequestedContentType(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getContentType())) {
            return request.getContentType();
        }
        return null;
    }

    public static void addResponseHeaders(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Allow", ALLOWED_GET_HEAD);
    }
}

